/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiExclusionArea;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.Container;
import net.minecraft.CraftingManager;
import net.minecraft.GuiScreen;
import net.minecraft.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import shims.java.net.minecraft.text.Text;

public interface EmiRegistry {
    public CraftingManager getRecipeManager();

    public void addCategory(EmiRecipeCategory var1);

    public void addWorkstation(EmiRecipeCategory var1, EmiIngredient var2);

    public void addRecipe(EmiRecipe var1);

    public void removeRecipes(Predicate<EmiRecipe> var1);

    default public void removeRecipes(ResourceLocation id) {
        this.removeRecipes((EmiRecipe r) -> id.equals((Object)r.getId()));
    }

    public void addDeferredRecipes(Consumer<Consumer<EmiRecipe>> var1);

    public void addEmiStack(EmiStack var1);

    public void addEmiStackAfter(EmiStack var1, Predicate<EmiStack> var2);

    default public void addEmiStackAfter(EmiStack stack, EmiStack other) {
        this.addEmiStackAfter(stack, (EmiStack s) -> s.equals(other));
    }

    public void removeEmiStacks(Predicate<EmiStack> var1);

    default public void removeEmiStacks(EmiStack stack) {
        this.removeEmiStacks((EmiStack s) -> s.equals(stack));
    }

    @Deprecated
    public <T extends EmiIngredient> void addIngredientSerializer(Class<T> var1, EmiIngredientSerializer<T> var2);

    public <T extends GuiScreen> void addExclusionArea(Class<T> var1, EmiExclusionArea<T> var2);

    public void addGenericExclusionArea(EmiExclusionArea<GuiScreen> var1);

    public <T extends GuiScreen> void addDragDropHandler(Class<T> var1, EmiDragDropHandler<T> var2);

    public void addGenericDragDropHandler(EmiDragDropHandler<GuiScreen> var1);

    public <T extends GuiScreen> void addStackProvider(Class<T> var1, EmiStackProvider<T> var2);

    public void addGenericStackProvider(EmiStackProvider<GuiScreen> var1);

    public void setDefaultComparison(Object var1, Function<Comparison, Comparison> var2);

    default public void setDefaultComparison(Object key, Comparison comparison) {
        this.setDefaultComparison(key, (Comparison old) -> comparison);
    }

    default public void setDefaultComparison(EmiStack stack, Function<Comparison, Comparison> comparison) {
        this.setDefaultComparison(stack.getKey(), comparison);
    }

    default public void setDefaultComparison(EmiStack stack, Comparison comparison) {
        this.setDefaultComparison(stack.getKey(), (Comparison old) -> comparison);
    }

    @ApiStatus.Experimental
    public void addAlias(EmiIngredient var1, Text var2);

    public <T extends Container> void addRecipeHandler(Class<T> var1, EmiRecipeHandler<T> var2);
}

