/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.VanillaPlugin;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeManager;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.recipe.EmiSyntheticIngredientRecipe;
import dev.emi.emi.recipe.EmiTagRecipe;
import dev.emi.emi.registry.EmiRecipes;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiFavorite;
import dev.emi.emi.runtime.EmiHistory;
import dev.emi.emi.runtime.EmiSidebars;
import dev.emi.emi.screen.BoMScreen;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.screen.RecipeScreen;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.EntityPlayer;
import net.minecraft.GuiContainer;
import net.minecraft.GuiInventory;
import net.minecraft.GuiScreen;
import net.minecraft.Minecraft;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class EmiApi {
    public static List<EmiStack> getIndexStacks() {
        return EmiStackList.stacks;
    }

    public static EmiRecipeManager getRecipeManager() {
        return EmiRecipes.manager;
    }

    public static boolean isCheatMode() {
        return EmiConfig.cheatMode && Minecraft.inDevMode();
    }

    public static String getSearchText() {
        return EmiScreenManager.search.getText();
    }

    public static void setSearchText(String text) {
        EmiScreenManager.search.setText(text);
    }

    public static boolean isSearchFocused() {
        return EmiScreenManager.search.isFocused();
    }

    public static EmiStackInteraction getHoveredStack(int mouseX, int mouseY, boolean includeStandard) {
        return EmiScreenManager.getHoveredStack(mouseX, mouseY, includeStandard);
    }

    public static EmiStackInteraction getHoveredStack(boolean includeStandard) {
        return EmiScreenManager.getHoveredStack(EmiScreenManager.lastMouseX, EmiScreenManager.lastMouseY, includeStandard);
    }

    @ApiStatus.Experimental
    @Nullable
    public static EmiRecipe getRecipeContext(EmiIngredient stack) {
        if (stack instanceof EmiFavorite) {
            EmiFavorite fav = (EmiFavorite)stack;
            return fav.getRecipe();
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static GuiContainer getHandledScreen() {
        GuiScreen s = Minecraft.getMinecraft().currentScreen;
        if (s instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)s;
            return container;
        }
        if (s instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)s;
            return rs.old;
        }
        if (s instanceof BoMScreen) {
            BoMScreen bs = (BoMScreen)s;
            return bs.old;
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static void displayAllRecipes() {
        EmiRecipeManager manager = EmiApi.getRecipeManager();
        EmiApi.setPages(manager.getCategories().stream().collect(Collectors.toMap(c -> c, manager::getRecipes)), EmiStack.EMPTY);
    }

    @Environment(value=EnvType.CLIENT)
    public static void displayRecipeCategory(EmiRecipeCategory category) {
        EmiApi.setPages(Collections.singletonMap(category, EmiApi.getRecipeManager().getRecipes(category)), EmiStack.EMPTY);
    }

    @Environment(value=EnvType.CLIENT)
    public static void displayRecipe(EmiRecipe recipe) {
        EmiApi.setPages(Collections.singletonMap(recipe.getCategory(), Collections.singletonList(recipe)), EmiStack.EMPTY);
    }

    @Environment(value=EnvType.CLIENT)
    public static void displayRecipes(EmiIngredient stack) {
        if (stack instanceof EmiFavorite) {
            EmiFavorite fav = (EmiFavorite)stack;
            stack = fav.getStack();
        }
        if (stack instanceof TagEmiIngredient) {
            TagEmiIngredient tag = (TagEmiIngredient)stack;
            for (EmiRecipe recipe : EmiApi.getRecipeManager().getRecipes(VanillaPlugin.TAG)) {
                if (!(recipe instanceof EmiTagRecipe)) continue;
                EmiTagRecipe tr = (EmiTagRecipe)recipe;
                if (!tr.key.equals(tag.key)) continue;
                EmiApi.setPages(Collections.singletonMap(VanillaPlugin.TAG, Collections.singletonList(recipe)), stack);
                break;
            }
        } else if (stack instanceof ListEmiIngredient) {
            ListEmiIngredient list = (ListEmiIngredient)stack;
            EmiApi.setPages(Collections.singletonMap(VanillaPlugin.INGREDIENT, Collections.singletonList(new EmiSyntheticIngredientRecipe(stack))), stack);
        } else if (stack.getEmiStacks().size() == 1) {
            EmiStack es = stack.getEmiStacks().get(0);
            EmiApi.setPages(EmiApi.mapRecipes(EmiApi.pruneSources(EmiApi.getRecipeManager().getRecipesByOutput(es), es)), stack);
            EmiApi.focusRecipe(BoM.getRecipe(es));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void displayUses(EmiIngredient stack) {
        if (!stack.isEmpty()) {
            EmiStack zero = stack.getEmiStacks().get(0);
            Map<EmiRecipeCategory, List<EmiRecipe>> map = EmiApi.mapRecipes(Stream.concat(EmiApi.pruneUses(EmiApi.getRecipeManager().getRecipesByInput(zero), stack).stream(), EmiRecipes.byWorkstation.getOrDefault(zero, Collections.emptyList()).stream()).distinct().collect(Collectors.toList()));
            EmiApi.setPages(map, stack);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void viewRecipeTree() {
        GuiScreen s;
        if (Minecraft.getMinecraft().currentScreen == null) {
            Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new GuiInventory((EntityPlayer)Minecraft.getMinecraft().thePlayer));
        }
        if ((s = Minecraft.getMinecraft().currentScreen) instanceof GuiContainer) {
            GuiContainer hs = (GuiContainer)s;
            EmiApi.push();
            Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new BoMScreen(hs));
        } else if (s instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)s;
            EmiApi.push();
            Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new BoMScreen(rs.old));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void focusRecipe(EmiRecipe recipe) {
        GuiScreen s = Minecraft.getMinecraft().currentScreen;
        if (s instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)s;
            rs.focusRecipe(recipe);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void push() {
        GuiScreen s = Minecraft.getMinecraft().currentScreen;
        if (s instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)s;
            EmiHistory.push(rs);
        } else if (s instanceof BoMScreen) {
            BoMScreen bs = (BoMScreen)s;
            EmiHistory.push(bs);
        } else {
            EmiHistory.clear();
        }
    }

    private static List<EmiRecipe> pruneSources(List<EmiRecipe> list, EmiStack context) {
        return list.stream().filter(r -> r.getOutputs().stream().anyMatch(i -> i.isEqual(context))).collect(Collectors.toList());
    }

    private static List<EmiRecipe> pruneUses(List<EmiRecipe> list, EmiIngredient context) {
        return list.stream().filter(r -> r.getInputs().stream().anyMatch(i -> EmiApi.containsAll(i, context)) || r.getCatalysts().stream().anyMatch(i -> EmiApi.containsAll(i, context))).sorted((a, b) -> EmiApi.getSmallestPresence(a, context) - EmiApi.getSmallestPresence(b, context)).collect(Collectors.toList());
    }

    private static int getSmallestPresence(EmiRecipe recipe, EmiIngredient context) {
        int ideal = context.getEmiStacks().size();
        int smallestPresence = Integer.MAX_VALUE;
        for (EmiIngredient i : recipe.getInputs()) {
            if (EmiApi.containsAll(i, context) && (smallestPresence = Math.min(smallestPresence, i.getEmiStacks().size())) <= ideal) break;
        }
        return smallestPresence;
    }

    private static Map<EmiRecipeCategory, List<EmiRecipe>> mapRecipes(List<EmiRecipe> list) {
        HashMap map = Maps.newHashMap();
        for (EmiRecipe recipe : list) {
            map.computeIfAbsent(recipe.getCategory(), k -> Lists.newArrayList()).add(recipe);
        }
        return map;
    }

    private static boolean containsAll(EmiIngredient collection, EmiIngredient ingredient) {
        block0: for (EmiStack ing : ingredient.getEmiStacks()) {
            for (EmiStack col : collection.getEmiStacks()) {
                if (!col.isEqual(ing)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private static void setPages(Map<EmiRecipeCategory, List<EmiRecipe>> recipes, EmiIngredient stack) {
        if (!(recipes = recipes.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(e -> (EmiRecipeCategory)e.getKey(), e -> (List)e.getValue()))).isEmpty()) {
            GuiScreen s;
            EmiSidebars.lookup(stack);
            if (EmiApi.getHandledScreen() == null) {
                Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new GuiInventory((EntityPlayer)Minecraft.getMinecraft().thePlayer));
            }
            if ((s = Minecraft.getMinecraft().currentScreen) instanceof GuiContainer) {
                GuiContainer hs = (GuiContainer)s;
                EmiApi.push();
                Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new RecipeScreen(hs, recipes));
            } else if (s instanceof BoMScreen) {
                BoMScreen bs = (BoMScreen)s;
                EmiApi.push();
                Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new RecipeScreen(bs.old, recipes));
            } else if (s instanceof RecipeScreen) {
                RecipeScreen rs = (RecipeScreen)s;
                EmiApi.push();
                RecipeScreen n = new RecipeScreen(rs.old, recipes);
                Minecraft.getMinecraft().displayGuiScreen((GuiScreen)n);
                n.focusCategory(rs.getFocusedCategory());
            }
        }
    }
}

