/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi;

import com.google.common.collect.Sets;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.Prototype;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.config.EffectLocation;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.handler.CookingRecipeHandler;
import dev.emi.emi.handler.CraftingRecipeHandler;
import dev.emi.emi.handler.InventoryRecipeHandler;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import dev.emi.emi.recipe.EmiCookingRecipe;
import dev.emi.emi.recipe.EmiFuelRecipe;
import dev.emi.emi.recipe.EmiShapedRecipe;
import dev.emi.emi.recipe.EmiShapelessRecipe;
import dev.emi.emi.recipe.EmiTagRecipe;
import dev.emi.emi.recipe.special.EmiAnvilEnchantRecipe;
import dev.emi.emi.recipe.special.EmiAnvilRepairItemRecipe;
import dev.emi.emi.recipe.special.EmiAnvilRepairToolRecipe;
import dev.emi.emi.recipe.special.EmiArmorDyeRecipe;
import dev.emi.emi.recipe.special.EmiFireworkRocketRecipe;
import dev.emi.emi.recipe.special.EmiFireworkStarFadeRecipe;
import dev.emi.emi.recipe.special.EmiFireworkStarRecipe;
import dev.emi.emi.recipe.special.EmiMapCloningRecipe;
import dev.emi.emi.recipe.special.EmiRepairItemRecipe;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.stack.serializer.ItemEmiStackSerializer;
import dev.emi.emi.stack.serializer.ListEmiIngredientSerializer;
import dev.emi.emi.stack.serializer.TagEmiIngredientSerializer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import moddedmite.emi.MITEPlugin;
import moddedmite.emi.api.EMIGuiContainerCreative;
import moddedmite.emi.api.EMIShapelessRecipes;
import moddedmite.emi.recipe.special.EmiAnvilDisenchantRecipe;
import net.minecraft.Block;
import net.minecraft.BlockAnvil;
import net.minecraft.ContainerFurnace;
import net.minecraft.ContainerPlayer;
import net.minecraft.ContainerWorkbench;
import net.minecraft.Enchantment;
import net.minecraft.EnchantmentHelper;
import net.minecraft.FurnaceRecipes;
import net.minecraft.GuiContainerCreative;
import net.minecraft.IRecipe;
import net.minecraft.InventoryEffectRenderer;
import net.minecraft.Item;
import net.minecraft.ItemAnvilBlock;
import net.minecraft.ItemAppleGold;
import net.minecraft.ItemArmor;
import net.minecraft.ItemBook;
import net.minecraft.ItemCarrotOnAStick;
import net.minecraft.ItemExpBottle;
import net.minecraft.ItemFishingRod;
import net.minecraft.ItemFlintAndSteel;
import net.minecraft.ItemHoe;
import net.minecraft.ItemMattock;
import net.minecraft.ItemMeat;
import net.minecraft.ItemStack;
import net.minecraft.ItemTool;
import net.minecraft.Minecraft;
import net.minecraft.RecipeFireworks;
import net.minecraft.RecipesArmorDyes;
import net.minecraft.RecipesMapCloning;
import net.minecraft.RecipesMapExtending;
import net.minecraft.ResourceLocation;
import net.minecraft.ShapedRecipes;
import net.minecraft.ShapelessRecipes;
import net.minecraft.TileEntityFurnace;
import shims.java.com.unascribed.retroemi.PredicateAsSet;
import shims.java.com.unascribed.retroemi.RetroEMI;
import shims.java.net.minecraft.tag.TagKey;
import shims.java.net.minecraft.util.SyntheticIdentifier;

@EmiEntrypoint
public class VanillaPlugin
implements EmiPlugin {
    public static EmiRecipeCategory TAG = new EmiRecipeCategory(new ResourceLocation("emi:tag"), EmiStack.of(Item.nameTag), VanillaPlugin.simplifiedRenderer(240, 208), EmiRecipeSorting.none());
    public static EmiRecipeCategory INGREDIENT = new EmiRecipeCategory(new ResourceLocation("emi:ingredient"), EmiStack.of(Item.compass), VanillaPlugin.simplifiedRenderer(240, 208));
    public static EmiRecipeCategory RESOLUTION = new EmiRecipeCategory(new ResourceLocation("emi:resolution"), EmiStack.of(Item.compass), VanillaPlugin.simplifiedRenderer(240, 208));

    @Override
    public void initialize(EmiInitRegistry registry) {
        registry.addIngredientSerializer(ItemEmiStack.class, new ItemEmiStackSerializer());
        registry.addIngredientSerializer(TagEmiIngredient.class, new TagEmiIngredientSerializer());
        registry.addIngredientSerializer(ListEmiIngredient.class, new ListEmiIngredientSerializer());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void register(EmiRegistry registry) {
        void var6_15;
        registry.addIngredientSerializer(ItemEmiStack.class, new ItemEmiStackSerializer());
        registry.addIngredientSerializer(TagEmiIngredient.class, new TagEmiIngredientSerializer());
        registry.addCategory(VanillaEmiRecipeCategories.CRAFTING);
        registry.addCategory(VanillaEmiRecipeCategories.SMELTING);
        registry.addCategory(VanillaEmiRecipeCategories.ANVIL_REPAIRING);
        registry.addCategory(VanillaEmiRecipeCategories.BREWING);
        registry.addCategory(VanillaEmiRecipeCategories.WORLD_INTERACTION);
        registry.addCategory(VanillaEmiRecipeCategories.FUEL);
        registry.addCategory(VanillaEmiRecipeCategories.INFO);
        registry.addCategory(TAG);
        registry.addCategory(INGREDIENT);
        registry.addCategory(RESOLUTION);
        if (EmiConfig.moreWorkstation) {
            for (int i2 = 4; i2 < 11; ++i2) {
                registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, EmiStack.of(new ItemStack(Block.workbench, 1, 0)));
                registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, EmiStack.of(new ItemStack(Block.workbench, 1, 12)));
                registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, EmiStack.of(new ItemStack(Block.workbench, 1, i2)));
            }
            for (Block block : Block.blocksList) {
                if (!(block instanceof BlockAnvil)) continue;
                BlockAnvil blockAnvil = (BlockAnvil)block;
                registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of((Block)blockAnvil));
            }
        } else {
            registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, EmiStack.of(new ItemStack(Block.workbench, 1, 7)));
            registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of(new ItemStack((Block)Block.anvil, 1, 0)));
        }
        registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiStack.of(Block.furnaceIdle));
        registry.addWorkstation(VanillaEmiRecipeCategories.BREWING, EmiStack.of(Item.brewingStand));
        registry.addWorkstation(VanillaEmiRecipeCategories.WORLD_INTERACTION, EmiStack.of((Block)Block.grass));
        registry.addRecipeHandler(ContainerPlayer.class, new InventoryRecipeHandler());
        registry.addRecipeHandler(ContainerWorkbench.class, new CraftingRecipeHandler());
        registry.addRecipeHandler(ContainerFurnace.class, new CookingRecipeHandler(VanillaEmiRecipeCategories.SMELTING));
        registry.addExclusionArea(GuiContainerCreative.class, (screen, consumer) -> {
            int left = ((EMIGuiContainerCreative)screen).getGuiLeft();
            int top = ((EMIGuiContainerCreative)screen).getGuiTop();
            int width = ((EMIGuiContainerCreative)screen).getxSize();
            int bottom = top + ((EMIGuiContainerCreative)screen).getySize();
            consumer.accept(new Bounds(left, top - 28, width, 28));
            consumer.accept(new Bounds(left, bottom, width, 28));
        });
        registry.addGenericExclusionArea((screen, consumer) -> {
            if (screen instanceof InventoryEffectRenderer) {
                InventoryEffectRenderer inv = (InventoryEffectRenderer)screen;
                Minecraft client = Minecraft.getMinecraft();
                Collection collection = client.thePlayer.getActivePotionEffects();
                int size = collection.size();
                if (client.thePlayer.isMalnourished()) {
                    ++size;
                }
                if (client.thePlayer.isInsulinResistant()) {
                    ++size;
                }
                if (client.thePlayer.is_cursed) {
                    ++size;
                }
                if (size > 0) {
                    int right;
                    int rightWidth;
                    int k = 33;
                    if (size > 5) {
                        k = 132 / (size - 1);
                    }
                    if ((rightWidth = inv.width - (right = ((EMIGuiContainerCreative)inv).getGuiLeft() + ((EMIGuiContainerCreative)inv).getxSize() + 2)) >= 32) {
                        int left;
                        int width;
                        int top = ((EMIGuiContainerCreative)inv).getGuiTop();
                        int height = (size - 1) * k + 32;
                        if (EmiConfig.effectLocation == EffectLocation.TOP) {
                            top = ((EMIGuiContainerCreative)inv).getGuiTop() - 34;
                            if (screen instanceof GuiContainerCreative) {
                                top -= 28;
                                if (EmiAgnos.isForge() || EmiAgnos.isModLoaded("rusted_iron_core")) {
                                    top -= 22;
                                }
                            }
                            int xOff = 34;
                            if (size == 1) {
                                xOff = 122;
                            } else if (size > 5) {
                                xOff = (((EMIGuiContainerCreative)inv).getxSize() - 32) / (size - 1);
                            }
                            width = Math.max(122, (size - 1) * xOff + 32);
                            left = ((EMIGuiContainerCreative)inv).getGuiLeft() + (((EMIGuiContainerCreative)inv).getxSize() - width) / 2;
                            height = 32;
                        } else {
                            left = switch (EmiConfig.effectLocation) {
                                case EffectLocation.LEFT_COMPRESSED -> ((EMIGuiContainerCreative)inv).getGuiLeft() - 2 - 32;
                                case EffectLocation.LEFT -> ((EMIGuiContainerCreative)inv).getGuiLeft() - 2 - 120;
                                default -> right;
                            };
                            width = switch (EmiConfig.effectLocation) {
                                case EffectLocation.LEFT, EffectLocation.RIGHT -> 120;
                                case EffectLocation.LEFT_COMPRESSED, EffectLocation.RIGHT_COMPRESSED -> 32;
                                default -> 32;
                            };
                        }
                        consumer.accept(new Bounds(left, top, width, height));
                    }
                }
            }
        });
        Comparison potionComparison = Comparison.of((a, b) -> RetroEMI.getEffects(a).equals(RetroEMI.getEffects(b)));
        registry.setDefaultComparison((Object)Item.potion, potionComparison);
        registry.setDefaultComparison((Object)Item.enchantedBook, Comparison.compareNbt());
        EmiStack prev = EmiStack.of((Item)Item.enchantedBook);
        Enchantment[] enchantmentArray = Enchantment.enchantmentsList;
        int block = enchantmentArray.length;
        boolean bl = false;
        while (var6_15 < block) {
            Enchantment ench = enchantmentArray[var6_15];
            if (ench != null) {
                ItemStack itemStack = new ItemStack((Item)Item.enchantedBook);
                EnchantmentHelper.setEnchantments(Map.of(ench.effectId, ench.getNumLevels()), (ItemStack)itemStack);
                prev = EmiStack.of(itemStack);
                registry.addEmiStackAfter(prev, prev);
            }
            ++var6_15;
        }
        PredicateAsSet<Item> hiddenItems = i -> {
            for (Predicate<EmiStack> inv : EmiStackList.invalidators) {
                if (!inv.test(EmiStack.of(i))) continue;
                return true;
            }
            return false;
        };
        for (Item item : EmiRepairItemRecipe.TOOLS) {
            if (hiddenItems.contains(item)) continue;
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiRepairItemRecipe(i3, VanillaPlugin.synthetic("crafting/repairing", EmiUtil.subId(i3))));
        }
        for (IRecipe iRecipe : registry.getRecipeManager().getRecipeList()) {
            if (iRecipe instanceof RecipesMapExtending) {
                RecipesMapExtending map = (RecipesMapExtending)iRecipe;
                EmiStack paper = EmiStack.of(Item.paper);
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(List.of(paper, paper, paper, paper, EmiStack.of((Item)Item.map), paper, paper, paper, paper), EmiStack.of((Item)Item.map), new ResourceLocation("minecraft", "map_extending"), false, null, recipe.getUnmodifiedDifficulty()), iRecipe);
                continue;
            }
            if (iRecipe instanceof ShapedRecipes) {
                ShapedRecipes shapedRecipes = (ShapedRecipes)iRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiShapedRecipe(shaped, (int)shaped.getUnmodifiedDifficulty()), iRecipe);
                continue;
            }
            if (iRecipe instanceof ShapelessRecipes) {
                ShapelessRecipes shapeless = (ShapelessRecipes)iRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiShapelessRecipe((EMIShapelessRecipes)shapeless, shapeless, shapeless.getUnmodifiedDifficulty()), iRecipe);
                continue;
            }
            if (iRecipe instanceof RecipesArmorDyes) {
                RecipesArmorDyes dye = (RecipesArmorDyes)iRecipe;
                for (Item i4 : EmiArmorDyeRecipe.DYEABLE_ITEMS) {
                    if (hiddenItems.contains(i4)) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiArmorDyeRecipe(i4, VanillaPlugin.synthetic("crafting/dying", EmiUtil.subId(i4))), iRecipe);
                }
                continue;
            }
            if (iRecipe instanceof RecipeFireworks) {
                RecipeFireworks recipeFireworks = (RecipeFireworks)iRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkStarRecipe(new ResourceLocation("minecraft", "firework_star")), iRecipe);
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkStarFadeRecipe(new ResourceLocation("minecraft", "firework_star_fade")), iRecipe);
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkRocketRecipe(new ResourceLocation("minecraft", "firework_rocket")), iRecipe);
                continue;
            }
            if (iRecipe instanceof RecipesMapCloning) {
                RecipesMapCloning map = (RecipesMapCloning)iRecipe;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiMapCloningRecipe(new ResourceLocation("minecraft", "map_cloning")), iRecipe);
                continue;
            }
            MITEPlugin.addCustomIRecipes(iRecipe, registry);
        }
        for (Map.Entry entry : FurnaceRecipes.smelting().getSmeltingList().entrySet()) {
            int id = (Integer)entry.getKey();
            ItemStack itemStack = new ItemStack(Item.itemsList[id]);
            ItemStack out = (ItemStack)entry.getValue();
            TileEntityFurnace furnace = new TileEntityFurnace();
            int n = furnace.getFuelHeatLevel();
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe(new ResourceLocation("minecraft", "furnace/" + id), in, out, VanillaEmiRecipeCategories.SMELTING, fuel, out.getExperienceReward()));
        }
        for (Iterator<Object> iterator : Item.itemsList) {
            ItemStack is;
            if (iterator == null || hiddenItems.contains((Item)iterator)) continue;
            if (iterator.isRepairable()) {
                ItemTool ti;
                ItemArmor ai;
                if (iterator instanceof ItemArmor && (ai = (ItemArmor)iterator).getArmorMaterial() != null && ai.getArmorMaterial().getMaterialMobility() != 0) {
                    Item item = Item.itemsList[ai.getArmorMaterial().getMaterialMobility()];
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of(i5), EmiStack.of(material), new ResourceLocation("minecraft", "anvil/armor/" + SyntheticIdentifier.describe(i5) + "/" + SyntheticIdentifier.describe(material))));
                } else if (iterator instanceof ItemTool && (ti = (ItemTool)iterator).getToolMaterial().getMaterialMobility() != 0) {
                    Item item = Item.itemsList[ti.getToolMaterial().getMaterialMobility()];
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of(i5), EmiStack.of(material), new ResourceLocation("minecraft", "anvil/tool/" + SyntheticIdentifier.describe(i5) + "/" + SyntheticIdentifier.describe(material))));
                }
            }
            if (iterator.isDamageable() && !(iterator instanceof ItemAnvilBlock)) {
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRepairToolRecipe((Item)i5, new ResourceLocation("minecraft", "anvil/repair/tool/" + SyntheticIdentifier.describe(i5))));
                if (!(iterator instanceof ItemFishingRod || iterator instanceof ItemCarrotOnAStick || iterator instanceof ItemFlintAndSteel)) {
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRepairItemRecipe((Item)i5, new ResourceLocation("minecraft", "anvil/repair/nugget/" + SyntheticIdentifier.describe(i5))));
                }
            }
            if (!(is = new ItemStack(iterator)).isEnchantable() || is.getItem() instanceof ItemAppleGold || is.getItem() instanceof ItemBook || is.getItem() instanceof ItemExpBottle || is.getItem() instanceof ItemCarrotOnAStick) continue;
            for (Enchantment enchantment : EmiAnvilEnchantRecipe.ENCHANTMENTS) {
                if (!enchantment.canEnchantItem(is.getItem())) continue;
                int max = enchantment.getNumLevels();
                for (int min = enchantment.getLevel(is); min <= max; ++min) {
                    int finalMin = min;
                    if (max != min) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilEnchantRecipe((Item)i5, e, finalMin, new ResourceLocation("minecraft", "anvil/enchant/" + SyntheticIdentifier.describe(i5) + "/" + e.effectId + "/" + SyntheticIdentifier.describe(finalMin))));
                }
            }
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilDisenchantRecipe((Item)i5, new ResourceLocation("minecraft", "anvil/disenchant/" + SyntheticIdentifier.describe(i5))));
        }
        EmiAgnos.addBrewingRecipes(registry);
        for (int i6 = 0; i6 < Item.itemsList.length; ++i6) {
            Item item = Item.getItem((int)i6);
            if (item instanceof ItemHoe) {
                ItemHoe itemHoe = (ItemHoe)item;
                VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of(Block.dirt), EmiStack.of((Item)itemHoe), EmiStack.of(Block.tilledField), new ResourceLocation("minecraft", item + "/tilling")));
            }
            if (item instanceof ItemMattock) {
                ItemMattock itemMattock = (ItemMattock)item;
                VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of(Block.dirt), EmiStack.of((Item)itemMattock), EmiStack.of(Block.tilledField), new ResourceLocation("MITE", item + "/tilling")));
            }
            if (!(item instanceof ItemMeat)) continue;
            ItemMeat itemMeat = (ItemMeat)item;
            if (itemMeat.is_cooked || itemMeat == Item.rottenFlesh) continue;
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((Item)itemMeat), EmiStack.of((Block)Block.fire), EmiStack.of((Item)itemMeat.getCookedItem()), new ResourceLocation("MITE", item + String.valueOf(item.itemID) + "/fire")));
        }
        for (Item item : EmiArmorDyeRecipe.DYEABLE_ITEMS) {
            if (!hiddenItems.contains(item)) continue;
            EmiStack cauldron = EmiStack.of(Item.cauldron);
            EmiStack emiStack = EmiStack.of((Block)Block.waterMoving);
            int uniq = EmiUtil.RANDOM.nextInt();
            VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/cauldron_washing", EmiUtil.subId(item))).leftInput(EmiStack.EMPTY, s -> new GeneratedSlotWidget(r -> {
                ItemStack stack = new ItemStack(item);
                if (stack.hasTagCompound() && stack.getTagCompound().hasKey("display")) {
                    stack.getTagCompound().getCompoundTag("display").removeTag("Color");
                }
                return EmiStack.of(stack);
            }, uniq, s.getBounds().x(), s.getBounds().y())).rightInput(cauldron, true).rightInput(waterThird, false).output(EmiStack.of(item)).supportsRecipeTree(false).build());
        }
        EmiStack water = EmiStack.of(Block.waterStill);
        EmiStack emiStack = EmiStack.of(Block.waterStill);
        EmiStack lava = EmiStack.of(Block.lavaStill);
        EmiStack emiStack2 = water.copy().setRemainder(water);
        EmiStack lavaCatalyst = lava.copy().setRemainder(lava);
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_spring", "minecraft/water")).leftInput(waterCatalyst).rightInput(waterCatalyst, false).output(EmiStack.of(Block.waterStill)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/cobblestone")).leftInput(waterCatalyst).rightInput(lavaCatalyst, false).output(EmiStack.of(Block.cobblestone)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/stone")).leftInput(waterCatalyst).rightInput(lavaCatalyst, false).output(EmiStack.of(Block.stone)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/obsidian")).leftInput(lava).rightInput(waterCatalyst, false).output(EmiStack.of(Block.obsidian)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of(Item.glassBottle), waterBottle, EmiStack.of(new ItemStack((Item)Item.potion)), VanillaPlugin.synthetic("world/unique", "minecraft/water_bottle")));
        for (TagKey tagKey : EmiTags.TAGS) {
            if (new TagEmiIngredient(tagKey, 1L).getEmiStacks().size() <= 1) continue;
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiTagRecipe(key));
        }
        VanillaPlugin.addFuel(registry, hiddenItems);
    }

    private static void addFuel(EmiRegistry registry, PredicateAsSet<Item> hiddenItems) {
        Map<Prototype, Integer> fuelMap = EmiAgnos.getFuelMap();
        Map<Prototype, Integer> heatMap = EmiAgnos.getHeatMap();
        VanillaPlugin.compressRecipesToTags(fuelMap.keySet(), Comparator.comparingInt(fuelMap::get), tag -> {
            EmiIngredient stack = EmiIngredient.of(tag);
            Prototype item = Prototype.of(stack.getEmiStacks().get(0).getItemStack());
            int time = fuelMap.getOrDefault(item, 0);
            int heat = heatMap.getOrDefault(item, 0);
            registry.addRecipe(new EmiFuelRecipe(stack, time, heat, VanillaPlugin.synthetic("fuel/tag", EmiUtil.subId(tag.id()))));
        }, item -> {
            if (!hiddenItems.contains(item.getItem())) {
                int time = (Integer)fuelMap.get(item);
                int heat = (Integer)heatMap.get(item);
                registry.addRecipe(new EmiFuelRecipe(EmiStack.of(item), time, heat, VanillaPlugin.synthetic("fuel/item", EmiUtil.subId(item.getItem()) + "/" + item.toStack().getItemSubtype())));
            }
        });
    }

    private static void compressRecipesToTags(Set<Prototype> stacks, Comparator<Prototype> comparator, Consumer<TagKey<Prototype>> tagConsumer, Consumer<Prototype> itemConsumer) {
        HashSet handled = Sets.newHashSet();
        block0: for (TagKey<Prototype> key : EmiTags.getTags(Prototype.class)) {
            Prototype base;
            List<Prototype> items = key.get();
            if (items.size() < 2 || !stacks.contains(base = items.get(0))) continue;
            for (int i = 1; i < items.size(); ++i) {
                Prototype item = items.get(i);
                if (!stacks.contains(item) || comparator.compare(base, item) != 0) continue block0;
            }
            if (handled.containsAll(items)) continue;
            handled.addAll(items);
            tagConsumer.accept(key);
        }
        for (Prototype item : stacks) {
            if (handled.contains(item)) continue;
            itemConsumer.accept(item);
        }
    }

    private static ResourceLocation synthetic(String type, String name) {
        return new ResourceLocation("emi", "/" + type + "/" + name);
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn("Exception when parsing EMI recipe (no ID available)", e);
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier, IRecipe recipe) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn("Exception when parsing vanilla recipe " + recipe, e);
        }
    }

    private static EmiRenderable simplifiedRenderer(int u, int v) {
        return (raw, x, y, delta) -> {
            EmiDrawContext context = EmiDrawContext.wrap(raw);
            context.drawTexture(EmiRenderHelper.WIDGETS, x, y, u, v, 16, 16);
        };
    }

    private static void addConcreteRecipe(EmiRegistry registry, Block powder, EmiStack water, Block result) {
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of(powder), water, EmiStack.of(result), VanillaPlugin.synthetic("world/concrete", EmiUtil.subId(result))));
    }

    private static EmiRecipe basicWorld(EmiIngredient left, EmiIngredient right, EmiStack output, ResourceLocation id) {
        return VanillaPlugin.basicWorld(left, right, output, id, true);
    }

    private static EmiRecipe basicWorld(EmiIngredient left, EmiIngredient right, EmiStack output, ResourceLocation id, boolean catalyst) {
        return EmiWorldInteractionRecipe.builder().id(id).leftInput(left).rightInput(right, catalyst).output(output).build();
    }

    static {
        VanillaEmiRecipeCategories.CRAFTING = new EmiRecipeCategory(new ResourceLocation("minecraft:crafting"), EmiStack.of(new ItemStack(Block.workbench, 1, 7)), VanillaPlugin.simplifiedRenderer(240, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.SMELTING = new EmiRecipeCategory(new ResourceLocation("minecraft:smelting"), EmiStack.of(Block.furnaceIdle), VanillaPlugin.simplifiedRenderer(224, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.ANVIL_REPAIRING = new EmiRecipeCategory(new ResourceLocation("emi:anvil_repairing"), EmiStack.of((Block)Block.anvil), VanillaPlugin.simplifiedRenderer(240, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.BREWING = new EmiRecipeCategory(new ResourceLocation("minecraft:brewing"), EmiStack.of(Item.brewingStand), VanillaPlugin.simplifiedRenderer(224, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.WORLD_INTERACTION = new EmiRecipeCategory(new ResourceLocation("emi:world_interaction"), EmiStack.of(Item.itemsList[Block.grass.blockID]), VanillaPlugin.simplifiedRenderer(208, 224), EmiRecipeSorting.none());
        EmiRenderable flame = (matrices, x, y, delta) -> EmiTexture.FULL_FLAME.render(matrices, x + 1, y + 1, delta);
        VanillaEmiRecipeCategories.FUEL = new EmiRecipeCategory(new ResourceLocation("emi:fuel"), flame, flame, EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.INFO = new EmiRecipeCategory(new ResourceLocation("emi:info"), EmiStack.of(Item.writableBook), VanillaPlugin.simplifiedRenderer(208, 224), EmiRecipeSorting.none());
    }
}

