/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.data.EmiRecipeCategoryProperties;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.registry.EmiRecipeFiller;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.Block;
import net.minecraft.Container;
import net.minecraft.EntityPlayer;
import net.minecraft.GuiContainer;
import net.minecraft.InventoryCrafting;
import net.minecraft.Item;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import shims.java.net.minecraft.util.NumericIdentifier;

public class EmiUtil {
    public static final Random RANDOM = new Random();
    static Minecraft minecraft = Minecraft.getMinecraft();

    public static String subId(ResourceLocation id) {
        return id.getResourceDomain() + "/" + id.getResourcePath();
    }

    public static String subId(Block block) {
        return "block/" + EmiUtil.subId(new NumericIdentifier(block.blockID));
    }

    public static String subId(Item item) {
        return "item/" + EmiUtil.subId(new NumericIdentifier(item.itemID));
    }

    public static boolean showAdvancedTooltips() {
        Minecraft client = Minecraft.getMinecraft();
        return client.gameSettings.advancedItemTooltips;
    }

    public static String translateId(String prefix, ResourceLocation id) {
        return prefix + id.getResourceDomain() + "." + id.getResourcePath().replace('/', '.');
    }

    public static String getModName(String namespace) {
        return EmiAgnos.getModName(namespace);
    }

    public static List<String> getStackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)writer, true));
        return Arrays.asList(writer.getBuffer().toString().split("\n"));
    }

    public static InventoryCrafting getCraftingInventory() {
        return new InventoryCrafting(new Container((EntityPlayer)EmiUtil.minecraft.thePlayer){

            public boolean canInteractWith(EntityPlayer player) {
                return false;
            }

            public void detectAndSendChanges() {
            }
        }, 3, 3);
    }

    public static InventoryCrafting getSoulforgeInventory() {
        return new InventoryCrafting(new Container((EntityPlayer)EmiUtil.minecraft.thePlayer){

            public boolean canInteractWith(EntityPlayer player) {
                return false;
            }

            public void detectAndSendChanges() {
            }
        }, 4, 4);
    }

    public static int getOutputCount(EmiRecipe recipe, EmiIngredient stack) {
        int count = 0;
        for (EmiStack o : recipe.getOutputs()) {
            if (!stack.getEmiStacks().contains(o)) continue;
            count = (int)((long)count + o.getAmount());
        }
        return count;
    }

    public static EmiRecipe getPreferredRecipe(EmiIngredient ingredient, EmiPlayerInventory inventory, boolean requireCraftable) {
        if (ingredient.getEmiStacks().size() == 1 && !ingredient.isEmpty()) {
            EmiStack stack = ingredient.getEmiStacks().get(0);
            return EmiUtil.getPreferredRecipe(EmiApi.getRecipeManager().getRecipesByOutput(stack), inventory, requireCraftable);
        }
        return null;
    }

    public static EmiRecipe getPreferredRecipe(List<EmiRecipe> recipes, EmiPlayerInventory inventory, boolean requireCraftable) {
        EmiRecipe preferred = null;
        int preferredWeight = -1;
        GuiContainer hs = EmiApi.getHandledScreen();
        EmiCraftContext context = new EmiCraftContext(hs, inventory, EmiCraftContext.Type.CRAFTABLE);
        for (EmiRecipe recipe : recipes) {
            int weight = 0;
            EmiRecipeHandler handler = EmiRecipeFiller.getFirstValidHandler(recipe, hs);
            if (handler != null && handler.canCraft(recipe, context)) {
                weight += 16;
            } else {
                if (requireCraftable) continue;
                if (inventory.canCraft(recipe)) {
                    weight += 8;
                }
            }
            if (BoM.isRecipeEnabled(recipe)) {
                weight += 4;
            }
            if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING) {
                weight += 2;
            }
            if (weight > preferredWeight) {
                preferredWeight = weight;
                preferred = recipe;
                continue;
            }
            if (weight != preferredWeight || EmiRecipeCategoryProperties.getOrder(recipe.getCategory()) >= EmiRecipeCategoryProperties.getOrder(preferred.getCategory())) continue;
            preferredWeight = weight;
            preferred = recipe;
        }
        return preferred;
    }

    public static EmiRecipe getRecipeResolution(EmiIngredient ingredient, EmiPlayerInventory inventory) {
        if (ingredient.getEmiStacks().size() == 1 && !ingredient.isEmpty()) {
            EmiStack stack = ingredient.getEmiStacks().get(0);
            return EmiUtil.getPreferredRecipe(EmiApi.getRecipeManager().getRecipesByOutput(stack).stream().filter(r -> r.supportsRecipeTree() && r.getOutputs().stream().anyMatch(i -> i.isEqual(stack))).collect(Collectors.toList()), inventory, false);
        }
        return null;
    }
}

