/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi;

import dev.emi.emi.PacketReader;
import dev.emi.emi.data.EmiData;
import dev.emi.emi.network.CreateItemC2SPacket;
import dev.emi.emi.network.EmiChessPacket;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import dev.emi.emi.network.FillRecipeC2SPacket;
import dev.emi.emi.network.PingS2CPacket;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.platform.EmiMain;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import moddedmite.emi.api.EMIPlayerControllerMP;
import moddedmite.emi.platform.fish.EmiAgnosFish;
import moddedmite.emi.util.MinecraftServerHelper;
import net.minecraft.Minecraft;
import net.minecraft.Packet;
import net.minecraft.Packet250CustomPayload;
import shims.java.com.unascribed.retroemi.RetroEMI;
import shims.java.net.minecraft.network.PacketByteBuf;

public class EMIPostInit {
    private static boolean isEMIInit = false;

    public static void initEMI() {
        if (!isEMIInit) {
            InRelauncher.init();
            isEMIInit = true;
        }
    }

    public static final class InRelauncher {
        public static void init() {
            EmiAgnosFish.poke();
            if (!MinecraftServerHelper.isServer()) {
                Client.init();
            }
            EmiMain.init();
            EmiNetwork.initServer((player, packet) -> player.playerNetServerHandler.sendPacketToPlayer((Packet)InRelauncher.toVanilla(packet)));
            PacketReader.registerServerPacketReader(EmiNetwork.FILL_RECIPE, FillRecipeC2SPacket::new);
            PacketReader.registerServerPacketReader(EmiNetwork.CREATE_ITEM, CreateItemC2SPacket::new);
            PacketReader.registerServerPacketReader(EmiNetwork.CHESS, EmiChessPacket.C2S::new);
        }

        private static Packet250CustomPayload toVanilla(EmiPacket packet) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            PacketByteBuf buf = PacketByteBuf.out(dos);
            packet.write(buf);
            Packet250CustomPayload pkt = new Packet250CustomPayload(RetroEMI.compactify(packet.getId()), baos.toByteArray());
            return pkt;
        }

        public static final class Client {
            public static void init() {
                EmiClient.init();
                EmiData.init();
                EmiNetwork.initClient(packet -> ((EMIPlayerControllerMP)Minecraft.getMinecraft().playerController).getNetClientHandler().addToSendQueue((Packet)InRelauncher.toVanilla(packet)));
                PacketReader.registerClientPacketReader(EmiNetwork.PING, PingS2CPacket::new);
                PacketReader.registerClientPacketReader(EmiNetwork.CHESS, EmiChessPacket.S2C::new);
            }
        }
    }
}

