/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.util;

import net.minecraft.Minecraft;
import net.minecraft.SoundManager;
import net.minecraft.WorldClient;

public class MusicHelper {
    public static float simulateIntendedPitch(WorldClient world, int time) {
        float offset = 0.0f;
        float target = MusicHelper.targetOffset(world);
        if (time > WorldClient.getTimeOfSunset() - 1500 || time < WorldClient.getTimeOfSunrise()) {
            int speed;
            int n = speed = world.isBloodMoon(false) ? 2000 : 4000;
            offset = (time -= -1500 + WorldClient.getTimeOfSunset()) <= 0 || time > speed ? (offset += target) : (offset += Math.min(target * ((float)time / (float)speed), target));
        } else {
            int speed = 3000;
            offset += Math.max(target - (float)(time -= WorldClient.getTimeOfSunrise()) / (float)speed, 0.0f);
        }
        offset += (float)(0.05 * (double)world.getRainStrength(0.001f));
        return 1.0f - (offset += (float)(0.05 * (double)world.getWeightedThunderStrength(0.001f)));
    }

    public static float targetOffset(WorldClient world) {
        SoundManager manager = Minecraft.getMinecraft().sndManager;
        SoundManager access = manager;
        if (!MusicHelper.getSimpleName(access.mr$getMusicTitle()).equals("magnetic")) {
            if (world.isBloodMoon(false)) {
                return 0.4f;
            }
            return 0.13f;
        }
        return 0.05f;
    }

    public static String getSimpleName(String fileName) {
        String result = fileName;
        String[] split1 = fileName.split(":");
        if (split1.length > 1) {
            result = split1[1];
        }
        return result.substring(0, result.length() - 4);
    }
}

