/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.render.gui;

import com.github.jeffyjamzhd.renewed.api.registry.TracklistRegistry;
import net.minecraft.Gui;
import net.minecraft.Item;
import net.minecraft.Minecraft;
import net.minecraft.RenderHelper;
import net.minecraft.RenderItem;
import net.minecraft.ResourceLocation;
import net.minecraft.ScaledResolution;
import net.minecraft.client.main.Main;
import org.lwjgl.opengl.GL11;

public class GuiMusic
extends Gui {
    private static final ResourceLocation background = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    private final Minecraft mc;
    private final RenderItem itemRenderer;
    private float width;
    private float height;
    private long displayTime = 0L;
    private String artistName = "";
    private String trackName = "";

    public GuiMusic(Minecraft mc) {
        this.mc = mc;
        this.itemRenderer = new RenderItem();
    }

    public void queueMusic(String trackName) {
        this.displayTime = Minecraft.getSystemTime();
        TracklistRegistry.Track track = TracklistRegistry.getTrackFromSimpleName(trackName);
        this.artistName = track.artist();
        this.trackName = track.trackName();
    }

    private void updateWindowScale() {
        GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        ScaledResolution var1 = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
        this.width = var1.getScaledWidth();
        this.height = var1.getScaledHeight();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void updateDisplay() {
        boolean isMusicPlaying = Minecraft.getMinecraft().sndManager.mr$isMusicPlaying();
        if (Minecraft.theMinecraft.gameSettings.gui_mode == 0 && !Main.is_MITE_DS && Minecraft.theMinecraft.gameSettings.musicVolume > 0.0f) {
            if (!this.trackName.isBlank() && this.displayTime != 0L && isMusicPlaying) {
                double anim = (float)(Minecraft.getSystemTime() - this.displayTime) / 6000.0f;
                if (!(anim < 0.0) && !(anim > 1.0)) {
                    GL11.glPushMatrix();
                    this.updateWindowScale();
                    GL11.glDisable((int)2929);
                    GL11.glDepthMask((boolean)false);
                    double var3 = anim * 2.0;
                    if (var3 > 1.0) {
                        var3 = 2.0 - var3;
                    }
                    var3 *= 4.0;
                    if ((var3 = 1.0 - var3) < 0.0) {
                        var3 = 0.0;
                    }
                    var3 *= var3;
                    var3 *= var3;
                    int var5 = 0;
                    int var6 = -((int)(var3 * 36.0));
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glEnable((int)3553);
                    this.mc.getTextureManager().bindTexture(background);
                    GL11.glDisable((int)2896);
                    this.drawTexturedModalRect(var5, var6, 96, 202, 160, 32);
                    this.mc.fontRenderer.drawString(this.artistName, var5 + 30, var6 + 7, -12255488, true);
                    this.mc.fontRenderer.drawString(this.trackName, var5 + 30, var6 + 18, -1, true);
                    RenderHelper.enableGUIStandardItemLighting();
                    GL11.glEnable((int)32826);
                    GL11.glEnable((int)2903);
                    GL11.glEnable((int)2896);
                    this.itemRenderer.renderItemAndEffectIntoGUI(this.mc.fontRenderer, this.mc.getTextureManager(), Item.recordCat.getItemStackForStatsIcon(), var5 + 8, var6 + 8);
                    GL11.glDisable((int)2896);
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glPopMatrix();
                } else {
                    this.displayTime = 0L;
                }
            }
        } else if (Minecraft.theMinecraft.gameSettings.musicVolume <= 0.0f) {
            this.displayTime = 0L;
            this.artistName = "";
            this.trackName = "";
        }
    }
}

