/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.render;

import com.github.jeffyjamzhd.renewed.entity.EntityPolearm;
import com.github.jeffyjamzhd.renewed.item.ItemPolearm;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.Entity;
import net.minecraft.MathHelper;
import net.minecraft.Render;
import net.minecraft.ResourceLocation;
import net.minecraft.Tessellator;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class RenderPolearm
extends Render {
    private static final HashMap<String, ResourceLocation> tex = new HashMap();
    private static final String[] materials = new String[]{"flint", "bone", "obsidian", "copper", "silver", "gold", "iron", "ancient_metal", "mithril", "adamantium"};

    public RenderPolearm() {
        this.addTextures();
    }

    public void addTextures() {
        for (String name : materials) {
            tex.put(name, new ResourceLocation("miterenewed:" + "textures/entity/polearm/%s.png".formatted(name)));
        }
    }

    public void renderPolearm(EntityPolearm entity, double x, double y, double z, float par8, float par9) {
        this.bindEntityTexture((Entity)entity);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(entity.prevRotationYaw + (entity.rotationYaw - entity.prevRotationYaw) * par9 - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(entity.prevRotationPitch + (entity.rotationPitch - entity.prevRotationPitch) * par9), (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tss = Tessellator.instance;
        boolean var11 = false;
        float var12 = 0.0f;
        float var13 = 0.5f;
        float var14 = 0.0f;
        float var15 = 0.15625f;
        float var16 = 0.0f;
        float var17 = 0.15625f;
        float var18 = 0.15625f;
        float var19 = 0.3125f;
        float stringU0 = 0.21875f;
        float stringU1 = 0.375f;
        float stringV0 = 0.15625f;
        float stringV1 = 0.40625f;
        float scale = 0.10625f;
        float var21 = (float)entity.polearmShake - par9;
        GL11.glEnable((int)32826);
        if (var21 > 0.0f) {
            float var22 = -MathHelper.sin((float)(var21 * 3.0f)) * var21;
            GL11.glRotatef((float)var22, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glScalef((float)(scale * 1.25f), (float)scale, (float)scale);
        GL11.glTranslatef((float)-5.0f, (float)0.0f, (float)0.0f);
        for (int var23 = 0; var23 < 4; ++var23) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)scale);
            tss.startDrawingQuads();
            tss.addVertexWithUV(-8.0, -2.0, 0.0, (double)var12, (double)var14);
            tss.addVertexWithUV(8.0, -2.0, 0.0, (double)var13, (double)var14);
            tss.addVertexWithUV(8.0, 2.0, 0.0, (double)var13, (double)var15);
            tss.addVertexWithUV(-8.0, 2.0, 0.0, (double)var12, (double)var15);
            tss.draw();
        }
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3f((float)scale, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        tss.startDrawingQuads();
        tss.addVertexWithUV(-7.0, -2.0, -2.0, (double)var16, (double)var18);
        tss.addVertexWithUV(-7.0, -2.0, 2.0, (double)var17, (double)var18);
        tss.addVertexWithUV(-7.0, 2.0, 2.0, (double)var17, (double)var19);
        tss.addVertexWithUV(-7.0, 2.0, -2.0, (double)var16, (double)var19);
        tss.draw();
        GL11.glNormal3f((float)(-scale), (float)0.0f, (float)0.0f);
        tss.startDrawingQuads();
        tss.addVertexWithUV(-7.0, 2.0, -2.0, (double)var16, (double)var18);
        tss.addVertexWithUV(-7.0, 2.0, 2.0, (double)var17, (double)var18);
        tss.addVertexWithUV(-7.0, -2.0, 2.0, (double)var17, (double)var19);
        tss.addVertexWithUV(-7.0, -2.0, -2.0, (double)var16, (double)var19);
        tss.draw();
        GL11.glRotatef((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)4.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)1.15f, (float)1.25f, (float)1.25f);
        GL11.glRotatef((float)225.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
        for (int i = 0; i < 4; ++i) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glNormal3f((float)scale, (float)0.0f, (float)0.0f);
            tss.startDrawingQuads();
            tss.addVertexWithUV(0.0, 2.0, -4.0, (double)stringU0, (double)stringV1);
            tss.addVertexWithUV(0.0, 2.0, 2.0, (double)stringU0, (double)stringV0);
            tss.addVertexWithUV(0.0, -2.0, 2.0, (double)stringU1, (double)stringV0);
            tss.addVertexWithUV(0.0, -2.0, -4.0, (double)stringU1, (double)stringV1);
            tss.draw();
        }
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-3.0f, (float)0.0f, (float)0.15f);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double x, double y, double z, float g, float h) {
        this.renderPolearm((EntityPolearm)entity, x, y, z, g, h);
    }

    protected ResourceLocation getPolearmTexture(EntityPolearm polearm) {
        return this.getTexFromItem(polearm.getItem());
    }

    protected ResourceLocation getTexFromItem(ItemPolearm item) {
        return tex.getOrDefault(item.getToolMaterial().mr$getName(), tex.get("flint"));
    }

    protected ResourceLocation getEntityTexture(Entity entity) {
        return this.getPolearmTexture((EntityPolearm)entity);
    }
}

