/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.registry;

import com.github.jeffyjamzhd.renewed.MiTERenewed;
import com.github.jeffyjamzhd.renewed.api.IFurnaceRecipes;
import com.github.jeffyjamzhd.renewed.item.ItemPolearm;
import com.github.jeffyjamzhd.renewed.item.ItemQuern;
import com.github.jeffyjamzhd.renewed.item.recipe.ShapelessToolRecipe;
import com.github.jeffyjamzhd.renewed.registry.RenewedItems;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.Block;
import net.minecraft.CraftingManager;
import net.minecraft.FurnaceRecipes;
import net.minecraft.Item;
import net.minecraft.ItemDagger;
import net.minecraft.ItemStack;
import net.minecraft.Material;
import net.minecraft.MathHelper;
import net.xiaoyu233.fml.reload.event.RecipeRegistryEvent;

public class RenewedRecipes {
    public static void registerRecipes(RecipeRegistryEvent registry) {
        MiTERenewed.LOGGER.info("Registering recipes!");
        RenewedRecipes.registerIterativeRecipes(registry);
        RenewedRecipes.registerShapedRecipes(registry);
        RenewedRecipes.registerShapelessRecipes(registry);
        RenewedRecipes.registerMeshRecipes(registry);
        RenewedRecipes.registerFurnaceRecipes();
    }

    private static void registerIterativeRecipes(RecipeRegistryEvent registry) {
        for (Item item : Item.itemsList) {
            if (!(item instanceof ItemPolearm)) continue;
            Material material = ((ItemPolearm)item).getToolMaterial();
            ItemStack materialItem = RenewedRecipes.parseItemFromMaterial(material);
            if (((ItemPolearm)item).isPrimitive()) {
                registry.registerShapedRecipe(new ItemStack(item), true, new Object[]{"MS ", " I ", "  I", Character.valueOf('M'), materialItem, Character.valueOf('S'), Item.sinew, Character.valueOf('I'), Item.stick}).difficulty(425.0f * RenewedRecipes.difficultyMod(material));
                continue;
            }
            registry.registerShapedRecipe(new ItemStack(item), true, new Object[]{"M  ", " I ", "  I", Character.valueOf('M'), materialItem, Character.valueOf('I'), Item.stick});
        }
    }

    private static void registerShapelessRecipes(RecipeRegistryEvent registry) {
        registry.registerShapelessRecipe(new ItemStack(RenewedItems.handpan, 1, 1), true, new Object[]{RenewedItems.handpan, RenewedItems.sinew_mesh}).difficulty(100.0f);
        registry.registerShapelessRecipe(new ItemStack(RenewedItems.handpan, 1, 2), true, new Object[]{RenewedItems.handpan, RenewedItems.silk_mesh}).difficulty(100.0f);
        registry.registerShapelessRecipe(new ItemStack(Item.stick, 1), true, new Object[]{new ItemStack(Block.sapling, 1, Short.MAX_VALUE)}).difficulty(300.0f);
    }

    private static void registerShapedRecipes(RecipeRegistryEvent registry) {
        registry.registerShapedRecipe(new ItemStack((Item)RenewedItems.quern), true, new Object[]{"C", "B", Character.valueOf('B'), Item.bowlEmpty, Character.valueOf('C'), Item.cudgelWood}).difficulty(50.0f);
    }

    private static void registerMeshRecipes(RecipeRegistryEvent registry) {
        registry.registerShapedRecipe(new ItemStack(RenewedItems.silk_mesh), true, new Object[]{"SSS", "SSS", Character.valueOf('S'), Item.silk}).difficulty(325.0f);
        registry.registerShapedRecipe(new ItemStack(RenewedItems.sinew_mesh), true, new Object[]{"SSS", "SSS", Character.valueOf('S'), Item.sinew}).difficulty(775.0f);
    }

    public static ShapelessToolRecipe registerToolRecipe(ItemStack output, CraftingManager man, Item ... input) {
        ShapelessToolRecipe recipe = new ShapelessToolRecipe(output, Arrays.stream(input).map(ItemStack::new).toList());
        man.getRecipeList().add(recipe);
        return recipe;
    }

    public static ShapelessToolRecipe registerToolRecipe(ItemStack output, CraftingManager man, Item tool, ItemStack ... input) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack(tool));
        items.addAll(Arrays.stream(input).toList());
        ShapelessToolRecipe recipe = new ShapelessToolRecipe(output, items);
        man.getRecipeList().add(recipe);
        return recipe;
    }

    private static ItemStack parseItemFromMaterial(Material mat) {
        return switch (mat.mr$getName()) {
            case "bone" -> new ItemStack((Item)RenewedItems.sharp_bone);
            case "flint" -> new ItemStack(Item.flint);
            case "obsidian" -> new ItemStack(Block.obsidian);
            case "copper" -> new ItemStack(Item.ingotCopper);
            case "silver" -> new ItemStack(Item.ingotSilver);
            case "gold" -> new ItemStack(Item.ingotGold);
            case "iron" -> new ItemStack(Item.ingotIron);
            case "ancient_metal" -> new ItemStack(Item.ingotAncientMetal);
            case "mithril" -> new ItemStack(Item.ingotMithril);
            case "adamantium" -> new ItemStack(Item.ingotAdamantium);
            default -> null;
        };
    }

    private static float difficultyMod(Material mat) {
        return switch (mat.getTranslationKey()) {
            case "bone" -> 1.33f;
            case "flint" -> 0.8f;
            default -> 1.0f;
        };
    }

    public static void registerSpecialRecipes(CraftingManager manager) {
        MiTERenewed.LOGGER.info("Registering special recipes!");
        for (Item item : Item.itemsList) {
            if (item instanceof ItemDagger) {
                float difficulty = item.getLowestCraftingDifficultyToProduce();
                difficulty = Float.compare(difficulty, Float.MAX_VALUE) == 0 ? 70.0f : difficulty;
                float fac = 20.0f * (1.0f / MathHelper.sqrt_float((float)difficulty));
                if (item.itemID != RenewedItems.sharp_bone.itemID) {
                    RenewedRecipes.registerToolRecipe(new ItemStack((Item)RenewedItems.sharp_bone), manager, item, Item.bone).setDamage(100).setDifficulty(1200.0f).scaleDifficulty(fac);
                }
                RenewedRecipes.registerToolRecipe(new ItemStack(Item.sinew, 2), manager, item, Item.leather).setDamage(20).setDifficulty(450.0f).scaleDifficulty(fac);
                RenewedRecipes.registerToolRecipe(new ItemStack(Item.sinew, 2), manager, item, Item.rottenFlesh).setDamage(30).setDifficulty(600.0f).scaleDifficulty(fac);
                RenewedRecipes.registerToolRecipe(new ItemStack(Item.silk), manager, item, RenewedItems.tangled_web).setDamage(10).setDifficulty(180.0f).scaleDifficulty(fac);
                RenewedRecipes.registerToolRecipe(new ItemStack(Item.silk, 2), manager, item, new ItemStack(Block.cloth, 1, Short.MAX_VALUE)).setDamage(40).setDifficulty(1200.0f).scaleDifficulty(fac);
                RenewedRecipes.registerToolRecipe(new ItemStack(Item.stick, 2), manager, item, new ItemStack(Block.sapling, 1, Short.MAX_VALUE)).setDamage(60).setDifficulty(600.0f).scaleDifficulty(fac);
                RenewedRecipes.registerToolRecipe(new ItemStack(RenewedItems.handpan), manager, item, new ItemStack((Block)Block.planks), new ItemStack((Block)Block.planks)).setDamage(50).setDifficulty(700.0f).scaleDifficulty(fac);
                RenewedRecipes.registerCuttingRecipe(manager, item, RenewedItems.raw_pork, RenewedItems.cooked_pork, 25, 400.0f, fac);
                RenewedRecipes.registerCuttingRecipe(manager, item, RenewedItems.raw_beef, RenewedItems.cooked_beef, 30, 500.0f, fac);
                RenewedRecipes.registerCuttingRecipe(manager, item, RenewedItems.raw_poultry, RenewedItems.cooked_poultry, 20, 350.0f, fac);
                RenewedRecipes.registerCuttingRecipe(manager, item, RenewedItems.raw_lambchop, RenewedItems.cooked_lambchop, 30, 500.0f, fac);
            }
            if (!(item instanceof ItemQuern)) continue;
            RenewedRecipes.registerToolRecipe(new ItemStack(Item.sugar, 1), manager, item, Item.reed).setDamage(20).setDifficulty(200.0f);
            RenewedRecipes.registerToolRecipe(new ItemStack((Item)RenewedItems.biomass, 1), manager, item, new ItemStack((Block)Block.plantRed, 1, Short.MAX_VALUE), new ItemStack((Block)Block.plantRed, 1, Short.MAX_VALUE), new ItemStack((Block)Block.plantRed, 1, Short.MAX_VALUE), new ItemStack((Block)Block.plantRed, 1, Short.MAX_VALUE), new ItemStack((Block)Block.plantRed, 1, Short.MAX_VALUE), new ItemStack((Block)Block.plantRed, 1, Short.MAX_VALUE), new ItemStack((Block)Block.plantRed, 1, Short.MAX_VALUE), new ItemStack((Block)Block.plantRed, 1, Short.MAX_VALUE)).setDamage(50).setDifficulty(400.0f);
            RenewedRecipes.registerToolRecipe(new ItemStack(Item.dyePowder, 2, 1), manager, item, new ItemStack((Block)Block.plantRed, 1, 0)).setDamage(10).setDifficulty(100.0f);
            RenewedRecipes.registerToolRecipe(new ItemStack(Item.dyePowder, 2, 11), manager, item, new ItemStack((Block)Block.plantYellow)).setDamage(10).setDifficulty(100.0f);
            RenewedRecipes.registerToolRecipe(new ItemStack(Item.dyePowder, 2, 12), manager, item, new ItemStack((Block)Block.plantRed, 1, 1)).setDamage(10).setDifficulty(100.0f);
            RenewedRecipes.registerToolRecipe(new ItemStack(Item.dyePowder, 2, 13), manager, item, new ItemStack((Block)Block.plantRed, 1, 2)).setDamage(10).setDifficulty(100.0f);
            RenewedRecipes.registerToolRecipe(new ItemStack(Item.dyePowder, 2, 14), manager, item, new ItemStack((Block)Block.plantRed, 1, 5)).setDamage(10).setDifficulty(100.0f);
            RenewedRecipes.registerToolRecipe(new ItemStack(Item.dyePowder, 2, 9), manager, item, new ItemStack((Block)Block.plantRed, 1, 7)).setDamage(10).setDifficulty(100.0f);
            RenewedRecipes.registerToolRecipe(new ItemStack(Item.dyePowder, 2, 8), manager, item, new ItemStack((Block)Block.plantRed, 1, 8)).setDamage(10).setDifficulty(100.0f);
            RenewedRecipes.registerToolRecipe(new ItemStack(Item.dyePowder, 2, 15), manager, item, Item.bone).setDamage(25).setDifficulty(250.0f);
        }
    }

    private static void registerCuttingRecipe(CraftingManager manager, Item tool, Item raw, Item cooked, int damage, float difficulty, float scale) {
        RenewedRecipes.registerToolRecipe(new ItemStack(raw.itemID, 2, 1), manager, tool, new ItemStack(raw.itemID, 1, 0)).setDamage(damage).setDifficulty(difficulty).scaleDifficulty(scale);
        RenewedRecipes.registerToolRecipe(new ItemStack(cooked.itemID, 2, 1), manager, tool, new ItemStack(cooked.itemID, 1, 0)).setDamage(damage * 2).setDifficulty(difficulty * 1.75f).scaleDifficulty(scale);
    }

    public static void registerFurnaceRecipes() {
        FurnaceRecipes recipes = FurnaceRecipes.smelting();
        RenewedRecipes.registerFurnaceMeatRecipe((IFurnaceRecipes)recipes, RenewedItems.raw_pork, RenewedItems.cooked_pork);
        RenewedRecipes.registerFurnaceMeatRecipe((IFurnaceRecipes)recipes, RenewedItems.raw_poultry, RenewedItems.cooked_poultry);
        RenewedRecipes.registerFurnaceMeatRecipe((IFurnaceRecipes)recipes, RenewedItems.raw_beef, RenewedItems.cooked_beef);
        RenewedRecipes.registerFurnaceMeatRecipe((IFurnaceRecipes)recipes, RenewedItems.raw_lambchop, RenewedItems.cooked_lambchop);
        recipes.mr$addSmeltingComplexEntry(new ItemStack((Item)RenewedItems.raw_poultry, 1, 2), new ItemStack((Item)RenewedItems.cooked_poultry, 1, 2));
    }

    private static void registerFurnaceMeatRecipe(IFurnaceRecipes recipes, Item input, Item output) {
        recipes.mr$addSmeltingComplexEntry(new ItemStack(input.itemID, 1, 0), new ItemStack(output.itemID, 1, 0));
        recipes.mr$addSmeltingComplexEntry(new ItemStack(input.itemID, 2, 1), new ItemStack(output.itemID, 2, 1));
    }
}

