/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.registry;

import com.github.jeffyjamzhd.renewed.api.event.listener.CraftingSoundRegisterListener;
import com.github.jeffyjamzhd.renewed.api.registry.CraftingSoundRegistry;
import com.github.jeffyjamzhd.renewed.api.sound.CraftingSound;
import com.github.jeffyjamzhd.renewed.item.recipe.ShapelessToolRecipe;
import java.util.Random;
import net.minecraft.Block;
import net.minecraft.Entity;
import net.minecraft.Item;
import net.minecraft.Material;

public class RenewedCraftingSounds
implements CraftingSoundRegisterListener {
    private static Material[] metals = new Material[]{Material.copper, Material.silver, Material.gold, Material.iron, Material.ancient_metal, Material.mithril, Material.adamantium};
    private static Random rand = new Random();

    @Override
    public void register(CraftingSoundRegistry register) {
        register.registerSafe(CraftingSound.of(Material.wood, (output, recipe, world, player) -> {
            if (output.itemID == Block.workbench.blockID && output.getItemSubtype() < 5) {
                return;
            }
            if (output.itemID == Item.stick.itemID) {
                world.playSoundAtEntity((Entity)player, "mob.zombie.woodbreak", 0.5f, 1.4f - rand.nextFloat() * 0.2f);
            } else if (output.itemID == Item.cudgelWood.itemID || output.itemID == Item.clubWood.itemID) {
                world.playSoundAtEntity((Entity)player, "mob.zombie.woodbreak", 0.5f, 0.9f - rand.nextFloat() * 0.2f);
            } else if (output.itemID == Block.planks.blockID) {
                world.playSoundAtEntity((Entity)player, "mob.zombie.wood", 0.5f, 1.4f - rand.nextFloat() * 0.2f);
            } else {
                world.playSoundAtEntity((Entity)player, "miterenewed:crafting.wood", 0.5f, 1.1f - rand.nextFloat() * 0.2f);
            }
        }));
        register.registerSafe(CraftingSound.of(Material.meat, (output, recipe, world, player) -> {
            if (recipe instanceof ShapelessToolRecipe) {
                world.playSoundAtEntity((Entity)player, "miterenewed:crafting.chop", 0.5f, 1.2f - rand.nextFloat() * 0.2f);
            }
        }));
        register.registerSafe(CraftingSound.of(Material.flint, (output, recipe, world, player) -> {
            if (output.itemID != Item.flint.itemID && output.itemID != Item.chipFlint.itemID) {
                world.playSoundAtEntity((Entity)player, "random.anvil_land", 0.5f, 2.0f - rand.nextFloat() * 0.1f);
            }
        }));
        register.registerSafe(CraftingSound.of(Material.silk, (CraftingSound.ConditionalSound)CraftingSound.basicSound("random.bow", 0.5f, 1.0f)));
        register.registerSafe(CraftingSound.of(Material.leather, (output, recipe, world, player) -> {
            if (recipe instanceof ShapelessToolRecipe) {
                world.playSoundAtEntity((Entity)player, "random.bow", 0.5f, 0.8f);
            }
        }));
        for (Material metal : metals) {
            register.registerSafe(CraftingSound.of(metal, (CraftingSound.ConditionalSound)CraftingSound.metalSound(metal)));
        }
    }
}

