/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.mixinsquared.reflection;

import com.github.jeffyjamzhd.renewed.mixinsquared.reflection.FieldReference;
import java.util.Optional;
import java.util.SortedSet;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;

public final class TargetClassContextExtension {
    private final ITargetClassContext reference;
    private final FieldReference<SortedSet<?>> mixinsField;

    public TargetClassContextExtension(ITargetClassContext reference) {
        this.reference = reference;
        this.mixinsField = new FieldReference(reference.getClass(), "mixins");
    }

    public static Optional<TargetClassContextExtension> tryAs(ITargetClassContext reference) {
        if (reference.getClass().getName().equals("org.spongepowered.asm.mixin.transformer.TargetClassContext")) {
            return Optional.of(new TargetClassContextExtension(reference));
        }
        return Optional.empty();
    }

    public SortedSet<IMixinInfo> getMixins() {
        return this.mixinsField.get(this.reference);
    }
}

