/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.mixins.gui;

import com.github.jeffyjamzhd.renewed.api.ISlotCrafting;
import com.github.jeffyjamzhd.renewed.api.sound.CraftingSoundHandler;
import com.github.jeffyjamzhd.renewed.item.recipe.ShapelessToolRecipe;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.CraftingResult;
import net.minecraft.EntityPlayer;
import net.minecraft.EnumEntityFX;
import net.minecraft.IInventory;
import net.minecraft.IRecipe;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.MITEContainerCrafting;
import net.minecraft.SignalData;
import net.minecraft.SlotCrafting;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SlotCrafting.class}, priority=1200)
public abstract class SlotCraftingMixin
implements ISlotCrafting {
    @Mutable
    @Final
    @Shadow
    private final IInventory craftMatrix;
    @Shadow
    public CraftingResult crafting_result;
    @Unique
    private IRecipe mr$lastRecipe;

    @Shadow
    protected abstract void setInitialItemStack(EntityPlayer var1, MITEContainerCrafting var2);

    protected SlotCraftingMixin(IInventory craftMatrix) {
        this.craftMatrix = craftMatrix;
    }

    @Inject(method={"onPickupFromSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/IInventory;decrStackSize(II)Lnet/minecraft/ItemStack;", ordinal=0)})
    private void damageDagger(EntityPlayer player, ItemStack par2ItemStack, CallbackInfo ci, @Local(ordinal=2) int i) {
        ItemStack stack = this.craftMatrix.getStackInSlot(i);
        if (this.crafting_result != null) {
            this.mr$lastRecipe = this.crafting_result.recipe;
        }
        if (stack != null && stack.isTool() && this.mr$lastRecipe instanceof ShapelessToolRecipe) {
            int currentDamage = stack.getItemDamage();
            stack.setItemDamage(currentDamage + ((ShapelessToolRecipe)this.mr$lastRecipe).getDamage());
            if (stack.getItemDamage() >= stack.getMaxDamage()) {
                player.entityFX(EnumEntityFX.item_breaking, new SignalData().setByte(0).setShort(stack.itemID));
                this.craftMatrix.setInventorySlotContents(i, null);
            }
        }
    }

    @ModifyExpressionValue(method={"canPlayerCraftItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/InventoryCrafting;hasDamagedItem()Z")})
    private boolean modifyExpressionToolCraft(boolean original) {
        return original && !(this.crafting_result.recipe instanceof ShapelessToolRecipe);
    }

    @WrapOperation(method={"onPickupFromSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/IInventory;decrStackSize(II)Lnet/minecraft/ItemStack;")})
    private ItemStack decrTool(IInventory instance, int i, int j, Operation<ItemStack> original, @Local(name={"item"}) Item item) {
        if (this.mr$lastRecipe instanceof ShapelessToolRecipe && item.isTool()) {
            return this.craftMatrix.decrStackSize(i, 0);
        }
        return (ItemStack)original.call(new Object[]{instance, i, j});
    }

    @Inject(method={"onPickupFromSlot"}, at={@At(value="HEAD")})
    private void soundHook(EntityPlayer player, ItemStack stack, CallbackInfo ci) {
        if (player.onServer()) {
            CraftingSoundHandler.onCraft(stack, this.crafting_result.recipe, player.getWorld(), player);
        }
    }

    @Override
    public void mr$setInitialItemStack(EntityPlayer player, MITEContainerCrafting container) {
        this.setInitialItemStack(player, container);
    }
}

