/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.mixins.gui;

import com.github.jeffyjamzhd.renewed.item.recipe.ShapelessToolRecipe;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.Container;
import net.minecraft.CraftingResult;
import net.minecraft.EntityPlayer;
import net.minecraft.IInventory;
import net.minecraft.IRecipe;
import net.minecraft.ItemStack;
import net.minecraft.MITEContainerCrafting;
import net.minecraft.SlotCrafting;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MITEContainerCrafting.class})
public abstract class MITEContainerCraftingMixin
extends Container {
    @Shadow
    public CraftingResult current_crafting_result;
    @Shadow
    private CraftingResult previous_crafting_result;

    @Shadow
    protected abstract SlotCrafting getCraftingSlot();

    public MITEContainerCraftingMixin(EntityPlayer player) {
        super(player);
    }

    @Inject(method={"onCraftMatrixChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/CraftingResult;haveEquivalentItemStacks(Lnet/minecraft/CraftingResult;Lnet/minecraft/CraftingResult;)Z")})
    private void craftMatrixRecipeTypeChange(IInventory inventory, CallbackInfo ci) {
        if (this.current_crafting_result == null || this.previous_crafting_result == null) {
            return;
        }
        if (CraftingResult.haveEquivalentItemStacks((CraftingResult)this.current_crafting_result, (CraftingResult)this.previous_crafting_result)) {
            Optional<Object> prevTool = Optional.empty();
            Optional<Object> currTool = Optional.empty();
            IRecipe prevRecipe = this.previous_crafting_result.recipe;
            IRecipe currRecipe = this.current_crafting_result.recipe;
            if (prevRecipe instanceof ShapelessToolRecipe) {
                prevTool = Arrays.stream(prevRecipe.getComponents()).filter(ItemStack::isTool).findFirst();
            }
            if (currRecipe instanceof ShapelessToolRecipe) {
                currTool = Arrays.stream(currRecipe.getComponents()).filter(ItemStack::isTool).findFirst();
            }
            boolean prevSpecial = prevRecipe instanceof ShapelessToolRecipe;
            boolean currentSpecial = currRecipe instanceof ShapelessToolRecipe;
            if (prevTool.isPresent() && currTool.isPresent() && ((ItemStack)currTool.get()).itemID != ((ItemStack)prevTool.get()).itemID) {
                this.resetCrafting();
            }
            if (currentSpecial && !prevSpecial || !currentSpecial && prevSpecial) {
                this.resetCrafting();
            }
        }
    }

    @Unique
    private void resetCrafting() {
        MITEContainerCrafting instance = (MITEContainerCrafting)this;
        this.player.clearCrafting();
        this.getCraftingSlot().mr$setInitialItemStack(this.player, instance);
    }
}

