/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.mixins.entity;

import com.github.jeffyjamzhd.renewed.api.IEntityPlayer;
import com.github.jeffyjamzhd.renewed.item.ItemHandpan;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.Entity;
import net.minecraft.EntityLivingBase;
import net.minecraft.EntityPlayer;
import net.minecraft.EnumEntityFX;
import net.minecraft.EnumParticle;
import net.minecraft.FoodStats;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.Vec3;
import net.minecraft.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityPlayer.class})
public abstract class EntityPlayerMixin
extends EntityLivingBase
implements IEntityPlayer {
    @Shadow
    protected int itemInUseCount;
    @Shadow
    protected FoodStats foodStats;

    public EntityPlayerMixin(World par1World) {
        super(par1World);
    }

    @Shadow
    public abstract void playSound(String var1, float var2, float var3);

    @Shadow
    public abstract void stopUsingItem();

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/EntityPlayer;updateItemUse(Lnet/minecraft/ItemStack;I)V", shift=At.Shift.BY, by=2)})
    protected void addUpdateForHandpan(CallbackInfo ci, @Local(name={"var1"}) ItemStack stack) {
        if (stack.getItem() instanceof ItemHandpan) {
            if (this.itemInUseCount % 5 == 0) {
                short id = stack.getTagCompound().getShort("handpanContent");
                Vec3 var4 = this.worldObj.getWorldVec3Pool().getVecFromPool(((double)this.rand.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                var4.rotateAroundX(-this.rotationPitch * (float)Math.PI / 180.0f);
                var4.rotateAroundY(-this.rotationYaw * (float)Math.PI / 180.0f);
                Vec3 var5 = this.worldObj.getWorldVec3Pool().getVecFromPool(((double)this.rand.nextFloat() - 0.5) * 0.3, (double)(-this.rand.nextFloat()) * 0.6 - 0.3, 0.6);
                var5.rotateAroundX(-this.rotationPitch * (float)Math.PI / 180.0f);
                var5.rotateAroundY(-this.rotationYaw * (float)Math.PI / 180.0f);
                var5 = var5.addVector(this.posX, this.getEyePosY(), this.posZ);
                this.worldObj.spawnParticleEx(EnumParticle.iconcrack, (int)id, 0, var5.xCoord, var5.yCoord, var5.zCoord, var4.xCoord, var4.yCoord + 0.05, var4.zCoord);
                if (!this.worldObj.isRemote && !this.isInWater()) {
                    this.stopUsingItem();
                }
            }
            if (this.itemInUseCount % 12 == 0 && !this.worldObj.isRemote) {
                this.worldObj.playSoundAtEntity((Entity)this, "miterenewed:item.handpan.splash", 0.5f + 0.5f * (float)this.rand.nextInt(2), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.7f);
                this.entityFX(EnumEntityFX.splash);
            }
        }
    }

    @ModifyConstant(method={"updateItemUse"}, constant={@Constant(intValue=0, ordinal=1)})
    int modifyData(int constant, @Local(argsOnly=true) ItemStack stack) {
        return stack.getItemSubtype();
    }

    @Override
    public void mr$addFoodValueSubtype(Item item, int subtype) {
        this.foodStats.mr$addFoodValueSubtype(item, subtype);
    }
}

