/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.mixins.entity;

import com.github.jeffyjamzhd.renewed.item.ItemRenewedFood;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.Block;
import net.minecraft.Damage;
import net.minecraft.Entity;
import net.minecraft.EntityDamageResult;
import net.minecraft.EntityItem;
import net.minecraft.EntityXPOrb;
import net.minecraft.EnumBlockOperation;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityItem.class})
public abstract class EntityItemMixin
extends Entity {
    @Shadow
    private float cooking_progress;

    public EntityItemMixin(World par1World) {
        super(par1World);
    }

    @Shadow
    public abstract ItemStack getEntityItem();

    @Shadow
    public abstract void setEntityItemStack(ItemStack var1);

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/Damage;isFireDamage()Z", ordinal=1)}, cancellable=true)
    private void addSupportForExtendedFood(Damage damage, CallbackInfoReturnable<EntityDamageResult> cir, @Local(name={"result"}) EntityDamageResult result) {
        Item item;
        ItemStack stack = this.getEntityItem();
        if (damage.isFireDamage() && (item = stack.getItem()) instanceof ItemRenewedFood) {
            ItemRenewedFood item_food = (ItemRenewedFood)item;
            if (item_food.cookedFood != null || item_food.uncookedFood != null) {
                if (item_food.cookedFood != null) {
                    int x = this.getBlockPosX();
                    int y = this.getBlockPosY();
                    int z = this.getBlockPosZ();
                    for (int dx = -1; dx <= 1; ++dx) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            Block block = this.worldObj.getBlock(x + dx, y, z + dz);
                            if (block != Block.fire) continue;
                            this.worldObj.getAsWorldServer().addScheduledBlockOperation(EnumBlockOperation.try_extinguish_by_items, x + dx, y, z + dz, (this.worldObj.getTotalWorldTime() / 10L + 1L) * 10L, false);
                        }
                    }
                }
                this.cooking_progress += damage.getAmount() * 3.0f;
                if (this.cooking_progress >= 100.0f) {
                    int xp_share;
                    ItemStack cooked_item_stack = item_food.getItemProducedWhenDestroyed(stack, damage.getSource());
                    if (cooked_item_stack == null) {
                        this.setDead();
                        cir.setReturnValue((Object)result.setEntityWasDestroyed());
                        return;
                    }
                    if (item_food.isAnimalProduct()) {
                        this.playSound("imported.random.sizzle", 1.0f, 1.0f);
                    }
                    this.setEntityItemStack(cooked_item_stack);
                    for (int xp_reward = cooked_item_stack.getExperienceReward(); xp_reward > 0; xp_reward -= xp_share) {
                        xp_share = EntityXPOrb.getXPSplit((int)xp_reward);
                        this.worldObj.spawnEntityInWorld((Entity)new EntityXPOrb(this.worldObj, this.posX, this.posY + 0.5, this.posZ + 0.5, xp_share));
                    }
                }
                cir.setReturnValue((Object)result.setEntityWasAffected());
            }
        }
    }
}

