/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.item;

import com.github.jeffyjamzhd.renewed.entity.EntityPolearm;
import com.github.jeffyjamzhd.renewed.registry.RenewedMaterial;
import net.minecraft.Block;
import net.minecraft.CreativeTabs;
import net.minecraft.Enchantment;
import net.minecraft.EnchantmentHelper;
import net.minecraft.Entity;
import net.minecraft.EntityLivingBase;
import net.minecraft.EntityPlayer;
import net.minecraft.EnumItemInUseAction;
import net.minecraft.Icon;
import net.minecraft.IconRegister;
import net.minecraft.ItemStack;
import net.minecraft.ItemSword;
import net.minecraft.Material;
import net.minecraft.ResourceLocation;
import net.minecraft.World;

public class ItemPolearm
extends ItemSword {
    private final ResourceLocation handTexture;
    public Icon handIcon;

    protected ItemPolearm(int id, Material material, ResourceLocation handTexture) {
        super(id, material);
        this.setCreativeTab(CreativeTabs.tabCombat);
        this.setReachBonus(1.0f);
        this.handTexture = handTexture;
    }

    public boolean hasQuality() {
        return true;
    }

    public float getBaseHarvestEfficiency(Block block) {
        return 0.25f;
    }

    public int getNumComponentsForDurability() {
        return 1;
    }

    public float getBaseDamageVsEntity() {
        return this.isPrimitive() ? 0.5f : 1.0f;
    }

    public String getToolType() {
        return "polearm";
    }

    public float getBaseDecayRateForAttackingEntity(ItemStack item_stack) {
        return this.isPrimitive() ? 0.25f : 0.5f;
    }

    public boolean canBlock() {
        return false;
    }

    public boolean onItemRightClick(EntityPlayer player, float delta, boolean ctrl_pressed) {
        player.setHeldItemInUse();
        return true;
    }

    public void onPlayerStoppedUsing(ItemStack item_stack, World world, EntityPlayer player, int item_in_use_count) {
        if (!world.isRemote) {
            float fraction_pulled = ItemPolearm.getFractionPulled(item_stack, item_in_use_count);
            if (!((fraction_pulled = (fraction_pulled * fraction_pulled + fraction_pulled * 2.0f) / 3.0f) < 0.1f)) {
                if (fraction_pulled > 1.0f) {
                    fraction_pulled = 1.0f;
                }
                EntityPolearm entityPolearm = new EntityPolearm(world, (EntityLivingBase)player, fraction_pulled * 0.8f, this, item_stack.getItemDamage() + item_stack.getScaledDamage(0.5f), item_stack.getEnchantmentTagList());
                if (fraction_pulled == 1.0f) {
                    entityPolearm.setIsCritical(true);
                }
                int sharp = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.sharpness.effectId, (ItemStack)item_stack);
                entityPolearm.setDamage(this.getCombinedDamageVsEntity() + 2.0f);
                int flame = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fireAspect.effectId, (ItemStack)item_stack);
                if (flame > 0) {
                    entityPolearm.setFire(100);
                }
                world.playSoundAtEntity((Entity)player, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + fraction_pulled * 0.5f);
                world.spawnEntityInWorld((Entity)entityPolearm);
                player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
            }
        }
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 24000;
    }

    public Icon getIconFromSubtypeForRenderPass(int par1, int par2) {
        return par2 == 2 ? this.handIcon : this.itemIcon;
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public void registerIcons(IconRegister register) {
        super.registerIcons(register);
        this.handIcon = register.registerIcon(this.handTexture.toString());
    }

    public EnumItemInUseAction getItemInUseAction(ItemStack par1ItemStack, EntityPlayer player) {
        return EnumItemInUseAction.BOW;
    }

    public boolean isPrimitive() {
        return this.hasMaterial(new Material[]{Material.flint, RenewedMaterial.bone, Material.obsidian});
    }

    public static int getTicksForMaxPull(ItemStack item_stack) {
        return 10 - EnchantmentHelper.getEnchantmentLevelFractionOfInteger((Enchantment)Enchantment.quickness, (ItemStack)item_stack, (int)10);
    }

    public static int getTicksPulled(ItemStack item_stack, int item_in_use_count) {
        return item_stack.getMaxItemUseDuration() - item_in_use_count;
    }

    public static float getFractionPulled(ItemStack item_stack, int item_in_use_count) {
        return Math.min((float)ItemPolearm.getTicksPulled(item_stack, item_in_use_count) / (float)ItemPolearm.getTicksForMaxPull(item_stack), 1.0f);
    }
}

