/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.item;

import com.github.jeffyjamzhd.renewed.item.recipe.HandpanRecipe;
import com.github.jeffyjamzhd.renewed.item.recipe.HandpanRecipeProcessor;
import java.util.List;
import net.minecraft.Block;
import net.minecraft.CreativeTabs;
import net.minecraft.DamageSource;
import net.minecraft.Entity;
import net.minecraft.EntityPlayer;
import net.minecraft.EnumChatFormatting;
import net.minecraft.EnumItemInUseAction;
import net.minecraft.IDamageableItem;
import net.minecraft.Icon;
import net.minecraft.IconRegister;
import net.minecraft.InventoryPlayer;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.Material;
import net.minecraft.NBTBase;
import net.minecraft.NBTTagByte;
import net.minecraft.NBTTagCompound;
import net.minecraft.NBTTagShort;
import net.minecraft.Slot;
import net.minecraft.Translator;
import net.minecraft.World;

public class ItemHandpan
extends Item
implements IDamageableItem {
    public static final int EMPTY = 0;
    public static final int SINEW = 1;
    public static final int SILK = 2;
    public static final String NBT_CONTENT = "handpanContent";
    public static final String NBT_DAMAGE = "handpanIncomingDamage";
    public static final String NBT_PROGRESS = "handpanProgress";
    public static final String NBT_SPEED = "handpanSpeed";
    private Icon[] icons;
    private String[] suffix = new String[]{"empty", "sinew", "silk"};

    public ItemHandpan(int id) {
        super(id, Material.wood, "handpan");
        this.setCreativeTab(CreativeTabs.tabTools);
        this.setCraftingDifficultyAsComponent(200.0f);
        this.setMaxStackSize(1);
        this.setMaxDamage(160);
    }

    public void registerIcons(IconRegister register) {
        this.icons = new Icon[3];
        for (int i = 0; i < 3; ++i) {
            this.icons[i] = register.registerIcon(this.getIconString() + "_" + this.suffix[i]);
        }
    }

    public void getSubItems(int id, CreativeTabs tab, List list) {
        for (int sub = 0; sub < 3; ++sub) {
            list.add(new ItemStack(id, 1, sub));
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        if (stack == null) {
            return super.getUnlocalizedName(stack);
        }
        int subType = stack.getItemSubtype();
        return super.getUnlocalizedName() + "." + this.suffix[subType];
    }

    public int getSimilarityToItem(Item item) {
        if (item instanceof ItemHandpan) {
            return 2;
        }
        return super.getSimilarityToItem(item);
    }

    public boolean onItemRightClick(EntityPlayer player, float partial_tick, boolean ctrl_is_down) {
        short store;
        ItemStack stack = player.getHeldItemStack();
        NBTTagCompound nbt = stack.getTagCompound();
        short s = store = nbt == null ? (short)0 : nbt.getShort(NBT_CONTENT);
        if (this.hasMesh(stack) && store == 0) {
            if (player.onClient()) {
                player.swingArm();
                return true;
            }
            ItemStack block = this.getBlockFromHotbar(player);
            if (block != null) {
                HandpanRecipe recipe = HandpanRecipeProcessor.getRecipe(block.itemID, stack.getItemSubtype());
                int use = recipe.getSpeed();
                int damage = recipe.getDamage();
                stack.setTagInfo(NBT_CONTENT, (NBTBase)new NBTTagShort(NBT_CONTENT, (short)block.itemID));
                stack.setTagInfo(NBT_PROGRESS, (NBTBase)new NBTTagShort(NBT_PROGRESS, (short)use));
                stack.setTagInfo(NBT_SPEED, (NBTBase)new NBTTagShort(NBT_SPEED, (short)use));
                stack.setTagInfo(NBT_DAMAGE, (NBTBase)new NBTTagByte(NBT_DAMAGE, (byte)damage));
                player.worldObj.playSoundAtEntity((Entity)player, "miterenewed:item.handpan.insert", 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        if (this.hasMesh(stack) && store != 0 && player.isInWater()) {
            return player.setHeldItemInUse();
        }
        return super.onItemRightClick(player, partial_tick, ctrl_is_down);
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int use) {
        if (stack.hasTagCompound()) {
            stack.setTagInfo(NBT_PROGRESS, (NBTBase)new NBTTagShort(NBT_PROGRESS, (short)use));
        }
    }

    public void onItemUseFinish(ItemStack stack, World world, EntityPlayer player) {
        if (player.onServer()) {
            short content = stack.getTagCompound().getShort(NBT_CONTENT);
            byte damage = stack.getTagCompound().getByte(NBT_DAMAGE);
            List<ItemStack> stacks = HandpanRecipeProcessor.processRecipe(world, stack, content);
            for (ItemStack output : stacks) {
                player.dropItemStack(output);
            }
            player.tryDamageHeldItem(DamageSource.generic, (int)damage);
            if (!stacks.isEmpty()) {
                world.playSoundAtEntity((Entity)player, "random.pop", 1.0f, 1.0f);
            }
        }
        stack.setTagInfo(NBT_CONTENT, (NBTBase)new NBTTagShort(NBT_CONTENT, 0));
    }

    public boolean hasMesh(ItemStack stack) {
        return stack.getItemSubtype() != 0;
    }

    private ItemStack getBlockFromHotbar(EntityPlayer player) {
        InventoryPlayer inventory = player.inventory;
        for (int i = 0; i < 9; ++i) {
            ItemStack at = inventory.getStackInSlot(i);
            if (at == null || !at.isBlock() || !HandpanRecipeProcessor.hasRecipe(at, player.getHeldItemStack().getItemSubtype())) continue;
            return inventory.decrStackSize(i, 1);
        }
        return null;
    }

    public void addInformation(ItemStack item_stack, EntityPlayer player, List info, boolean extended_info, Slot slot) {
        if (extended_info) {
            short blockID;
            NBTTagCompound nbt;
            if (item_stack.hasTagCompound() && (nbt = item_stack.getTagCompound()).hasKey(NBT_CONTENT) && (blockID = nbt.getShort(NBT_CONTENT)) != 0) {
                Block block = Block.getBlock((int)blockID);
                String translatedName = block.getLocalizedName();
                info.add(String.valueOf(EnumChatFormatting.DARK_GRAY) + Translator.getFormatted((String)"tooltip.handpan.contains", (Object[])new Object[0]) + " " + translatedName);
                return;
            }
            info.add(String.valueOf(EnumChatFormatting.DARK_GRAY) + Translator.getFormatted((String)"tooltip.handpan.contains", (Object[])new Object[0]) + " " + Translator.getFormatted((String)"tooltip.handpan.nothing", (Object[])new Object[0]));
        }
    }

    public Icon getIconFromSubtype(int sub) {
        return this.icons[sub];
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return ItemHandpan.getWeightedMaxUseDuration(stack);
    }

    public static int getWeightedMaxUseDuration(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.hasTagCompound() && (nbt = stack.getTagCompound()).hasKey(NBT_PROGRESS)) {
            return stack.getTagCompound().getShort(NBT_PROGRESS);
        }
        return 200;
    }

    public static int getIntendedSpeed(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.hasTagCompound() && (nbt = stack.getTagCompound()).hasKey(NBT_SPEED)) {
            return stack.getTagCompound().getShort(NBT_SPEED);
        }
        return 200;
    }

    public static int getTicksUsing(ItemStack stack, int use) {
        return stack.getMaxItemUseDuration() - use;
    }

    public static float getFractionUsing(ItemStack stack, int use) {
        float ticks = ItemHandpan.getTicksUsing(stack, use);
        return Math.min(ticks / (float)ItemHandpan.getIntendedSpeed(stack), 1.0f);
    }

    public EnumItemInUseAction getItemInUseAction(ItemStack par1ItemStack, EntityPlayer player) {
        return EnumItemInUseAction.BOW;
    }

    public int getNumComponentsForDurability() {
        return 0;
    }

    public int getRepairCost() {
        return 0;
    }
}

