/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.entity;

import com.github.jeffyjamzhd.renewed.item.ItemPolearm;
import com.github.jeffyjamzhd.renewed.registry.RenewedItems;
import java.util.Objects;
import java.util.Random;
import net.minecraft.AxisAlignedBB;
import net.minecraft.Block;
import net.minecraft.Damage;
import net.minecraft.DamageSource;
import net.minecraft.EnchantmentThorns;
import net.minecraft.Entity;
import net.minecraft.EntityDamageResult;
import net.minecraft.EntityEnderman;
import net.minecraft.EntityGelatinousCube;
import net.minecraft.EntityLivingBase;
import net.minecraft.EntityPhaseSpider;
import net.minecraft.EntityPlayer;
import net.minecraft.EntitySkeleton;
import net.minecraft.EntityThrowable;
import net.minecraft.EnumEntityFX;
import net.minecraft.EnumParticle;
import net.minecraft.EnumSignal;
import net.minecraft.IProjectile;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.Material;
import net.minecraft.MathHelper;
import net.minecraft.Minecraft;
import net.minecraft.NBTBase;
import net.minecraft.NBTTagCompound;
import net.minecraft.NBTTagList;
import net.minecraft.Packet;
import net.minecraft.Packet70GameEvent;
import net.minecraft.Packet85SimpleSignal;
import net.minecraft.Raycast;
import net.minecraft.RaycastCollision;
import net.minecraft.ServerPlayer;
import net.minecraft.SignalData;
import net.minecraft.Vec3;
import net.minecraft.World;
import net.minecraft.WorldClient;

public class EntityPolearm
extends EntityThrowable
implements IProjectile {
    public EntityLivingBase owner;
    private Entity lastHarmed;
    public int tX = -1;
    public int tY = -1;
    public int tZ = -1;
    private ItemPolearm item;
    private NBTTagList enchants;
    private int durability;
    private double damage = 2.0;
    private int knockback;
    private int ticksInGround;
    private int ticksInAir;
    private boolean inGround;
    private boolean canPickup;
    private int inTile;
    private int inData;
    private int ticks_until_next_fizz_sound;
    public int polearmShake = 0;
    public boolean wasOnFire = false;

    public EntityPolearm(World world) {
        super(world);
        this.setSize(0.5f, 0.5f);
        this.renderDistanceWeight = 10.0;
        this.item = RenewedItems.flint_spear;
        this.damage = this.item.getScaledDamage(2.0f);
    }

    public EntityPolearm(World world, EntityLivingBase entity, float vel, ItemPolearm item, int durability, NBTTagList enchants) {
        super(world);
        this.setSize(1.0f, 1.0f);
        this.renderDistanceWeight = 10.0;
        this.owner = entity;
        this.item = item;
        this.damage = this.item.getScaledDamage(2.0f);
        this.durability = durability;
        this.enchants = enchants;
        this.setLocationAndAngles(entity.posX, entity.posY + (double)entity.getEyeHeight(), entity.posZ, entity.rotationYaw, entity.rotationPitch);
        this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f) * (double)0.3f;
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f) * (double)0.3f;
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.yOffset = 0.0f;
        this.setPosition(this.posX, this.posY, this.posZ);
        float wander = 1.0f;
        EntityLivingBase entityLivingBase = this.owner;
        if (entityLivingBase instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            this.canPickup = true;
            int level = player.getExperienceLevel();
            if (level < 0) {
                wander = Math.min(1.0f + -0.75f * (float)level, 8.0f);
            }
        }
        if (entity.isSuspendedInLiquid()) {
            wander *= 2.0f;
        }
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, vel * 1.5f, wander);
    }

    public EntityPolearm(WorldClient worldClient, double x, double y, double z, int itemID, int thrower) {
        super((World)worldClient, x, y, z);
        this.setSize(0.5f, 0.5f);
        this.renderDistanceWeight = 15.0;
        this.item = (ItemPolearm)Item.getItem((int)itemID);
        this.owner = (EntityLivingBase)worldClient.getEntityByID(thrower);
    }

    public void onUpdate() {
        AxisAlignedBB var2;
        int blockId;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float var1 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, var1) * 180.0 / Math.PI);
        }
        if ((blockId = this.worldObj.getBlockId(this.tX, this.tY, this.tZ)) > 0 && (var2 = Block.blocksList[blockId].getCollisionBoundsCombined(this.worldObj, this.tX, this.tY, this.tZ, (Entity)this, true)) != null && var2.isVecInside(this.worldObj.getWorldVec3Pool().getVecFromPool(this.posX, this.posY, this.posZ))) {
            this.inGround = true;
        }
        if (this.polearmShake > 0) {
            --this.polearmShake;
        }
        if (!this.worldObj.isRemote && this.wasOnFire) {
            Block block;
            Block block2 = block = this.inGround ? Block.getBlock((int)this.inTile) : null;
            if (block != null && block.blockMaterial.isFreezing()) {
                if (!this.isWet()) {
                    this.causeQuenchEffect();
                }
                this.extinguish();
            } else if (this.isInWater()) {
                this.causeQuenchEffect();
            } else if (this.isWet() && --this.ticks_until_next_fizz_sound <= 0) {
                this.spawnSingleSteamParticle(true);
                this.ticks_until_next_fizz_sound = this.rand.nextInt(17) + 3;
            }
        }
        this.wasOnFire = this.isBurning();
        if (this.inGround) {
            int blockId2 = this.worldObj.getBlockId(this.tX, this.tY, this.tZ);
            int meta = this.worldObj.getBlockMetadata(this.tX, this.tY, this.tZ);
            if (blockId2 == this.inTile && (meta == this.inData || this.inTile == Block.grass.blockID)) {
                ++this.ticksInGround;
                if (this.ticksInGround >= (this.owner instanceof EntityPlayer ? 24000 : 1000)) {
                    this.setDead();
                }
            } else {
                this.inGround = false;
                Random rand = new Random(this.entityId);
                this.motionX *= (double)(rand.nextFloat() * 0.2f);
                this.motionY *= (double)(rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(rand.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            Entity entity;
            RaycastCollision collision;
            ++this.ticksInAir;
            if (this.onServer()) {
                AxisAlignedBB bb = this.boundingBox.copy();
                if (this.worldObj.isBoundingBoxBurning(bb.contract(0.001, 0.001, 0.001), true)) {
                    this.setFire(8);
                } else if (this.worldObj.isBoundingBoxBurning(bb.contract(0.001, 0.001, 0.001).translate(this.motionX / 2.0, this.motionY / 2.0, this.motionZ / 2.0), true)) {
                    this.setFire(8);
                }
            }
            Vec3 current_pos = this.worldObj.getVec3(this.posX, this.posY, this.posZ);
            Vec3 future_pos = this.worldObj.getVec3(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            Raycast raycast = new Raycast(this.worldObj, current_pos, future_pos).setForPiercingProjectile((Entity)this).performVsBlocks();
            RaycastCollision collisionCopy = collision = raycast.getBlockCollision();
            if (collision != null) {
                raycast.setLimitToBlockCollisionPoint();
            }
            if (raycast.performVsEntities().hasEntityCollisions()) {
                collision = raycast.getNearestCollision();
            }
            if (collision != null && (entity = collision.getEntityHit()) instanceof EntityPlayer) {
                EntityPlayer attacker;
                EntityLivingBase entityLivingBase;
                EntityPlayer player = (EntityPlayer)entity;
                if (player.capabilities.disableDamage || (entityLivingBase = this.owner) instanceof EntityPlayer && !(attacker = (EntityPlayer)entityLivingBase).canAttackPlayer(player)) {
                    collision = null;
                }
            }
            if (collision == null || !collision.isEntity()) {
                this.lastHarmed = null;
            }
            if (collision != null) {
                if (!collision.isEntity()) {
                    this.handleCollisionWithBlock(collision);
                } else {
                    boolean immuneToProjectile;
                    EntityGelatinousCube cube;
                    Entity hit = collision.getEntityHit();
                    float vel = this.getVelocity();
                    float damageMult = 1.0f;
                    if (hit instanceof EntityLivingBase) {
                        EntityLivingBase entityHit = (EntityLivingBase)hit;
                        if (entityHit.isEntityUndead() && this.item.getToolMaterial() == Material.silver) {
                            damageMult *= 1.25f;
                        }
                        if (entityHit instanceof EntitySkeleton) {
                            damageMult *= 0.25f;
                        }
                    }
                    if (this.getIsCritical()) {
                        damageMult *= 1.5f + this.rand.nextFloat() * 0.5f;
                    }
                    DamageSource damageSource = DamageSource.causeThrownDamage((Entity)this, (Entity)((Entity)Objects.requireNonNullElse(this.owner, this)));
                    if (this.isBurning() && !(hit instanceof EntityEnderman)) {
                        if (hit instanceof EntityGelatinousCube) {
                            if (this.onServer()) {
                                if (this.getVelocity() < 1.0f) {
                                    hit.attackEntityFrom(new Damage(DamageSource.inFire, 1.0f));
                                    this.extinguish(true);
                                } else {
                                    damageMult += 1.0f;
                                    hit.entityFX(EnumEntityFX.steam_with_hiss);
                                }
                            }
                        } else {
                            hit.setFire(5);
                        }
                    }
                    if (hit instanceof EntityGelatinousCube && (cube = (EntityGelatinousCube)hit).isAcidic() && this.item.isHarmedByAcid()) {
                        if (this.onServer()) {
                            this.entityFX(EnumEntityFX.steam_with_hiss);
                        }
                        this.setDead();
                    }
                    Damage damage = new Damage(damageSource, (float)((double)damageMult * this.damage));
                    boolean bl = immuneToProjectile = hit.isEntityInvulnerable() || hit.isImmuneTo(damageSource);
                    if (hit != this.lastHarmed) {
                        if (!(this.getVelocity() < 1.0f) && !immuneToProjectile) {
                            if (this.onServer()) {
                                EntityDamageResult result = hit.attackEntityFrom(damage);
                                if (result == null && hit instanceof EntityPhaseSpider) {
                                    if (collisionCopy != null) {
                                        this.handleCollisionWithBlock(collisionCopy);
                                    }
                                } else if (result != null && result.entityWasNegativelyAffected()) {
                                    this.lastHarmed = hit;
                                    if (hit instanceof EntityLivingBase) {
                                        EntityLivingBase target = (EntityLivingBase)hit;
                                        if (this.owner != null) {
                                            EntityLivingBase entityLivingBase;
                                            float var27;
                                            this.owner.setLastAttackTarget((Entity)target);
                                            if (this.knockback > 0 && (var27 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ))) > 0.0f) {
                                                hit.addVelocity(this.motionX * (double)this.knockback * (double)0.6f / (double)var27, 0.1, this.motionZ * (double)this.knockback * (double)0.6f / (double)var27);
                                            }
                                            if (this.owner != null) {
                                                if (this.worldObj.isRemote) {
                                                    System.out.println("EntityPolearm.onUpdate() is calling EnchantmentThorns.func_92096_a() on client");
                                                    Minecraft.temp_debug = "arrow";
                                                }
                                                EnchantmentThorns.func_92096_a((Entity)this.owner, (EntityLivingBase)target, (Random)this.rand);
                                            }
                                            if (this.owner != null && hit != this.owner && hit instanceof EntityPlayer && (entityLivingBase = this.owner) instanceof ServerPlayer) {
                                                ServerPlayer serverPlayer = (ServerPlayer)entityLivingBase;
                                                serverPlayer.playerNetServerHandler.sendPacketToPlayer((Packet)new Packet70GameEvent(6, 0));
                                            }
                                        }
                                    }
                                }
                                this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                                if (!(hit instanceof EntityEnderman)) {
                                    this.bounceBack();
                                }
                                if (this.owner != null && hit instanceof EntityPlayer) {
                                    this.owner.refreshDespawnCounter(-9600);
                                }
                                this.onImpact(collision);
                            } else {
                                this.bounceBack();
                            }
                        }
                    } else {
                        this.bounceBack();
                    }
                }
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            float var20 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.rotationPitch = (float)(Math.atan2(this.motionY, var20) * 180.0 / Math.PI);
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float drag = 0.99f;
            float deaccel = 0.05f;
            float damp = 0.25f;
            if (this.isInWater()) {
                for (int i = 0; i < 4; ++i) {
                    this.worldObj.spawnParticle(EnumParticle.bubble, this.posX - this.motionX * (double)damp, this.posY - this.motionY * (double)damp, this.posZ - this.motionZ * (double)damp, this.motionX, this.motionY, this.motionZ);
                }
                drag = 0.8f;
            }
            this.motionX *= (double)drag;
            this.motionY *= (double)drag;
            this.motionZ *= (double)drag;
            this.motionY -= (double)deaccel;
            this.setPosition(this.posX, this.posY, this.posZ);
            this.doBlockCollisions();
        }
    }

    protected void onImpact(RaycastCollision col) {
        if (this.item != null && this.item.getItemStackForStatsIcon().getMaxDamage() - this.durability <= 0) {
            Entity entity;
            this.setDead();
            this.playSound("random.break", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
            if (!this.worldObj.isRemote && (entity = col.getEntityHit()) instanceof EntityLivingBase) {
                EntityLivingBase hit = (EntityLivingBase)entity;
                hit.entityFX(EnumEntityFX.item_breaking, new SignalData().setByte(0).setShort(this.item.itemID));
            }
        }
    }

    private void handleCollisionWithBlock(RaycastCollision col) {
        this.tX = col.block_hit_x;
        this.tY = col.block_hit_y;
        this.tZ = col.block_hit_z;
        this.inTile = this.worldObj.getBlockId(this.tX, this.tY, this.tZ);
        this.inData = this.worldObj.getBlockMetadata(this.tX, this.tY, this.tZ);
        this.motionX = col.position_hit.xCoord - this.posX;
        this.motionY = col.position_hit.yCoord - this.posY;
        this.motionZ = col.position_hit.zCoord - this.posZ;
        float var20 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
        this.posX -= this.motionX / (double)var20 * (double)0.05f;
        this.posY -= this.motionY / (double)var20 * (double)0.05f;
        this.posZ -= this.motionZ / (double)var20 * (double)0.05f;
        this.playSound("random.bowhit", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.polearmShake = 7;
        this.setIsCritical(false);
        if (this.inTile != 0) {
            Block.blocksList[this.inTile].onEntityCollidedWithBlock(this.worldObj, this.tX, this.tY, this.tZ, (Entity)this);
        }
        if (this.onServer()) {
            this.sendPacketToAllPlayersTrackingEntity((Packet)new Packet85SimpleSignal(EnumSignal.arrow_hit_block).setEntityID((Entity)this).setExactPosition(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ));
        }
        this.onImpact(col);
    }

    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.setPosition(par1, par3, par5);
        this.setRotation(par7, par8);
    }

    public void setVelocity(double par1, double par3, double par5) {
        this.motionX = par1;
        this.motionY = par3;
        this.motionZ = par5;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float var7 = MathHelper.sqrt_double((double)(par1 * par1 + par5 * par5));
            this.prevRotationYaw = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.prevRotationPitch = (float)(Math.atan2(par3, var7) * 180.0 / Math.PI);
            this.ticksInGround = 0;
        }
    }

    public void spentTickInLava() {
        if (this.inGround) {
            super.spentTickInLava();
        }
    }

    public boolean cannotRaycastCollideWith(Entity entity) {
        return entity == this.owner && this.ticksInAir < 5 ? true : super.cannotRaycastCollideWith(entity);
    }

    public void setIsCritical(boolean par1) {
        byte var2 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (Object)((byte)(var2 | 1)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(var2 & 0xFFFFFFFE)));
        }
    }

    public boolean getIsCritical() {
        byte var1 = this.dataWatcher.getWatchableObjectByte(16);
        return (var1 & 1) != 0;
    }

    public float getVelocity() {
        return MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
    }

    public ItemPolearm getItem() {
        return this.item;
    }

    private void bounceBack() {
        this.motionX *= (double)-0.1f;
        this.motionY *= (double)-0.1f;
        this.motionZ *= (double)-0.1f;
        this.rotationYaw += 180.0f;
        this.prevRotationYaw += 180.0f;
        this.ticksInAir = 0;
        this.motionX /= 4.0;
        this.motionY /= -4.0;
        this.motionZ /= 4.0;
    }

    protected void entityInit() {
        this.dataWatcher.addObject(16, (Object)0);
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        nbt.setShort("xTile", (short)this.tX);
        nbt.setShort("yTile", (short)this.tY);
        nbt.setShort("zTile", (short)this.tZ);
        nbt.setByte("inTile", (byte)this.inTile);
        nbt.setByte("inData", (byte)this.inData);
        nbt.setByte("shake", (byte)this.polearmShake);
        nbt.setBoolean("inGround", this.inGround);
        nbt.setBoolean("pickup", this.canPickup);
        nbt.setDouble("damage", this.damage);
        if (this.enchants != null) {
            nbt.setTag("polearm_enchant", (NBTBase)this.enchants);
        }
        nbt.setInteger("polearm_id", this.item.itemID);
        nbt.setInteger("polearm_durability", this.durability);
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        this.tX = nbt.getShort("xTile");
        this.tY = nbt.getShort("yTile");
        this.tZ = nbt.getShort("zTile");
        this.inTile = nbt.getByte("inTile") & 0xFF;
        this.inData = nbt.getByte("inData") & 0xFF;
        this.polearmShake = nbt.getByte("shake") & 0xFF;
        this.inGround = nbt.getBoolean("inGround");
        if (nbt.hasKey("pickup")) {
            this.canPickup = nbt.getBoolean("pickup");
        }
        if (nbt.hasKey("damage")) {
            this.damage = nbt.getDouble("damage");
        }
        if (nbt.hasKey("polearm_enchant")) {
            this.enchants = nbt.getTagList("polearm_enchant");
        }
        this.item = (ItemPolearm)Item.itemsList[nbt.getInteger("polearm_id")];
        this.durability = nbt.getInteger("polearm_durability");
    }

    public void onCollideWithPlayer(EntityPlayer player) {
        if (!this.worldObj.isRemote && this.inGround && this.polearmShake <= 0) {
            ItemStack polearm = new ItemStack((Item)this.item, 1).setItemDamage(this.durability);
            if (this.enchants != null) {
                polearm.setTagInfo("ench", (NBTBase)this.enchants);
            }
            if (player.inventory.addItemStackToInventory(polearm)) {
                this.playSound("random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.onItemPickup((Entity)this, 1);
                this.setDead();
            }
        }
    }

    public Item getModelItem() {
        return this.getItem();
    }

    public EntityLivingBase getThrower() {
        return this.owner;
    }

    public int getOwnerRID() {
        return this.owner != null ? this.owner.entityId : 0;
    }

    public void setDamage(double value) {
        this.damage = value;
    }

    public void setKnockback(int value) {
        this.knockback = value;
    }

    public float getShadowSize() {
        return 0.0f;
    }

    public void setThrowableHeading(double par1, double par3, double par5, float velocity, float par8) {
        float var9 = MathHelper.sqrt_double((double)(par1 * par1 + par3 * par3 + par5 * par5));
        par1 /= (double)var9;
        par3 /= (double)var9;
        par5 /= (double)var9;
        par1 += this.rand.nextGaussian() * (double)(this.rand.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)par8;
        par3 += this.rand.nextGaussian() * (double)(this.rand.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)par8;
        par5 += this.rand.nextGaussian() * (double)(this.rand.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)par8;
        this.motionX = par1 *= (double)velocity;
        this.motionY = par3 *= (double)velocity;
        this.motionZ = par5 *= (double)velocity;
        float var10 = MathHelper.sqrt_double((double)(par1 * par1 + par5 * par5));
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(par3, var10) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }
}

