/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.compat.emi.recipe;

import com.github.jeffyjamzhd.renewed.compat.emi.RenewedRecipeCategories;
import com.github.jeffyjamzhd.renewed.item.recipe.HandpanRecipe;
import com.github.jeffyjamzhd.renewed.registry.RenewedItems;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Comparator;
import java.util.List;
import net.minecraft.EnumChatFormatting;
import net.minecraft.ItemStack;
import net.minecraft.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import shims.java.net.minecraft.text.Text;
import shims.java.net.minecraft.util.SyntheticIdentifier;

public class HandpanEMIRecipe
implements EmiRecipe {
    private EmiIngredient input;
    private List<EmiHandpanIngredient> outputs;
    private EmiIngredient mesh;
    private int damage;
    private int speed;

    public HandpanEMIRecipe(HandpanRecipe recipe) {
        this.input = EmiStack.of((ItemStack)recipe.getInput());
        this.outputs = recipe.getOutputs().stream().map(output -> new EmiHandpanIngredient(EmiStack.of((ItemStack)output.getItem()), output.getChance())).toList();
        this.mesh = EmiStack.of((ItemStack)new ItemStack(RenewedItems.handpan, 1, (int)recipe.getSubtype()));
        this.damage = recipe.getDamage();
        this.speed = recipe.getSpeed();
    }

    public EmiRecipeCategory getCategory() {
        return RenewedRecipeCategories.HANDPAN;
    }

    @Nullable
    public ResourceLocation getId() {
        return new SyntheticIdentifier((Object)this);
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of((List)this.input.getEmiStacks()), EmiIngredient.of((List)this.mesh.getEmiStacks()));
    }

    public List<EmiStack> getOutputs() {
        return this.outputs.stream().map(emiHandpanIngredient -> emiHandpanIngredient.item).toList();
    }

    public int getDisplayWidth() {
        return 120;
    }

    public int getDisplayHeight() {
        return 64;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        SlotWidget input = widgetHolder.addSlot(this.input, this.getDisplayWidth() / 2 - 18, 3);
        SlotWidget mesh = widgetHolder.addSlot(this.mesh, this.getDisplayWidth() / 2, 3);
        List<Object> renderOutputs = this.outputs.stream().sorted(Comparator.comparingDouble(value -> ((EmiHandpanIngredient)value).chance).reversed()).toList();
        String formatting = EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC.toString();
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 2; ++y) {
                int ind = x + 5 * y;
                if (ind < renderOutputs.size()) {
                    SlotWidget widget = widgetHolder.addSlot((EmiIngredient)((EmiHandpanIngredient)renderOutputs.get((int)ind)).item, this.getDisplayWidth() / 2 - 8 + 18 * (x - 2), 25 + 18 * y);
                    widget.appendTooltip((Text)Text.literal((String)formatting).append((Text)Text.translatable((String)"tooltip.emi.handpan.chance", (Object[])new Object[]{(int)(((EmiHandpanIngredient)renderOutputs.get((int)ind)).chance * 100.0f)})));
                    continue;
                }
                widgetHolder.addSlot(this.getDisplayWidth() / 2 - 8 + 18 * (x - 2), 25 + 18 * y);
            }
        }
        mesh.appendTooltip((Text)Text.literal((String)formatting).append((Text)Text.translatable((String)"tooltip.emi.handpan.process", (Object[])new Object[]{this.damage})));
        input.appendTooltip((Text)Text.literal((String)formatting).append((Text)Text.translatable((String)"tooltip.emi.handpan.time", (Object[])new Object[]{Float.valueOf(this.speedToSeconds())})));
    }

    private float speedToSeconds() {
        return (float)this.speed / 20.0f;
    }

    public class EmiHandpanIngredient {
        public EmiStack item;
        public float chance;

        public EmiHandpanIngredient(EmiStack item, float chance) {
            this.item = item;
            this.chance = chance;
        }
    }
}

