/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.compat.emi;

import com.github.jeffyjamzhd.renewed.MiTERenewed;
import com.github.jeffyjamzhd.renewed.api.recipe.FurnaceEntry;
import com.github.jeffyjamzhd.renewed.compat.emi.RenewedRecipeCategories;
import com.github.jeffyjamzhd.renewed.compat.emi.recipe.HandpanEMIRecipe;
import com.github.jeffyjamzhd.renewed.item.ItemRenewedFood;
import com.github.jeffyjamzhd.renewed.item.recipe.HandpanRecipe;
import com.github.jeffyjamzhd.renewed.item.recipe.HandpanRecipeProcessor;
import com.github.jeffyjamzhd.renewed.registry.RenewedItems;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.recipe.EmiCookingRecipe;
import java.util.Iterator;
import java.util.List;
import moddedmite.emi.recipe.EmiFoodRecipe;
import net.minecraft.Block;
import net.minecraft.FurnaceRecipes;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.ResourceLocation;

public class RenewedEMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry reg) {
        MiTERenewed.LOGGER.info("Registering EMI plugin.");
        reg.addCategory(RenewedRecipeCategories.HANDPAN);
        for (HandpanRecipe recipe : HandpanRecipeProcessor.getRecipes().values()) {
            reg.addRecipe((EmiRecipe)new HandpanEMIRecipe(recipe));
        }
        for (FurnaceEntry entry : FurnaceRecipes.smelting().mr$getComplexEntries()) {
            ResourceLocation cookingId = new ResourceLocation("miterenewed:furnace/" + entry.hashCode());
            ResourceLocation resourceLocation = new ResourceLocation("miterenewed:world/" + entry.hashCode());
            reg.addRecipe((EmiRecipe)new EmiCookingRecipe(cookingId, entry.input(), entry.output(), VanillaEmiRecipeCategories.SMELTING, 0, entry.output().getExperienceReward()));
            ItemRenewedFood input = (ItemRenewedFood)entry.input().getItem();
            ItemRenewedFood output = (ItemRenewedFood)entry.output().getItem();
            if (input.cookedFood == null || output.uncookedFood == null) continue;
            reg.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(resourceLocation).leftInput((EmiIngredient)EmiStack.of((ItemStack)entry.input().copy().splitStack(1))).rightInput(EmiIngredient.of(List.of(EmiStack.of((ItemStack)new ItemStack((Block)Block.fire)))), true).output(EmiStack.of((ItemStack)entry.output().copy().splitStack(1))).build());
        }
        for (Iterator<HandpanRecipe> iterator : Item.itemsList) {
            if (!(iterator instanceof ItemRenewedFood)) continue;
            for (int sub = 0; sub < iterator.getNumSubtypes(); ++sub) {
                reg.addRecipe((EmiRecipe)new EmiFoodRecipe(new ItemStack(((Item)iterator).itemID, 1, sub)));
            }
        }
    }

    static {
        RenewedRecipeCategories.HANDPAN = new EmiRecipeCategory(new ResourceLocation("miterenewed:handpan"), (EmiRenderable)EmiStack.of((ItemStack)new ItemStack(RenewedItems.handpan, 1, 2)));
    }
}

