/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.api.sound;

import com.github.jeffyjamzhd.renewed.api.registry.CraftingSoundRegistry;
import com.github.jeffyjamzhd.renewed.api.sound.CraftingSound;
import net.minecraft.EntityPlayer;
import net.minecraft.IRecipe;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.Material;
import net.minecraft.World;

public class CraftingSoundHandler {
    public static void onCraft(ItemStack output, IRecipe recipe, World world, EntityPlayer player) {
        Material mat;
        Item item = output.getItem();
        if (CraftingSoundRegistry.ITEM_SOUNDS.containsKey(item.itemID)) {
            CraftingSound entry = CraftingSoundRegistry.ITEM_SOUNDS.get(item.itemID);
            entry.attemptSound(output, recipe, world, player);
            return;
        }
        if (item.getMaterialForRepairs() != null) {
            mat = item.getMaterialForRepairs();
            if (CraftingSoundRegistry.MATERIAL_SOUNDS.containsKey(mat)) {
                CraftingSound entry = CraftingSoundRegistry.MATERIAL_SOUNDS.get(mat);
                entry.attemptSound(output, recipe, world, player);
                return;
            }
        } else if (item.getMaterialForDurability() != null && CraftingSoundRegistry.MATERIAL_SOUNDS.containsKey(mat = item.getMaterialForDurability())) {
            CraftingSound entry = CraftingSoundRegistry.MATERIAL_SOUNDS.get(mat);
            entry.attemptSound(output, recipe, world, player);
            return;
        }
        int index = 0;
        while (item.getMaterial(index) != null) {
            Material mat2 = item.getMaterial(index);
            if (CraftingSoundRegistry.MATERIAL_SOUNDS.containsKey(mat2)) {
                CraftingSound entry = CraftingSoundRegistry.MATERIAL_SOUNDS.get(mat2);
                entry.attemptSound(output, recipe, world, player);
            }
            ++index;
        }
    }
}

