/*
 * Decompiled with CFR 0.152.
 */
package com.github.jeffyjamzhd.renewed.api.registry;

import com.github.jeffyjamzhd.renewed.render.gui.GuiMusic;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.I18n;

public class TracklistRegistry {
    public static TracklistRegistry INSTANCE = new TracklistRegistry();
    public static GuiMusic DISPLAY;
    public static HashMap<String, Track> TRACKLIST;
    public static Consumer<Track> REGISTRY;

    public void registerTrackList(Track ... tracks) {
        for (Track track : tracks) {
            REGISTRY.accept(track);
        }
    }

    public void registerTrack(Track track) {
        REGISTRY.accept(track);
    }

    public static Track track(String fileName, String artist, String trackName) {
        return new Track(fileName, artist, trackName);
    }

    public static Track getTrackFromSimpleName(String fileName) {
        if (!((String)fileName).contains(".ogg")) {
            fileName = (String)fileName + ".ogg";
        }
        return TRACKLIST.getOrDefault(fileName, null);
    }

    static {
        TRACKLIST = new HashMap();
        REGISTRY = s -> TRACKLIST.put(s.fileName, (Track)s);
    }

    public record Track(String fileName, String artist, String trackName) {
        private final String artist;
        private final String trackName;

        public String artist() {
            return I18n.getString((String)this.artist);
        }

        public String trackName() {
            return I18n.getString((String)this.trackName);
        }
    }
}

