/*
 * Decompiled with CFR 0.152.
 */
package moddedmite.waila.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigTab;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.SimpleConfigs;
import fi.dy.masa.malilib.config.interfaces.IConfigHandler;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigEnum;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.overlay.OverlayConfig;
import moddedmite.waila.config.EnumTooltipTheme;
import moddedmite.waila.config.WailaConfigScreen;
import moddedmite.waila.handlers.emi.EMIHandler;
import net.minecraft.GuiScreen;
import net.minecraft.Minecraft;
import net.xiaoyu233.fml.FishModLoader;

public class WailaConfig
extends SimpleConfigs
implements IWailaConfigHandler {
    public static final ConfigBoolean showTooltip = new ConfigBoolean("choice.showhidewaila", true);
    public static final ConfigBoolean showMods = new ConfigBoolean("choice.showmods", true);
    public static final ConfigBoolean showEnts = new ConfigBoolean("choice.showEnts", true);
    public static final ConfigBoolean metadata = new ConfigBoolean("choice.showhideidmeta", false);
    public static final ConfigBoolean liquid = new ConfigBoolean("choice.showliquids", false);
    public static final ConfigBoolean shiftblock = new ConfigBoolean("choice.shifttoggledblock", false);
    public static final ConfigBoolean shiftents = new ConfigBoolean("choice.shifttoggledents", false);
    public static final ConfigBoolean devMoveDownTooltip = new ConfigBoolean("choice.devMoveDownTooltip", false);
    public static final ConfigBoolean showhp = new ConfigBoolean("option.general.showhp", true);
    public static final ConfigBoolean showatk = new ConfigBoolean("option.general.showatk", true);
    public static final ConfigBoolean showarmor = new ConfigBoolean("option.general.showarmor", true);
    public static final ConfigBoolean showcrop = new ConfigBoolean("option.general.showcrop", true);
    public static final ConfigBoolean spawnertype = new ConfigBoolean("option.vanilla.spawntype", true);
    public static final ConfigBoolean repeater = new ConfigBoolean("option.vanilla.repeater", true);
    public static final ConfigBoolean redstone = new ConfigBoolean("option.vanilla.redstone", true);
    public static final ConfigBoolean comparator = new ConfigBoolean("option.vanilla.comparator", true);
    public static final ConfigBoolean leverstate = new ConfigBoolean("option.vanilla.leverstate", true);
    public static final ConfigBoolean skulltype = new ConfigBoolean("option.vanilla.skulltype", true);
    public static final ConfigInteger posX = new ConfigInteger("screen.label.posX", 50, 0, 100, true, "");
    public static final ConfigInteger posY = new ConfigInteger("screen.label.posY", 1, 0, 100, true, "");
    public static final ConfigInteger alpha = new ConfigInteger("screen.label.alpha", 80, 0, 100, true, "");
    public static final ConfigDouble scale = new ConfigDouble("screen.label.scale", 1.0, 0.2, 2.0, true, "");
    public static final ConfigDouble lerpfactor = new ConfigDouble("screen.label.lerpfactor", 0.3, 0.1, 1.0, true, "");
    public static final ConfigBoolean icon = new ConfigBoolean("screen.label.icon", true);
    public static final ConfigEnum<EnumTooltipTheme> theme = new ConfigEnum("screen.label.TooltipTheme", (Enum)EnumTooltipTheme.Waila);
    public static final ConfigColor bgcolor = new ConfigColor("screen.label.bgcolor", "#FF100010");
    public static final ConfigColor gradient1 = new ConfigColor("screen.label.gradient1", "#FF5000FF");
    public static final ConfigColor gradient2 = new ConfigColor("screen.label.gradient2", "#FF28007F");
    public static final ConfigColor fontcolor = new ConfigColor("screen.label.fontcolor", "#FFA0A0A0");
    public static final ConfigHotkey wailaconfig = new ConfigHotkey("waila.keybind.wailaconfig", 82);
    public static final ConfigHotkey wailadisplay = new ConfigHotkey("waila.keybind.wailadisplay", 79);
    public static final ConfigHotkey keyliquid = new ConfigHotkey("waila.keybind.liquid", 80);
    public static final ConfigHotkey recipe = new ConfigHotkey("waila.keybind.recipe", 81);
    public static final ConfigHotkey usage = new ConfigHotkey("waila.keybind.usage", 75);
    private static WailaConfig Instance;
    public static List<ConfigBase> general;
    public static List<ConfigBase> features;
    public static List<ConfigBase> screen;
    public static List<ConfigHotkey> keybinding;
    public static final List<ConfigTab> tabs;

    public WailaConfig() {
        super("Waila", keybinding, general);
    }

    public List<ConfigTab> getConfigTabs() {
        return tabs;
    }

    public static WailaConfig getInstance() {
        return Instance;
    }

    public GuiScreen getConfigScreen(GuiScreen parentScreen) {
        return new WailaConfigScreen(parentScreen, (IConfigHandler)this);
    }

    public void save() {
        JsonObject root = new JsonObject();
        ConfigUtils.writeConfigBase((JsonObject)root, (String)"general", general);
        ConfigUtils.writeConfigBase((JsonObject)root, (String)"features", features);
        ConfigUtils.writeConfigBase((JsonObject)root, (String)"screen", screen);
        ConfigUtils.writeConfigBase((JsonObject)root, (String)"keybinding", keybinding);
        JsonUtils.writeJsonToFile((JsonObject)root, (File)this.optionsFile);
        OverlayConfig.updateColors();
    }

    public void load() {
        if (!this.optionsFile.exists()) {
            this.save();
        } else {
            JsonElement jsonElement = JsonUtils.parseJsonFile((File)this.optionsFile);
            if (jsonElement != null && jsonElement.isJsonObject()) {
                JsonObject root = jsonElement.getAsJsonObject();
                ConfigUtils.readConfigBase((JsonObject)root, (String)"general", general);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"features", features);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"screen", screen);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"keybinding", keybinding);
            }
        }
    }

    @Override
    public Set<String> getModuleNames() {
        return Set.of();
    }

    @Override
    public HashMap<String, String> getConfigKeys(String modName) {
        return (HashMap)wailaconfig.getKeybind();
    }

    @Override
    public boolean getConfig(String key, boolean defvalue) {
        return false;
    }

    @Override
    public boolean getConfig(String key) {
        return false;
    }

    static {
        tabs = new ArrayList<ConfigTab>();
        general = List.of(showTooltip, showMods, showEnts, metadata, liquid, shiftblock, shiftents, devMoveDownTooltip);
        features = List.of(showhp, showatk, showarmor, showcrop, spawnertype, repeater, redstone, comparator, leverstate, skulltype);
        screen = List.of(posX, posY, alpha, scale, lerpfactor, icon, theme, bgcolor, gradient1, gradient2, fontcolor);
        keybinding = List.of(wailaconfig, wailadisplay, keyliquid, recipe, usage);
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(features);
        values.addAll(keybinding);
        tabs.add(new ConfigTab("waila.general", general));
        tabs.add(new ConfigTab("waila.features", features));
        tabs.add(new ConfigTab("waila.screen", screen));
        tabs.add(new ConfigTab("waila.keybinding", keybinding));
        Instance = new WailaConfig();
        wailaconfig.getKeybind().setCallback((keyAction, iKeybind) -> {
            Minecraft.getMinecraft().displayGuiScreen(WailaConfig.getInstance().getConfigScreen(null));
            return true;
        });
        wailadisplay.getKeybind().setCallback((keyAction, iKeybind) -> {
            showTooltip.toggleBooleanValue();
            return true;
        });
        keyliquid.getKeybind().setCallback((keyAction, iKeybind) -> {
            liquid.toggleBooleanValue();
            return true;
        });
        if (FishModLoader.hasMod((String)"emi")) {
            try {
                recipe.getKeybind().setCallback((keyAction, iKeybind) -> {
                    EMIHandler.displayRecipes();
                    return true;
                });
                usage.getKeybind().setCallback((keyAction, iKeybind) -> {
                    EMIHandler.displayUses();
                    return true;
                });
            }
            catch (Exception ignored) {
                Waila.log.warn("You don't have EMI Mod installed");
            }
        }
    }
}

