/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityProvider;
import net.minecraft.Block;
import net.minecraft.CraftingManager;
import net.minecraft.Entity;
import net.minecraft.IRecipe;
import net.minecraft.Item;
import net.minecraft.ItemStack;
import net.minecraft.NBTTagCompound;
import net.minecraft.TileEntity;
import net.minecraft.World;

public class AccessHelper {
    public static Field getDeclaredField(String classname, String fieldname) {
        try {
            Class<?> class_ = Class.forName(classname);
            Field field_ = class_.getDeclaredField(fieldname);
            field_.setAccessible(true);
            return field_;
        }
        catch (NoSuchFieldException e) {
            Waila.log.warn(String.format("== Field %s %s not found !\n", classname, fieldname));
            return null;
        }
        catch (SecurityException e) {
            Waila.log.warn(String.format("== Field %s %s security exception !\n", classname, fieldname));
            return null;
        }
        catch (ClassNotFoundException e) {
            Waila.log.warn(String.format("== Class %s not found !\n", classname));
            return null;
        }
    }

    public static Object getField(String classname, String fieldname, Object instance) {
        try {
            Class<?> class_ = Class.forName(classname);
            Field field_ = class_.getDeclaredField(fieldname);
            field_.setAccessible(true);
            return field_.get(instance);
        }
        catch (NoSuchFieldException e) {
            Waila.log.warn(String.format("== Field %s %s not found !\n", classname, fieldname));
            return null;
        }
        catch (SecurityException e) {
            Waila.log.warn(String.format("== Field %s %s security exception !\n", classname, fieldname));
            return null;
        }
        catch (ClassNotFoundException e) {
            Waila.log.warn(String.format("== Class %s not found !\n", classname));
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Waila.log.warn(String.format("== %s\n", e));
            return null;
        }
    }

    public static Object getFieldExcept(String classname, String fieldname, Object instance) throws Exception {
        Class<?> class_ = Class.forName(classname);
        Field field_ = class_.getDeclaredField(fieldname);
        field_.setAccessible(true);
        return field_.get(instance);
    }

    public static Block getBlock(String classname, String fieldname) {
        Field field_ = AccessHelper.getDeclaredField(classname, fieldname);
        try {
            return (Block)field_.get(Block.class);
        }
        catch (Exception e) {
            System.out.printf("%s\n", e);
            Waila.log.warn(String.format("== ERROR GETTING BLOCK %s %s\n", classname, fieldname));
            return null;
        }
    }

    public static Item getItem(String classname, String fieldname) {
        Field field_ = AccessHelper.getDeclaredField(classname, fieldname);
        try {
            return (Item)field_.get(Item.class);
        }
        catch (Exception e) {
            System.out.printf("%s\n", e);
            Waila.log.warn(String.format("== ERROR GETTING ITEM %s %s\n", classname, fieldname));
            return null;
        }
    }

    public static ArrayList<IRecipe> getCraftingRecipes(ItemStack stack) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        return recipes;
    }

    public static void cleanCraftingRecipes(ItemStack stack) {
        for (IRecipe recipe : AccessHelper.getCraftingRecipes(stack)) {
            CraftingManager.getInstance().getRecipeList().remove(recipe);
        }
    }

    public static NBTTagCompound getNBTData(IWailaDataProvider provider, TileEntity entity, NBTTagCompound tag, World world, int x, int y, int z) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method getNBTData = provider.getClass().getMethod("getNBTData", TileEntity.class, NBTTagCompound.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        return (NBTTagCompound)getNBTData.invoke((Object)provider, entity, tag, world, x, y, z);
    }

    public static NBTTagCompound getNBTData(IWailaEntityProvider provider, Entity entity, NBTTagCompound tag) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method getNBTData = provider.getClass().getMethod("getNBTData", Entity.class, NBTTagCompound.class);
        return (NBTTagCompound)getNBTData.invoke((Object)provider, entity, tag);
    }
}

