/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import moddedmite.waila.config.WailaConfig;
import net.minecraft.Block;
import net.minecraft.Entity;
import net.minecraft.EntityLivingBase;
import net.minecraft.EnumEntityReachContext;
import net.minecraft.ItemStack;
import net.minecraft.Minecraft;
import net.minecraft.RaycastCollision;
import net.minecraft.TileEntity;
import net.minecraft.Vec3;
import net.minecraft.WorldClient;

public class RayTracing {
    private static RayTracing _instance;
    private final Minecraft mc = Minecraft.getMinecraft();
    private RaycastCollision target = null;

    private RayTracing() {
    }

    public static RayTracing instance() {
        if (_instance == null) {
            _instance = new RayTracing();
        }
        return _instance;
    }

    public void fire() {
        if (this.mc.objectMouseOver != null) {
            this.target = this.mc.objectMouseOver;
            return;
        }
        EntityLivingBase viewpoint = this.mc.renderViewEntity;
        if (viewpoint == null) {
            return;
        }
        this.target = this.rayTrace(viewpoint, this.getReach().floatValue(), 0.0f);
    }

    private Float getReach() {
        RaycastCollision rc = this.mc.objectMouseOver;
        float reach = 0.0f;
        if (rc != null) {
            if (rc.isBlock()) {
                reach = this.mc.thePlayer.getReach(rc.getBlockHit(), rc.world.getBlockMetadata(rc.block_hit_x, rc.block_hit_y, rc.block_hit_z));
            } else if (rc.isEntity()) {
                reach = this.mc.thePlayer.getReach(EnumEntityReachContext.FOR_MELEE_ATTACK, rc.getEntityHit());
            }
        }
        return Float.valueOf(reach);
    }

    public RaycastCollision getTarget() {
        return this.target;
    }

    public ItemStack getTargetStack() {
        return this.target != null && this.target.isBlock() ? this.getIdentifierStack() : null;
    }

    public Entity getTargetEntity() {
        return this.target != null && this.target.isEntity() ? this.getIdentifierEntity() : null;
    }

    public RaycastCollision rayTrace(EntityLivingBase entity, double par1, float par3) {
        Vec3 vec3 = entity.getPosition(par3);
        Vec3 vec31 = entity.getLook(par3);
        Vec3 vec32 = vec3.addVector(vec31.xCoord * par1, vec31.yCoord * par1, vec31.zCoord * par1);
        if (WailaConfig.liquid.getBooleanValue()) {
            return entity.worldObj.getBlockCollisionForSelection(vec3, vec32, true);
        }
        return entity.worldObj.getBlockCollisionForSelection(vec3, vec32, false);
    }

    public ItemStack getIdentifierStack() {
        ArrayList<ItemStack> items = this.getIdentifierItems();
        if (items.isEmpty()) {
            return null;
        }
        items.sort((stack0, stack1) -> stack1.getItemSubtype() - stack0.getItemSubtype());
        return items.get(0);
    }

    public Entity getIdentifierEntity() {
        ArrayList<Entity> ents = new ArrayList<Entity>();
        RaycastCollision raycastCollision = Minecraft.getMinecraft().objectMouseOver;
        if (this.target == null) {
            return null;
        }
        if (ModuleRegistrar.instance().hasOverrideEntityProviders(this.target.getEntityHit())) {
            for (List<IWailaEntityProvider> listProviders : ModuleRegistrar.instance().getOverrideEntityProviders(this.target.getEntityHit()).values()) {
                for (IWailaEntityProvider provider : listProviders) {
                    ents.add(provider.getWailaOverride(DataAccessorCommon.instance, WailaConfig.getInstance()));
                }
            }
        }
        if (!ents.isEmpty()) {
            return (Entity)ents.get(0);
        }
        return this.target.getEntityHit();
    }

    public ArrayList<ItemStack> getIdentifierItems() {
        ItemStack providerStack;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.target == null) {
            return items;
        }
        WorldClient world = this.mc.theWorld;
        int x = this.target.block_hit_x;
        int y = this.target.block_hit_y;
        int z = this.target.block_hit_z;
        Block mouseoverBlock = world.getBlock(x, y, z);
        TileEntity tileEntity = world.getBlockTileEntity(x, y, z);
        if (mouseoverBlock == null) {
            return items;
        }
        if (ModuleRegistrar.instance().hasStackProviders(mouseoverBlock)) {
            for (List<IWailaDataProvider> providersList : ModuleRegistrar.instance().getStackProviders(mouseoverBlock).values()) {
                for (IWailaDataProvider provider : providersList) {
                    providerStack = provider.getWailaStack(DataAccessorCommon.instance, WailaConfig.getInstance());
                    if (providerStack == null) continue;
                    if (providerStack.getItem() == null) {
                        return new ArrayList<ItemStack>();
                    }
                    items.add(providerStack);
                }
            }
        }
        if (tileEntity != null && ModuleRegistrar.instance().hasStackProviders(tileEntity)) {
            for (List<IWailaDataProvider> providersList : ModuleRegistrar.instance().getStackProviders(tileEntity).values()) {
                for (IWailaDataProvider provider : providersList) {
                    providerStack = provider.getWailaStack(DataAccessorCommon.instance, WailaConfig.getInstance());
                    if (providerStack == null) continue;
                    if (providerStack.getItem() == null) {
                        return new ArrayList<ItemStack>();
                    }
                    items.add(providerStack);
                }
            }
        }
        if (!items.isEmpty()) {
            return items;
        }
        if (world.getBlockTileEntity(x, y, z) == null) {
            try {
                ItemStack block = new ItemStack(mouseoverBlock, 1, world.getBlockMetadata(x, y, z));
                if (block.getItem() != null) {
                    items.add(block);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (items.isEmpty()) {
            items.add(0, new ItemStack(mouseoverBlock, 1, world.getBlockMetadata(x, y, z)));
        }
        return items;
    }
}

