/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import fi.dy.masa.malilib.util.Color4f;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.overlay.WailaTickHandler;
import moddedmite.waila.api.IBreakingProgress;
import moddedmite.waila.config.EnumTooltipTheme;
import moddedmite.waila.config.WailaConfig;
import net.minecraft.BossStatus;
import net.minecraft.Minecraft;
import net.minecraft.RaycastCollision;
import net.minecraft.RenderHelper;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    protected static boolean hasBlending;
    protected static boolean hasLight;
    protected static boolean hasDepthTest;
    protected static boolean hasLight0;
    protected static boolean hasLight1;
    protected static boolean hasRescaleNormal;
    protected static boolean hasColorMaterial;
    protected static int boundTexIndex;
    private static int lastProgressLine;
    private static int targetX;
    private static int targetY;
    private static int targetW;
    private static int targetH;
    private static float currentX;
    private static float currentY;
    private static float currentW;
    private static float currentH;
    private static float LERP_FACTOR;
    private static float lastBreakProgress;
    private static float currentAlpha;
    private static final float FADE_SPEED = 0.1f;

    public void renderOverlay() {
        Minecraft mc = Minecraft.getMinecraft();
        RaycastCollision rc = mc.objectMouseOver;
        if (mc.currentScreen != null) {
            return;
        }
        if (mc.theWorld == null) {
            return;
        }
        if (!Minecraft.isGuiEnabled()) {
            return;
        }
        if (mc.gameSettings.keyBindPlayerList.pressed) {
            return;
        }
        if (!WailaConfig.showTooltip.getBooleanValue()) {
            return;
        }
        if (RayTracing.instance().getTarget() == null) {
            return;
        }
        if (rc == null) {
            return;
        }
        Tooltip tooltip = WailaTickHandler.instance().tooltip;
        if (tooltip == null) {
            return;
        }
        if (rc.isBlock() && RayTracing.instance().getTargetStack() != null) {
            this.renderOverlay(tooltip);
        }
        if (rc.isEntity() && WailaConfig.showEnts.getBooleanValue()) {
            this.renderOverlay(tooltip);
        }
    }

    public void renderOverlay(Tooltip tooltip) {
        GL11.glPushMatrix();
        OverlayRenderer.saveGLState();
        if (tooltip != null) {
            if ((currentAlpha = DisplayUtil.lerp(currentAlpha, 1.0f, 0.1f)) > 0.99f) {
                currentAlpha = 1.0f;
            }
        } else if ((currentAlpha = DisplayUtil.lerp(currentAlpha, 0.0f, 0.1f)) < 0.01f) {
            currentAlpha = 0.0f;
        }
        if (currentAlpha <= 0.0f) {
            OverlayRenderer.loadGLState();
            GL11.glPopMatrix();
            return;
        }
        if (BossStatus.bossName != null && BossStatus.statusBarLength > 0) {
            tooltip.y += 20;
        }
        GL11.glScalef((float)OverlayConfig.scale, (float)OverlayConfig.scale, (float)1.0f);
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        EnumTooltipTheme theme = (EnumTooltipTheme)WailaConfig.theme.getEnumValue();
        Color4f tooltipBGColor = WailaConfig.bgcolor.getColor();
        Color4f tooltipFrameColorTop = WailaConfig.gradient1.getColor();
        Color4f tooltipFrameColorBottom = WailaConfig.gradient2.getColor();
        float configAlpha = (float)WailaConfig.alpha.getIntegerValue() / 100.0f;
        if (theme != EnumTooltipTheme.Custom) {
            tooltipBGColor = Color4f.fromColor((Color4f)theme.backgroundColor, (float)(currentAlpha * configAlpha));
            tooltipFrameColorTop = Color4f.fromColor((Color4f)theme.frameColorTop, (float)(currentAlpha * configAlpha));
            tooltipFrameColorBottom = Color4f.fromColor((Color4f)theme.frameColorBottom, (float)(currentAlpha * configAlpha));
        }
        OverlayRenderer.drawTooltipBox(tooltip.x, tooltip.y, tooltip.w, tooltip.h, tooltipBGColor.intValue, tooltipFrameColorTop.intValue, tooltipFrameColorBottom.intValue, theme.center, theme.frame, theme.gradient);
        OverlayRenderer.drawBreakProgress(tooltip.x, tooltip.y, tooltip.w, tooltip.h);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tooltip.draw();
        GL11.glDisable((int)3042);
        tooltip.draw2nd();
        if (tooltip.hasIcon) {
            RenderHelper.enableGUIStandardItemLighting();
        }
        GL11.glEnable((int)32826);
        if (tooltip.hasIcon && tooltip.stack != null && tooltip.stack.getItem() != null) {
            DisplayUtil.renderStack(tooltip.x + 5, tooltip.y + tooltip.h / 2 - 8, tooltip.stack);
        }
        OverlayRenderer.loadGLState();
        GL11.glPopMatrix();
    }

    public static void saveGLState() {
        hasBlending = GL11.glGetBoolean((int)3042);
        hasLight = GL11.glGetBoolean((int)2896);
        hasDepthTest = GL11.glGetBoolean((int)2929);
        boundTexIndex = GL11.glGetInteger((int)32873);
        GL11.glPushAttrib((int)1);
    }

    public static void loadGLState() {
        if (hasBlending) {
            GL11.glEnable((int)3042);
        } else {
            GL11.glDisable((int)3042);
        }
        if (hasLight1) {
            GL11.glEnable((int)16385);
        } else {
            GL11.glDisable((int)16385);
        }
        if (hasDepthTest) {
            GL11.glEnable((int)2929);
        } else {
            GL11.glDisable((int)2929);
        }
        GL11.glBindTexture((int)3553, (int)boundTexIndex);
        GL11.glPopAttrib();
    }

    public static void drawTooltipBox(int x, int y, int w, int h, int bg, int grad1, int grad2, boolean center, boolean frame, boolean gradient) {
        targetX = x;
        targetY = y;
        targetW = w;
        targetH = h;
        currentX = DisplayUtil.lerp(currentX, targetX, LERP_FACTOR);
        currentY = DisplayUtil.lerp(currentY, targetY, LERP_FACTOR);
        currentW = DisplayUtil.lerp(currentW, targetW, LERP_FACTOR);
        currentH = DisplayUtil.lerp(currentH, targetH, LERP_FACTOR);
        int drawX = (int)currentX;
        int drawY = (int)currentY;
        int drawW = (int)currentW;
        int drawH = (int)currentH;
        EnumTooltipTheme theme = (EnumTooltipTheme)WailaConfig.theme.getEnumValue();
        if (theme.center) {
            DisplayUtil.drawGradientRect(drawX + 1, drawY + 1, drawW - 1, drawH - 1, bg, bg);
        }
        if (theme.frame) {
            DisplayUtil.drawGradientRect(drawX + 1, drawY, drawW - 1, 1, bg, bg);
            DisplayUtil.drawGradientRect(drawX + 1, drawY + drawH, drawW - 1, 1, bg, bg);
            DisplayUtil.drawGradientRect(drawX, drawY + 1, 1, drawH - 1, bg, bg);
            DisplayUtil.drawGradientRect(drawX + drawW, drawY + 1, 1, drawH - 1, bg, bg);
        }
        if (theme.gradient) {
            DisplayUtil.drawGradientRect(drawX + 1, drawY + 2, 1, drawH - 3, grad1, grad2);
            DisplayUtil.drawGradientRect(drawX + drawW - 1, drawY + 2, 1, drawH - 3, grad1, grad2);
            DisplayUtil.drawGradientRect(drawX + 1, drawY + 1, drawW - 1, 1, grad1, grad1);
            DisplayUtil.drawGradientRect(drawX + 1, drawY + drawH - 1, drawW - 1, 1, grad2, grad2);
        }
        if (theme.coarseGradient) {
            DisplayUtil.drawGradientRect(drawX, drawY + 2, 3, drawH - 3, grad1, grad2);
            DisplayUtil.drawGradientRect(drawX + drawW - 3, drawY + 2, 3, drawH - 3, grad1, grad2);
            DisplayUtil.drawGradientRect(drawX, drawY, drawW, 3, grad1, grad1);
            DisplayUtil.drawGradientRect(drawX, drawY + drawH - 3, drawW, 3, grad2, grad2);
        }
    }

    public static void drawBreakProgress(int x, int y, int w, int h) {
        if (Minecraft.getMinecraft().playerController != null) {
            float breakProgress = ((IBreakingProgress)Minecraft.getMinecraft().playerController).getCurrentBreakingProgress();
            int currentProgressLine = 0;
            if (breakProgress > 0.0f) {
                int progress = (int)(breakProgress * 100.0f);
                lastProgressLine = currentProgressLine = (int)((double)progress / 100.0 * (double)w);
                lastBreakProgress = breakProgress;
            } else if (lastBreakProgress > 0.0f && (currentProgressLine = (lastProgressLine = (int)((float)lastProgressLine * 0.9f))) < 1) {
                currentProgressLine = 0;
                lastBreakProgress = 0.0f;
            }
            if (currentProgressLine > 0) {
                DisplayUtil.drawGradientRect(x + 1, y + h - 1, currentProgressLine, 1, -9144725, -9144725);
            }
        }
    }

    static {
        lastProgressLine = 0;
        targetX = 0;
        targetY = 0;
        targetW = 0;
        targetH = 0;
        currentX = 0.0f;
        currentY = 0.0f;
        currentW = 0.0f;
        currentH = 0.0f;
        LERP_FACTOR = (float)WailaConfig.lerpfactor.getDoubleValue();
        lastBreakProgress = 0.0f;
        currentAlpha = 0.0f;
    }
}

