/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import mcp.mobius.waila.api.IWailaCommonAccessor;
import mcp.mobius.waila.api.IWailaTooltipRenderer;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.EntityPlayer;
import net.minecraft.FontRenderer;
import net.minecraft.Gui;
import net.minecraft.ItemStack;
import net.minecraft.Minecraft;
import net.minecraft.RenderItem;
import net.minecraft.ScaledResolution;
import net.minecraft.Slot;
import net.minecraft.Tessellator;
import net.minecraft.TextureManager;
import org.lwjgl.opengl.GL11;

public class DisplayUtil {
    private static FontRenderer fontRenderer = Minecraft.getMinecraft().fontRenderer;
    private static TextureManager textureManager = Minecraft.getMinecraft().getTextureManager();
    private static RenderItem renderItem = new RenderItem();

    public static int getDisplayWidth(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        int width = 0;
        Matcher renderMatcher = SpecialChars.patternRender.matcher(s);
        while (renderMatcher.find()) {
            IWailaTooltipRenderer renderer = ModuleRegistrar.instance().getTooltipRenderer(renderMatcher.group("name"));
            if (renderer == null) continue;
            width += renderer.getSize((String[])renderMatcher.group((String)"args").split((String)","), (IWailaCommonAccessor)DataAccessorCommon.instance).width;
        }
        Matcher iconMatcher = SpecialChars.patternIcon.matcher(s);
        while (iconMatcher.find()) {
            width += 8;
        }
        return width += fontRenderer.getStringWidth(DisplayUtil.stripSymbols(s));
    }

    public static Dimension displaySize() {
        Minecraft mc = Minecraft.getMinecraft();
        ScaledResolution res = new ScaledResolution(mc.gameSettings, mc.displayWidth, mc.displayHeight);
        return new Dimension(res.getScaledWidth(), res.getScaledHeight());
    }

    public static String stripSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternMinecraft.matcher(result).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static String stripWailaSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static void renderStack(int x, int y, ItemStack stack) {
        DisplayUtil.enable3DRender();
        try {
            renderItem.renderItemAndEffectIntoGUI(fontRenderer, textureManager, stack, x, y);
            renderItem.renderItemOverlayIntoGUI(fontRenderer, textureManager, stack, x, y);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            WailaExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void enable3DRender() {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public static void enable2DRender() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public static void drawGradientRect(int x, int y, int w, int h, int grad1, int grad2) {
        float zLevel = 0.0f;
        float f = (float)(grad1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(grad1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(grad1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(grad1 & 0xFF) / 255.0f;
        float f4 = (float)(grad2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(grad2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(grad2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(grad2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(f1, f2, f3, f);
        tessellator.addVertex((double)(x + w), (double)y, (double)zLevel);
        tessellator.addVertex((double)x, (double)y, (double)zLevel);
        tessellator.setColorRGBA_F(f5, f6, f7, f4);
        tessellator.addVertex((double)x, (double)(y + h), (double)zLevel);
        tessellator.addVertex((double)(x + w), (double)(y + h), (double)zLevel);
        tessellator.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int w, int h, int tw, int th) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        tessellator.addVertexWithUV((double)x, (double)(y + h), (double)zLevel, (double)((float)u * f), (double)((float)(v + th) * f1));
        tessellator.addVertexWithUV((double)(x + w), (double)(y + h), (double)zLevel, (double)((float)(u + tw) * f), (double)((float)(v + th) * f1));
        tessellator.addVertexWithUV((double)(x + w), (double)y, (double)zLevel, (double)((float)(u + tw) * f), (double)((float)v * f1));
        tessellator.addVertexWithUV((double)x, (double)y, (double)zLevel, (double)((float)u * f), (double)((float)v * f1));
        tessellator.draw();
    }

    public static void drawString(String text, int x, int y, int colour, boolean shadow) {
        if (shadow) {
            fontRenderer.drawStringWithShadow(text, x, y, colour);
        } else {
            fontRenderer.drawString(text, x, y, colour);
        }
    }

    public static List<String> itemDisplayNameMultiline(ItemStack itemstack) {
        List<String> namelist = null;
        try {
            namelist = itemstack.getTooltip((EntityPlayer)Minecraft.getMinecraft().thePlayer, Minecraft.getMinecraft().gameSettings.advancedItemTooltips, (Slot)null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.isEmpty()) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).isEmpty()) {
            namelist.set(0, "Unnamed");
        }
        namelist.set(0, SpecialChars.MCStyle + Integer.toHexString(itemstack.getRarity().rarityColor) + (String)namelist.get(0));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, SpecialChars.GRAY + namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ItemStack itemstack) {
        List<String> list = DisplayUtil.itemDisplayNameMultiline(itemstack);
        return list.get(0);
    }

    public static void renderIcon(int x, int y, int sx, int sy, IconUI icon) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(Gui.icons);
        if (icon == null) {
            return;
        }
        if (icon.bu != -1) {
            DisplayUtil.drawTexturedModalRect(x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayUtil.drawTexturedModalRect(x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }

    public static float lerp(float start, float end, float factor) {
        return start + (end - start) * factor;
    }
}

