/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.Packet;
import net.minecraft.Packet250CustomPayload;
import net.minecraft.RaycastCollision;
import net.minecraft.World;

public class Packet0x01TERequest {
    public byte header;
    public int worldID;
    public int posX;
    public int posY;
    public int posZ;
    public HashSet<String> keys = new HashSet();

    public Packet0x01TERequest(Packet250CustomPayload packet) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.data));
        this.keys.clear();
        try {
            this.header = inputStream.readByte();
            this.worldID = inputStream.readInt();
            this.posX = inputStream.readInt();
            this.posY = inputStream.readInt();
            this.posZ = inputStream.readInt();
            int nkeys = inputStream.readInt();
            for (int i = 0; i < nkeys; ++i) {
                this.keys.add(Packet.readString((DataInput)inputStream, (int)250));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Packet250CustomPayload create(World world, RaycastCollision mop, HashSet<String> keys) {
        Packet250CustomPayload packet = new Packet250CustomPayload();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(17);
        DataOutputStream outputStream = new DataOutputStream(bos);
        keys.add("x");
        keys.add("y");
        keys.add("z");
        try {
            outputStream.writeByte(1);
            outputStream.writeInt(world.provider.dimensionId);
            outputStream.writeInt(mop.block_hit_x);
            outputStream.writeInt(mop.block_hit_y);
            outputStream.writeInt(mop.block_hit_z);
            outputStream.writeInt(keys.size());
            for (String key : keys) {
                Packet.writeString((String)key, (DataOutput)outputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        packet.channel = "Waila";
        packet.data = bos.toByteArray();
        packet.length = bos.size();
        return packet;
    }
}

