/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.handlers;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaFMPProvider;
import mcp.mobius.waila.api.impl.DataAccessorFMP;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import net.minecraft.ItemStack;
import net.minecraft.NBTTagCompound;
import net.minecraft.NBTTagList;
import net.minecraft.ServerPlayer;
import net.minecraft.TileEntity;
import net.minecraft.World;
import org.apache.logging.log4j.Level;

public class HUDHandlerFMP
implements IWailaDataProvider {
    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagList list = accessor.getNBTData().getTagList("parts");
        for (int i = 0; i < list.tagCount(); ++i) {
            NBTTagCompound subtag = (NBTTagCompound)list.tagAt(i);
            String id = subtag.getString("id");
            if (!ModuleRegistrar.instance().hasHeadFMPProviders(id)) continue;
            DataAccessorFMP.instance.set(accessor.getWorld(), accessor.getPlayer(), accessor.getPosition(), subtag, id);
            for (List<IWailaFMPProvider> providersList : ModuleRegistrar.instance().getHeadFMPProviders(id).values()) {
                for (IWailaFMPProvider provider : providersList) {
                    currenttip = provider.getWailaHead(itemStack, currenttip, DataAccessorFMP.instance, config);
                }
            }
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagList list = accessor.getNBTData().getTagList("parts");
        for (int i = 0; i < list.tagCount(); ++i) {
            NBTTagCompound subtag = (NBTTagCompound)list.tagAt(i);
            String id = subtag.getString("id");
            if (!ModuleRegistrar.instance().hasBodyFMPProviders(id)) continue;
            DataAccessorFMP.instance.set(accessor.getWorld(), accessor.getPlayer(), accessor.getPosition(), subtag, id);
            for (List<IWailaFMPProvider> providersList : ModuleRegistrar.instance().getBodyFMPProviders(id).values()) {
                for (IWailaFMPProvider provider : providersList) {
                    currenttip = provider.getWailaBody(itemStack, currenttip, DataAccessorFMP.instance, config);
                }
            }
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagList list = accessor.getNBTData().getTagList("parts");
        for (int i = 0; i < list.tagCount(); ++i) {
            NBTTagCompound subtag = (NBTTagCompound)list.tagAt(i);
            String id = subtag.getString("id");
            if (!ModuleRegistrar.instance().hasTailFMPProviders(id)) continue;
            DataAccessorFMP.instance.set(accessor.getWorld(), accessor.getPlayer(), accessor.getPosition(), subtag, id);
            for (List<IWailaFMPProvider> providersList : ModuleRegistrar.instance().getTailFMPProviders(id).values()) {
                for (IWailaFMPProvider provider : providersList) {
                    currenttip = provider.getWailaTail(itemStack, currenttip, DataAccessorFMP.instance, config);
                }
            }
        }
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(ServerPlayer player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.writeToNBT(tag);
        }
        return tag;
    }

    public static void register() {
        Class<?> BlockMultipart;
        try {
            BlockMultipart = Class.forName("codechicken.multipart.BlockMultipart");
        }
        catch (ClassNotFoundException e) {
            Waila.log.log(Level.WARN, "[FMP] Class not found. " + String.valueOf(e));
            return;
        }
        catch (Exception e) {
            Waila.log.log(Level.WARN, "[FMP] Unhandled exception." + String.valueOf(e));
            return;
        }
        ModuleRegistrar.instance().registerHeadProvider(new HUDHandlerFMP(), BlockMultipart);
        ModuleRegistrar.instance().registerBodyProvider(new HUDHandlerFMP(), BlockMultipart);
        ModuleRegistrar.instance().registerTailProvider(new HUDHandlerFMP(), BlockMultipart);
        ModuleRegistrar.instance().registerNBTProvider(new HUDHandlerFMP(), BlockMultipart);
        Waila.log.log(Level.INFO, "Forge Multipart found and dedicated handler registered");
    }
}

