/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.handlers;

import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.cbcore.LangUtil;
import mcp.mobius.waila.utils.ModIdentification;
import moddedmite.waila.config.WailaConfig;
import net.minecraft.DamageSource;
import net.minecraft.Entity;
import net.minecraft.EntityLivingBase;
import net.minecraft.NBTTagCompound;
import net.minecraft.ServerPlayer;
import net.minecraft.SharedMonsterAttributes;
import net.minecraft.World;

public class HUDHandlerEntities
implements IWailaEntityProvider {
    public static int nhearts = 20;
    public static float maxhpfortext = 40.0f;
    public static int nArmorIconsPerLine = 20;
    public static float maxArmorForText = 20.0f;

    @Override
    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        try {
            currenttip.add(SpecialChars.WHITE + entity.getEntityName());
        }
        catch (Exception e) {
            currenttip.add(SpecialChars.WHITE + "Unknown");
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        this.getEntityHeath(entity, currenttip, accessor, config);
        this.getEntityArmor(entity, currenttip, accessor, config);
        this.getEntityAttack(entity, currenttip, accessor, config);
        return currenttip;
    }

    public void getEntityHeath(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (!WailaConfig.showhp.getBooleanValue()) {
            return;
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
            nhearts = nhearts <= 0 ? 20 : nhearts;
            float health = entityLivingBase.getHealth() / 2.0f;
            float maxhp = entityLivingBase.getMaxHealth() / 2.0f;
            if (entityLivingBase.getMaxHealth() > maxhpfortext) {
                currenttip.add(String.format(LangUtil.translateG("hud.msg.health", new Object[0]) + SpecialChars.WHITE + "%.0f" + SpecialChars.GRAY + " / " + SpecialChars.WHITE + "%.0f", Float.valueOf(((EntityLivingBase)entity).getHealth()), Float.valueOf(((EntityLivingBase)entity).getMaxHealth())));
            } else {
                currenttip.add(SpecialChars.getRenderString("waila.health", String.valueOf(nhearts), String.valueOf(health), String.valueOf(maxhp)));
            }
        }
    }

    public void getEntityArmor(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (!WailaConfig.showarmor.getBooleanValue()) {
            return;
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
            float armor = entityLivingBase.getTotalProtection(DamageSource.causeMobDamage((EntityLivingBase)null));
            if (armor > maxArmorForText) {
                currenttip.add(String.format(LangUtil.translateG("hud.msg.armor", new Object[0]) + SpecialChars.WHITE + "%.0f", Float.valueOf(armor)));
            } else {
                currenttip.add(SpecialChars.getRenderString("waila.armor", String.valueOf(nArmorIconsPerLine), String.valueOf(armor), String.valueOf(armor)));
            }
        }
    }

    public void getEntityAttack(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (!WailaConfig.showatk.getBooleanValue()) {
            return;
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
            float total_melee_damage = 0.0f;
            DecimalFormat damageFormat = new DecimalFormat("0.00");
            if (entityLivingBase.isEntityPlayer()) {
                total_melee_damage = Float.parseFloat(damageFormat.format(entityLivingBase.getAsPlayer().calcRawMeleeDamageVs((Entity)entityLivingBase, false, false)));
            } else if (entityLivingBase.hasEntityAttribute(SharedMonsterAttributes.attackDamage)) {
                total_melee_damage = Float.parseFloat(damageFormat.format((float)entityLivingBase.getEntityAttributeValue(SharedMonsterAttributes.attackDamage)));
            }
            if (total_melee_damage != 0.0f) {
                currenttip.add(LangUtil.translateG("hud.msg.attack", Float.valueOf(total_melee_damage)));
            }
        }
    }

    @Override
    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (!WailaConfig.showMods.getBooleanValue()) {
            return currenttip;
        }
        try {
            currenttip.add(SpecialChars.BLUE + SpecialChars.ITALIC + ModIdentification.getEntityMod(entity));
        }
        catch (Exception e) {
            currenttip.add(SpecialChars.BLUE + SpecialChars.ITALIC + "Unknown");
        }
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(ServerPlayer player, Entity te, NBTTagCompound tag, World world) {
        return tag;
    }
}

