/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaBlockDecorator;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaFMPDecorator;
import mcp.mobius.waila.api.IWailaFMPProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.IWailaSummaryProvider;
import mcp.mobius.waila.api.IWailaTooltipRenderer;

public class ModuleRegistrar
implements IWailaRegistrar {
    private static ModuleRegistrar instance = null;
    public LinkedHashMap<Class, ArrayList<IWailaDataProvider>> headBlockProviders = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaDataProvider>> bodyBlockProviders = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaDataProvider>> tailBlockProviders = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaDataProvider>> stackBlockProviders = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaDataProvider>> NBTDataProviders = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaBlockDecorator>> blockClassDecorators = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaEntityProvider>> headEntityProviders = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaEntityProvider>> bodyEntityProviders = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaEntityProvider>> tailEntityProviders = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaEntityProvider>> overrideEntityProviders = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaEntityProvider>> NBTEntityProviders = new LinkedHashMap();
    public LinkedHashMap<String, ArrayList<IWailaFMPProvider>> headFMPProviders = new LinkedHashMap();
    public LinkedHashMap<String, ArrayList<IWailaFMPProvider>> bodyFMPProviders = new LinkedHashMap();
    public LinkedHashMap<String, ArrayList<IWailaFMPProvider>> tailFMPProviders = new LinkedHashMap();
    public LinkedHashMap<String, ArrayList<IWailaFMPDecorator>> FMPClassDecorators = new LinkedHashMap();
    public LinkedHashMap<Class, HashSet<String>> syncedNBTKeys = new LinkedHashMap();
    public LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, String>>> wikiDescriptions = new LinkedHashMap();
    public LinkedHashMap<Class, ArrayList<IWailaSummaryProvider>> summaryProviders = new LinkedHashMap();
    public LinkedHashMap<String, String> IMCRequests = new LinkedHashMap();
    public LinkedHashMap<String, IWailaTooltipRenderer> tooltipRenderers = new LinkedHashMap();

    private ModuleRegistrar() {
        instance = this;
    }

    public static ModuleRegistrar instance() {
        if (instance == null) {
            instance = new ModuleRegistrar();
        }
        return instance;
    }

    public void addIMCRequest(String method, String modname) {
        this.IMCRequests.put(method, modname);
    }

    @Override
    public void registerHeadProvider(IWailaDataProvider dataProvider, Class block) {
        this.registerProvider(dataProvider, block, this.headBlockProviders);
    }

    @Override
    public void registerBodyProvider(IWailaDataProvider dataProvider, Class block) {
        this.registerProvider(dataProvider, block, this.bodyBlockProviders);
    }

    @Override
    public void registerTailProvider(IWailaDataProvider dataProvider, Class block) {
        this.registerProvider(dataProvider, block, this.tailBlockProviders);
    }

    @Override
    public void registerStackProvider(IWailaDataProvider dataProvider, Class block) {
        this.registerProvider(dataProvider, block, this.stackBlockProviders);
    }

    @Override
    public void registerNBTProvider(IWailaDataProvider dataProvider, Class entity) {
        this.registerProvider(dataProvider, entity, this.NBTDataProviders);
    }

    @Override
    public void registerHeadProvider(IWailaEntityProvider dataProvider, Class entity) {
        this.registerProvider(dataProvider, entity, this.headEntityProviders);
    }

    @Override
    public void registerBodyProvider(IWailaEntityProvider dataProvider, Class entity) {
        this.registerProvider(dataProvider, entity, this.bodyEntityProviders);
    }

    @Override
    public void registerTailProvider(IWailaEntityProvider dataProvider, Class entity) {
        this.registerProvider(dataProvider, entity, this.tailEntityProviders);
    }

    @Override
    public void registerNBTProvider(IWailaEntityProvider dataProvider, Class entity) {
        this.registerProvider(dataProvider, entity, this.NBTEntityProviders);
    }

    @Override
    public void registerHeadProvider(IWailaFMPProvider dataProvider, String name) {
        this.registerProvider(dataProvider, name, this.headFMPProviders);
    }

    @Override
    public void registerBodyProvider(IWailaFMPProvider dataProvider, String name) {
        this.registerProvider(dataProvider, name, this.bodyFMPProviders);
    }

    @Override
    public void registerTailProvider(IWailaFMPProvider dataProvider, String name) {
        this.registerProvider(dataProvider, name, this.tailFMPProviders);
    }

    @Override
    public void registerOverrideEntityProvider(IWailaEntityProvider dataProvider, Class entity) {
        this.registerProvider(dataProvider, entity, this.overrideEntityProviders);
    }

    @Override
    public void registerDecorator(IWailaBlockDecorator decorator, Class block) {
        this.registerProvider(decorator, block, this.blockClassDecorators);
    }

    @Override
    public void registerDecorator(IWailaFMPDecorator decorator, String name) {
        this.registerProvider(decorator, name, this.FMPClassDecorators);
    }

    private <T, V> void registerProvider(T dataProvider, V clazz, LinkedHashMap<V, ArrayList<T>> target) {
        ArrayList<T> providers;
        if (clazz == null || dataProvider == null) {
            throw new RuntimeException(String.format("Trying to register a null provider or null block ! Please check the stacktrace to know what was the original registration method. [Provider : %s, Target : %s]", dataProvider.getClass().getName(), clazz));
        }
        if (!target.containsKey(clazz)) {
            target.put(clazz, (ArrayList<T>)new ArrayList());
        }
        if ((providers = target.get(clazz)).contains(dataProvider)) {
            return;
        }
        target.get(clazz).add(dataProvider);
    }

    @Override
    @Deprecated
    public void registerSyncedNBTKey(String key, Class target) {
        if (!this.syncedNBTKeys.containsKey(target)) {
            this.syncedNBTKeys.put(target, new HashSet());
        }
        this.syncedNBTKeys.get(target).add(key);
    }

    @Override
    public void registerTooltipRenderer(String name, IWailaTooltipRenderer renderer) {
        if (!this.tooltipRenderers.containsKey(name)) {
            this.tooltipRenderers.put(name, renderer);
        } else {
            Waila.log.warn(String.format("A renderer named %s already exists (Class : %s). Skipping new renderer.", name, renderer.getClass().getName()));
        }
    }

    public Map<Integer, List<IWailaDataProvider>> getHeadProviders(Object block) {
        return this.getProviders(block, this.headBlockProviders);
    }

    public Map<Integer, List<IWailaDataProvider>> getBodyProviders(Object block) {
        return this.getProviders(block, this.bodyBlockProviders);
    }

    public Map<Integer, List<IWailaDataProvider>> getTailProviders(Object block) {
        return this.getProviders(block, this.tailBlockProviders);
    }

    public Map<Integer, List<IWailaDataProvider>> getStackProviders(Object block) {
        return this.getProviders(block, this.stackBlockProviders);
    }

    public Map<Integer, List<IWailaDataProvider>> getNBTProviders(Object block) {
        return this.getProviders(block, this.NBTDataProviders);
    }

    public Map<Integer, List<IWailaEntityProvider>> getHeadEntityProviders(Object entity) {
        return this.getProviders(entity, this.headEntityProviders);
    }

    public Map<Integer, List<IWailaEntityProvider>> getBodyEntityProviders(Object entity) {
        return this.getProviders(entity, this.bodyEntityProviders);
    }

    public Map<Integer, List<IWailaEntityProvider>> getTailEntityProviders(Object entity) {
        return this.getProviders(entity, this.tailEntityProviders);
    }

    public Map<Integer, List<IWailaEntityProvider>> getOverrideEntityProviders(Object entity) {
        return this.getProviders(entity, this.overrideEntityProviders);
    }

    public Map<Integer, List<IWailaEntityProvider>> getNBTEntityProviders(Object entity) {
        return this.getProviders(entity, this.NBTEntityProviders);
    }

    public Map<Integer, List<IWailaFMPProvider>> getHeadFMPProviders(String name) {
        return this.getProviders(name, this.headFMPProviders);
    }

    public Map<Integer, List<IWailaFMPProvider>> getBodyFMPProviders(String name) {
        return this.getProviders(name, this.bodyFMPProviders);
    }

    public Map<Integer, List<IWailaFMPProvider>> getTailFMPProviders(String name) {
        return this.getProviders(name, this.tailFMPProviders);
    }

    public Map<Integer, List<IWailaSummaryProvider>> getSummaryProvider(Object item) {
        return this.getProviders(item, this.summaryProviders);
    }

    public Map<Integer, List<IWailaBlockDecorator>> getBlockDecorators(Object block) {
        return this.getProviders(block, this.blockClassDecorators);
    }

    public Map<Integer, List<IWailaFMPDecorator>> getFMPDecorators(String name) {
        return this.getProviders(name, this.FMPClassDecorators);
    }

    public IWailaTooltipRenderer getTooltipRenderer(String name) {
        return this.tooltipRenderers.get(name);
    }

    private <T> Map<Integer, List<T>> getProviders(Object obj, LinkedHashMap<Class, ArrayList<T>> target) {
        TreeMap<Integer, List<T>> returnList = new TreeMap<Integer, List<T>>();
        Integer index = 0;
        for (Class clazz : target.keySet()) {
            if (clazz.isInstance(obj)) {
                returnList.put(index, (List)target.get(clazz));
            }
            Integer n = index;
            index = index + 1;
        }
        return returnList;
    }

    private <T> Map<Integer, List<T>> getProviders(String name, LinkedHashMap<String, ArrayList<T>> target) {
        TreeMap<Integer, List<T>> returnList = new TreeMap<Integer, List<T>>();
        returnList.put(0, (List)target.get(name));
        return returnList;
    }

    @Deprecated
    public HashSet<String> getSyncedNBTKeys(Object target) {
        HashSet<String> returnList = new HashSet<String>();
        for (Class clazz : this.syncedNBTKeys.keySet()) {
            if (!clazz.isInstance(target)) continue;
            returnList.addAll((Collection<String>)this.syncedNBTKeys.get(clazz));
        }
        return returnList;
    }

    public boolean hasStackProviders(Object block) {
        return this.hasProviders(block, this.stackBlockProviders);
    }

    public boolean hasHeadProviders(Object block) {
        return this.hasProviders(block, this.headBlockProviders);
    }

    public boolean hasBodyProviders(Object block) {
        return this.hasProviders(block, this.bodyBlockProviders);
    }

    public boolean hasTailProviders(Object block) {
        return this.hasProviders(block, this.tailBlockProviders);
    }

    public boolean hasNBTProviders(Object block) {
        return this.hasProviders(block, this.NBTDataProviders);
    }

    public boolean hasHeadEntityProviders(Object entity) {
        return this.hasProviders(entity, this.headEntityProviders);
    }

    public boolean hasBodyEntityProviders(Object entity) {
        return this.hasProviders(entity, this.bodyEntityProviders);
    }

    public boolean hasTailEntityProviders(Object entity) {
        return this.hasProviders(entity, this.tailEntityProviders);
    }

    public boolean hasOverrideEntityProviders(Object entity) {
        return this.hasProviders(entity, this.overrideEntityProviders);
    }

    public boolean hasNBTEntityProviders(Object entity) {
        return this.hasProviders(entity, this.NBTEntityProviders);
    }

    public boolean hasHeadFMPProviders(String name) {
        return this.hasProviders(name, this.headFMPProviders);
    }

    public boolean hasBodyFMPProviders(String name) {
        return this.hasProviders(name, this.bodyFMPProviders);
    }

    public boolean hasTailFMPProviders(String name) {
        return this.hasProviders(name, this.tailFMPProviders);
    }

    public boolean hasBlockDecorator(Object block) {
        return this.hasProviders(block, this.blockClassDecorators);
    }

    public boolean hasFMPDecorator(String name) {
        return this.hasProviders(name, this.FMPClassDecorators);
    }

    private <T> boolean hasProviders(Object obj, LinkedHashMap<Class, ArrayList<T>> target) {
        for (Class clazz : target.keySet()) {
            if (!clazz.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    private <T> boolean hasProviders(String name, LinkedHashMap<String, ArrayList<T>> target) {
        return target.containsKey(name);
    }

    public boolean hasSummaryProvider(Class item) {
        return this.summaryProviders.containsKey(item);
    }

    @Deprecated
    public boolean hasSyncedNBTKeys(Object target) {
        for (Class clazz : this.syncedNBTKeys.keySet()) {
            if (!clazz.isInstance(target)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDocTextModID(String modid) {
        return this.wikiDescriptions.containsKey(modid);
    }

    public boolean hasDocTextItem(String modid, String item) {
        if (this.hasDocTextModID(modid)) {
            return this.wikiDescriptions.get(modid).containsKey(item);
        }
        return false;
    }

    public boolean hasDocTextMeta(String modid, String item, String meta) {
        if (this.hasDocTextItem(modid, item)) {
            return this.wikiDescriptions.get(modid).get(item).containsKey(meta);
        }
        return false;
    }

    public LinkedHashMap<String, String> getDocText(String modid, String name) {
        return this.wikiDescriptions.get(modid).get(name);
    }

    public String getDocText(String modid, String name, String meta) {
        return this.wikiDescriptions.get(modid).get(name).get(meta);
    }

    public boolean hasDocTextSpecificMeta(String modid, String name, String meta) {
        for (String s : this.getDocText(modid, name).keySet()) {
            if (!s.equals(meta)) continue;
            return true;
        }
        return false;
    }

    public String getDoxTextWildcardMatch(String modid, String name) {
        Set<String> keys = this.wikiDescriptions.get(modid).keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String s;
            String regexed = s = iterator.next();
            regexed = regexed.replace(".", "\\.");
            regexed = regexed.replace("*", ".*");
            if (!name.matches(s)) continue;
            return s;
        }
        return null;
    }

    private List<String[]> readFileAsString(String filePath) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(filePath);
        BufferedReader input = new BufferedReader(new InputStreamReader(in));
        CSVReader reader = new CSVReader(input);
        List<String[]> myEntries = reader.readAll();
        reader.close();
        return myEntries;
    }
}

