/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaBlock;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.cbcore.Layout;
import mcp.mobius.waila.network.Packet0x01TERequest;
import mcp.mobius.waila.network.Packet0x03EntRequest;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import moddedmite.waila.api.PacketDispatcher;
import moddedmite.waila.config.WailaConfig;
import net.minecraft.Block;
import net.minecraft.Entity;
import net.minecraft.EntityPlayer;
import net.minecraft.ItemStack;
import net.minecraft.NBTTagCompound;
import net.minecraft.Packet;
import net.minecraft.RaycastCollision;
import net.minecraft.World;

public class MetaDataProvider {
    private final Map<Integer, List<IWailaDataProvider>> headBlockProviders = new TreeMap<Integer, List<IWailaDataProvider>>();
    private final Map<Integer, List<IWailaDataProvider>> bodyBlockProviders = new TreeMap<Integer, List<IWailaDataProvider>>();
    private Map<Integer, List<IWailaDataProvider>> tailBlockProviders = new TreeMap<Integer, List<IWailaDataProvider>>();
    private final Map<Integer, List<IWailaEntityProvider>> headEntityProviders = new TreeMap<Integer, List<IWailaEntityProvider>>();
    private final Map<Integer, List<IWailaEntityProvider>> bodyEntityProviders = new TreeMap<Integer, List<IWailaEntityProvider>>();
    private final Map<Integer, List<IWailaEntityProvider>> tailEntityProviders = new TreeMap<Integer, List<IWailaEntityProvider>>();

    public ItemStack identifyBlockHighlight(World world, EntityPlayer player, RaycastCollision mop, DataAccessorCommon accessor) {
        Block block = accessor.getBlock();
        if (block instanceof IWailaBlock) {
            try {
                return ((IWailaBlock)block).getWailaStack(accessor, WailaConfig.getInstance());
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, block.getClass().toString(), null);
            }
        }
        if (ModuleRegistrar.instance().hasStackProviders(block)) {
            for (List<IWailaDataProvider> providerList : ModuleRegistrar.instance().getStackProviders(block).values()) {
                for (IWailaDataProvider dataProvider : providerList) {
                    try {
                        ItemStack retval = dataProvider.getWailaStack(accessor, WailaConfig.getInstance());
                        if (retval == null) continue;
                        return retval;
                    }
                    catch (Throwable e) {
                        WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), null);
                    }
                }
            }
        }
        return null;
    }

    public List<String> handleBlockTextData(ItemStack itemStack, World world, EntityPlayer player, RaycastCollision mop, DataAccessorCommon accessor, List<String> currenttip, Layout layout) {
        Block block = accessor.getBlock();
        if (accessor.getTileEntity() != null && Waila.instance.serverPresent && accessor.isTimeElapsed(250L) && WailaConfig.showTooltip.getBooleanValue()) {
            accessor.resetTimer();
            HashSet<String> keys = new HashSet<String>();
            if (ModuleRegistrar.instance().hasSyncedNBTKeys(block)) {
                keys.addAll(ModuleRegistrar.instance().getSyncedNBTKeys(block));
            }
            if (ModuleRegistrar.instance().hasSyncedNBTKeys(accessor.getTileEntity())) {
                keys.addAll(ModuleRegistrar.instance().getSyncedNBTKeys(accessor.getTileEntity()));
            }
            if (!keys.isEmpty() || ModuleRegistrar.instance().hasNBTProviders(block) || ModuleRegistrar.instance().hasNBTProviders(accessor.getTileEntity())) {
                PacketDispatcher.sendPacketToServer((Packet)Packet0x01TERequest.create(world, mop, keys));
            }
        } else if (accessor.getTileEntity() != null && !Waila.instance.serverPresent && accessor.isTimeElapsed(250L) && WailaConfig.showTooltip.getBooleanValue()) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                accessor.getTileEntity().writeToNBT(tag);
                accessor.setNBTData(tag);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, this.getClass().getName(), null);
            }
        }
        if (block instanceof IWailaBlock) {
            if (layout == Layout.HEADER) {
                try {
                    return ((IWailaBlock)block).getWailaHead(itemStack, currenttip, accessor, WailaConfig.getInstance());
                }
                catch (Throwable e) {
                    return WailaExceptionHandler.handleErr(e, block.getClass().toString(), currenttip);
                }
            }
            if (layout == Layout.BODY) {
                try {
                    return ((IWailaBlock)block).getWailaBody(itemStack, currenttip, accessor, WailaConfig.getInstance());
                }
                catch (Throwable e) {
                    return WailaExceptionHandler.handleErr(e, block.getClass().toString(), currenttip);
                }
            }
            if (layout == Layout.FOOTER) {
                try {
                    return ((IWailaBlock)block).getWailaTail(itemStack, currenttip, accessor, WailaConfig.getInstance());
                }
                catch (Throwable e) {
                    return WailaExceptionHandler.handleErr(e, block.getClass().toString(), currenttip);
                }
            }
        }
        this.headBlockProviders.clear();
        this.bodyBlockProviders.clear();
        this.tailBlockProviders.clear();
        if (layout == Layout.HEADER && ModuleRegistrar.instance().hasHeadProviders(block)) {
            this.headBlockProviders.putAll(ModuleRegistrar.instance().getHeadProviders(block));
        } else if (layout == Layout.BODY && ModuleRegistrar.instance().hasBodyProviders(block)) {
            this.bodyBlockProviders.putAll(ModuleRegistrar.instance().getBodyProviders(block));
        } else if (layout == Layout.FOOTER && ModuleRegistrar.instance().hasTailProviders(block)) {
            this.tailBlockProviders.putAll(ModuleRegistrar.instance().getTailProviders(block));
        }
        if (layout == Layout.HEADER && ModuleRegistrar.instance().hasHeadProviders(accessor.getTileEntity())) {
            this.headBlockProviders.putAll(ModuleRegistrar.instance().getHeadProviders(accessor.getTileEntity()));
        } else if (layout == Layout.BODY && ModuleRegistrar.instance().hasBodyProviders(accessor.getTileEntity())) {
            this.bodyBlockProviders.putAll(ModuleRegistrar.instance().getBodyProviders(accessor.getTileEntity()));
        } else if (layout == Layout.FOOTER && ModuleRegistrar.instance().hasTailProviders(accessor.getTileEntity())) {
            this.tailBlockProviders.putAll(ModuleRegistrar.instance().getTailProviders(accessor.getTileEntity()));
        }
        if (layout == Layout.HEADER) {
            for (List<IWailaDataProvider> providersList : this.headBlockProviders.values()) {
                for (IWailaDataProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaHead(itemStack, currenttip, accessor, WailaConfig.getInstance());
                    }
                    catch (Throwable e) {
                        currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        if (layout == Layout.BODY) {
            for (List<IWailaDataProvider> providersList : this.bodyBlockProviders.values()) {
                for (IWailaDataProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaBody(itemStack, currenttip, accessor, WailaConfig.getInstance());
                    }
                    catch (Throwable e) {
                        currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        if (layout == Layout.FOOTER) {
            for (List<IWailaDataProvider> providersList : this.tailBlockProviders.values()) {
                for (IWailaDataProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaTail(itemStack, currenttip, accessor, WailaConfig.getInstance());
                    }
                    catch (Throwable e) {
                        currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        return currenttip;
    }

    public List<String> handleEntityTextData(Entity entity, World world, EntityPlayer player, RaycastCollision mop, DataAccessorCommon accessor, List<String> currenttip, Layout layout) {
        if (accessor.getEntity() != null && Waila.instance.serverPresent && accessor.isTimeElapsed(250L)) {
            accessor.resetTimer();
            HashSet<String> keys = new HashSet<String>();
            if (ModuleRegistrar.instance().hasSyncedNBTKeys(accessor.getEntity())) {
                keys.addAll(ModuleRegistrar.instance().getSyncedNBTKeys(accessor.getEntity()));
            }
            if (!keys.isEmpty() || ModuleRegistrar.instance().hasNBTEntityProviders(accessor.getEntity())) {
                PacketDispatcher.sendPacketToServer((Packet)Packet0x03EntRequest.create(world, (Entity)player, keys));
            }
        } else if (accessor.getEntity() != null && !Waila.instance.serverPresent && accessor.isTimeElapsed(250L)) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                accessor.getEntity().writeToNBT(tag);
                accessor.remoteNbt = tag;
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, this.getClass().getName(), null);
            }
        }
        this.headEntityProviders.clear();
        this.bodyEntityProviders.clear();
        this.tailEntityProviders.clear();
        if (layout == Layout.HEADER && ModuleRegistrar.instance().hasHeadEntityProviders(entity)) {
            this.headEntityProviders.putAll(ModuleRegistrar.instance().getHeadEntityProviders(entity));
        } else if (layout == Layout.BODY && ModuleRegistrar.instance().hasBodyEntityProviders(entity)) {
            this.bodyEntityProviders.putAll(ModuleRegistrar.instance().getBodyEntityProviders(entity));
        } else if (layout == Layout.FOOTER && ModuleRegistrar.instance().hasTailEntityProviders(entity)) {
            this.tailEntityProviders.putAll(ModuleRegistrar.instance().getTailEntityProviders(entity));
        }
        if (layout == Layout.HEADER) {
            for (List<IWailaEntityProvider> providersList : this.headEntityProviders.values()) {
                for (IWailaEntityProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaHead(entity, currenttip, accessor, WailaConfig.getInstance());
                    }
                    catch (Throwable e) {
                        currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        if (layout == Layout.BODY) {
            for (List<IWailaEntityProvider> providersList : this.bodyEntityProviders.values()) {
                for (IWailaEntityProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaBody(entity, currenttip, accessor, WailaConfig.getInstance());
                    }
                    catch (Throwable e) {
                        currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        if (layout == Layout.FOOTER) {
            for (List<IWailaEntityProvider> providersList : this.tailEntityProviders.values()) {
                for (IWailaEntityProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaTail(entity, currenttip, accessor, WailaConfig.getInstance());
                    }
                    catch (Throwable e) {
                        currenttip = WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        return currenttip;
    }
}

