/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv.bean;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsvToBean<T> {
    private Map<Class<?>, PropertyEditor> editorMap = null;

    public List<T> parse(MappingStrategy<T> mappingStrategy, Reader reader) {
        return this.parse(mappingStrategy, new CSVReader(reader));
    }

    public List<T> parse(MappingStrategy<T> mappingStrategy, CSVReader cSVReader) {
        try {
            mappingStrategy.captureHeader(cSVReader);
            ArrayList<T> arrayList = new ArrayList<T>();
            while (true) {
                String[] readNext;
                if (null == (readNext = cSVReader.readNext())) {
                    return arrayList;
                }
                arrayList.add(this.processLine(mappingStrategy, readNext));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing CSV!", e);
        }
    }

    protected T processLine(MappingStrategy<T> mappingStrategy, String[] strArr) throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException {
        T createBean = mappingStrategy.createBean();
        for (int i = 0; i < strArr.length; ++i) {
            PropertyDescriptor findDescriptor = mappingStrategy.findDescriptor(i);
            if (null == findDescriptor) continue;
            findDescriptor.getWriteMethod().invoke(createBean, this.convertValue(this.checkForTrim(strArr[i], findDescriptor), findDescriptor));
        }
        return createBean;
    }

    private String checkForTrim(String str, PropertyDescriptor propertyDescriptor) {
        return this.trimmableProperty(propertyDescriptor) ? str.trim() : str;
    }

    private boolean trimmableProperty(PropertyDescriptor propertyDescriptor) {
        return !propertyDescriptor.getPropertyType().getName().contains("String");
    }

    protected Object convertValue(String str, PropertyDescriptor propertyDescriptor) throws InstantiationException, IllegalAccessException {
        PropertyEditor propertyEditor = this.getPropertyEditor(propertyDescriptor);
        Object obj = str;
        if (null != propertyEditor) {
            propertyEditor.setAsText(str);
            obj = propertyEditor.getValue();
        }
        return obj;
    }

    private PropertyEditor getPropertyEditorValue(Class<?> cls) {
        PropertyEditor propertyEditor;
        if (this.editorMap == null) {
            this.editorMap = new HashMap();
        }
        if ((propertyEditor = this.editorMap.get(cls)) == null) {
            propertyEditor = PropertyEditorManager.findEditor(cls);
            this.addEditorToMap(cls, propertyEditor);
        }
        return propertyEditor;
    }

    private void addEditorToMap(Class<?> cls, PropertyEditor propertyEditor) {
        if (propertyEditor != null) {
            this.editorMap.put(cls, propertyEditor);
        }
    }

    protected PropertyEditor getPropertyEditor(PropertyDescriptor propertyDescriptor) throws InstantiationException, IllegalAccessException {
        Class<?> propertyEditorClass = propertyDescriptor.getPropertyEditorClass();
        return null != propertyEditorClass ? (PropertyEditor)propertyEditorClass.newInstance() : this.getPropertyEditorValue(propertyDescriptor.getPropertyType());
    }
}

