/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.minecraft.server.MinecraftServer;

public class WorldMap {
    private js world;
    private lp log_agent;
    public int size;
    public int size_divided_by_2;
    public int size_squared;
    public final int bytes_per_pixel = 4;
    public int bytes_in_map;
    protected ByteBuffer data;
    private byte[] copy_of_data;
    private String progressive_filename;
    private RandomAccessFile progressive_file;
    private final int ticks_between_progressive_writes = 1200;
    private int progressive_write_counter = -1200;
    private int bytes_written_to_temporary_file;
    private final int bytes_to_write_to_temporary_file_per_tick = 1024;

    public WorldMap(js world) {
        this.world = world;
        this.log_agent = MinecraftServer.F().an();
        try {
            this.readFromFile();
        }
        catch (IOException e2) {
            this.size = MinecraftServer.F().default_world_map_size;
            this.size_divided_by_2 = this.size / 2;
            this.size_squared = this.size * this.size;
            this.bytes_in_map = this.size_squared * 4;
            this.data = ByteBuffer.allocateDirect(this.bytes_in_map);
            this.clearBiomeData();
        }
    }

    private static String getFilename(abw world) {
        String dimension_name = world.t.i == -2 ? "underworld" : (world.t.i == -1 ? "nether" : (world.t.i == 0 ? "overworld" : "unknown-dimension"));
        return world.x.k().replaceAll(" ", "-").toLowerCase() + "-" + dimension_name + ".map";
    }

    private void clearBiomeData() {
        for (int i2 = 3; i2 < this.bytes_in_map; i2 += 4) {
            this.data.put(i2, (byte)63);
        }
    }

    public void markPixelDirty(int x2, int z2) {
        if (this.isXZOnMap(x2, z2)) {
            int data_offset = this.getDataOffsetForPixel(x2, z2) + 3;
            this.data.put(data_offset, (byte)(this.data.get(data_offset) & 0x7F));
        }
    }

    private int getPixelIndex(int x2, int z2) {
        return x2 + this.size_divided_by_2 + (z2 + this.size_divided_by_2) * this.size;
    }

    private int getDataOffsetForPixel(int x2, int z2) {
        return (x2 + this.size_divided_by_2 + (z2 + this.size_divided_by_2) * this.size) * 4;
    }

    private int getMinMapXZ() {
        return -this.size_divided_by_2;
    }

    private int getMaxMapXZ() {
        return this.size_divided_by_2 - 1;
    }

    private boolean isXZOnMap(int x_or_z) {
        return x_or_z >= -this.size_divided_by_2 && x_or_z < this.size_divided_by_2;
    }

    private boolean isXZOnMap(int x2, int z2) {
        return x2 >= -this.size_divided_by_2 && x2 < this.size_divided_by_2 && z2 >= -this.size_divided_by_2 && z2 < this.size_divided_by_2;
    }

    private void readFromFile() throws IOException {
        FileInputStream fis = new FileInputStream(new File(WorldMap.getFilename(this.world)));
        FileChannel channel = fis.getChannel();
        this.bytes_in_map = (int)channel.size();
        this.size_squared = this.bytes_in_map / 4;
        this.size = (int)ls.a((double)this.size_squared);
        this.size_divided_by_2 = this.size / 2;
        if (this.data == null || this.bytes_in_map > this.data.capacity()) {
            this.data = ByteBuffer.allocateDirect(this.bytes_in_map);
        } else {
            this.data.clear();
        }
        channel.read(this.data);
        this.data.flip();
        fis.close();
        this.log_agent.a("Map loaded, size is " + this.size + "x" + this.size + " (" + this.bytes_in_map / 1024 / 1024 + "MB of memory)");
    }

    private void writeMapColorsToFile() {
        try {
            FileWriter fw2 = new FileWriter("map_colors.txt");
            StringBuffer sb2 = new StringBuffer();
            for (int i2 = 0; i2 < 256; ++i2) {
                aqz block = aqz.s[i2];
                if (i2 > 0) {
                    sb2.append('\n');
                }
                if (block == null || block.cU == null || block.cU.map_color == null) {
                    sb2.append(i2 + ",0,0,0");
                    continue;
                }
                ake map_color = block.cU.map_color;
                sb2.append(i2);
                sb2.append(",");
                sb2.append(map_color.p >> 16 & 0xFF);
                sb2.append(",");
                sb2.append(map_color.p >> 8 & 0xFF);
                sb2.append(",");
                sb2.append(map_color.p & 0xFF);
            }
            fw2.write(sb2.toString());
            fw2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateEmbeddedData() {
        int length_of_data_to_embed = 0;
        byte[] data_to_embed = new byte[64];
        int day_of_world = this.world.getDayOfWorld();
        int tick_of_day = this.world.getAdjustedTimeOfDay();
        data_to_embed[length_of_data_to_embed++] = (byte)(day_of_world & 0xFF);
        data_to_embed[length_of_data_to_embed++] = (byte)(day_of_world >> 8 & 0xFF);
        data_to_embed[length_of_data_to_embed++] = (byte)(day_of_world >> 16 & 0xFF);
        data_to_embed[length_of_data_to_embed++] = (byte)(day_of_world >> 24 & 0xFF);
        data_to_embed[length_of_data_to_embed++] = (byte)(tick_of_day & 0xFF);
        data_to_embed[length_of_data_to_embed++] = (byte)(tick_of_day >> 8 & 0xFF);
        int index_of_next_byte_to_embed = -1;
        int offset_of_last_hosting_pixel = -4;
        while (++index_of_next_byte_to_embed != length_of_data_to_embed) {
            byte block_id;
            do {
                if ((offset_of_last_hosting_pixel += 4) < this.bytes_in_map) continue;
                return;
            } while ((block_id = this.data.get(offset_of_last_hosting_pixel)) != 0 && block_id != aqz.J.cF);
            this.data.put(offset_of_last_hosting_pixel + 1, data_to_embed[index_of_next_byte_to_embed]);
        }
        return;
    }

    public void writeToFile() {
        if (!this.writeToFileProgressively(true)) {
            try {
                this.updateEmbeddedData();
                File temporary = new File(WorldMap.getFilename(this.world) + ".tmp");
                FileOutputStream fos = new FileOutputStream(temporary);
                FileChannel fc2 = fos.getChannel();
                this.data.rewind();
                fc2.write(this.data);
                fos.flush();
                fos.close();
                File file = new File(WorldMap.getFilename(this.world));
                if (file.exists() && !file.delete()) {
                    this.log_agent.b("writeToFile: Wasn't able to delete " + file.getName());
                }
                if (!temporary.renameTo(file)) {
                    this.log_agent.b("writeToFile: Wasn't able to rename " + temporary.getName() + " to " + file.getName());
                }
            }
            catch (IOException e2) {
                this.log_agent.b("writeToFile: Exception occured while trying to write world map to file");
            }
            this.writeMapColorsToFile();
        }
    }

    private void resetProgressiveFile() {
        this.progressive_filename = null;
        if (this.progressive_file != null) {
            try {
                this.progressive_file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.progressive_file = null;
        }
        this.progressive_write_counter = -1200;
    }

    public boolean writeToFileProgressively(boolean flush) {
        ++this.progressive_write_counter;
        if (this.progressive_write_counter == 0) {
            if (this.copy_of_data == null || this.copy_of_data.length != this.data.capacity()) {
                this.copy_of_data = new byte[this.data.capacity()];
            }
        } else if (this.progressive_write_counter == 1) {
            this.updateEmbeddedData();
            this.data.rewind();
            this.data.get(this.copy_of_data);
            if (this.progressive_file != null) {
                try {
                    this.progressive_file.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            try {
                this.progressive_filename = WorldMap.getFilename(this.world) + ".unfinished";
                this.progressive_file = new RandomAccessFile(this.progressive_filename, "rw");
                this.progressive_file.setLength(0L);
                this.bytes_written_to_temporary_file = 0;
            }
            catch (IOException e3) {
                this.log_agent.b("writeToFileProgressively: Exception occured while trying to write world map to file (Stage 1)");
                this.resetProgressiveFile();
            }
        } else if (this.progressive_write_counter == 2 && this.bytes_written_to_temporary_file < this.bytes_in_map) {
            --this.progressive_write_counter;
            try {
                int bytes_to_write = flush ? this.bytes_in_map - this.bytes_written_to_temporary_file : Math.min(1024, this.bytes_in_map - this.bytes_written_to_temporary_file);
                this.progressive_file.write(this.copy_of_data, this.bytes_written_to_temporary_file, bytes_to_write);
                this.bytes_written_to_temporary_file += bytes_to_write;
            }
            catch (IOException e4) {
                this.resetProgressiveFile();
            }
            if (flush) {
                this.writeToFileProgressively(false);
            }
        } else if (this.progressive_write_counter == 2) {
            try {
                this.progressive_file.close();
                File src = new File(this.progressive_filename);
                File dest = new File(WorldMap.getFilename(this.world));
                if (dest.exists() && !dest.delete()) {
                    this.log_agent.b("writeToFileProgressively: Wasn't able to delete " + dest.getName());
                    this.resetProgressiveFile();
                    return false;
                }
                if (!src.renameTo(dest)) {
                    this.log_agent.b("writeToFileProgressively: Wasn't able to rename " + src.getName() + " to " + dest.getName());
                    this.resetProgressiveFile();
                    return false;
                }
                this.writeMapColorsToFile();
            }
            catch (IOException e5) {
                this.log_agent.b("writeToFileProgressively: Exception occured while trying to write world map to file (Stage 3)");
                this.resetProgressiveFile();
                return false;
            }
            this.resetProgressiveFile();
            return true;
        }
        return false;
    }

    public int addSurvey(js world, int center_x, int center_z, int radius, boolean done_by_map) {
        int minus_radius = -radius;
        int radius_times_2 = radius * 2;
        int radius_sq = radius * radius;
        int radius_minus_2 = radius - 2;
        int radius_minus_2_sq = radius_minus_2 * radius_minus_2;
        int min_XZ = this.getMinMapXZ();
        int max_XZ = this.getMaxMapXZ();
        int blocks_surveyed = 0;
        block0: for (int dx2 = minus_radius; dx2 <= radius; ++dx2) {
            int x2 = center_x + dx2;
            if (x2 < min_XZ) continue;
            if (x2 > max_XZ) break;
            for (int dz2 = minus_radius; dz2 <= radius; ++dz2) {
                int depth;
                int block_id_above;
                int y2;
                adr chunk;
                boolean has_been_surveyed_by_map;
                int z2 = center_z + dz2;
                if (z2 < min_XZ) continue;
                if (z2 > max_XZ) continue block0;
                int distance_sq = dx2 * dx2 + dz2 * dz2;
                if (!done_by_map && (distance_sq >= radius_sq || distance_sq >= radius_minus_2_sq && (x2 + z2) % 2 == 0)) continue;
                int data_offset = this.getDataOffsetForPixel(x2, z2);
                byte biome_byte = this.data.get(data_offset + 3);
                boolean bl2 = has_been_surveyed_by_map = (biome_byte & 0x40) != 0;
                if ((biome_byte & 0x80) != 0 && (!done_by_map || has_been_surveyed_by_map) || (chunk = world.d(x2, z2)).g()) continue;
                int x_in_chunk = x2 & 0xF;
                int z_in_chunk = z2 & 0xF;
                int height_on_map = y2 = chunk.b(x_in_chunk, z_in_chunk) + 1 - 2;
                int block_id = chunk.a(x_in_chunk, y2, z_in_chunk);
                while ((block_id_above = chunk.a(x_in_chunk, y2 + 1, z_in_chunk)) != 0) {
                    ++y2;
                    aqz block_above = aqz.s[block_id_above];
                    if (block_above.cU.map_color == ake.b) continue;
                    height_on_map = y2;
                    block_id = block_id_above;
                }
                aqz block = aqz.s[block_id];
                if (block != null && block.cU.d()) {
                    int block_id_below;
                    aqz block_below;
                    depth = 1;
                    int y_below = y2;
                    while (--y_below >= 0 && (block_below = aqz.s[block_id_below = chunk.a(x_in_chunk, y_below, z_in_chunk)]) != null && block_below.cU.d()) {
                        ++depth;
                    }
                } else {
                    depth = 0;
                }
                this.data.put(data_offset, (byte)block_id);
                this.data.put(data_offset + 1, (byte)(world.h(x2, y2, z2) | depth << 4));
                this.data.put(data_offset + 2, (byte)height_on_map);
                if ((biome_byte & 0x3F) == 63) {
                    biome_byte = (byte)world.a((int)x2, (int)z2).N;
                }
                biome_byte = (byte)(biome_byte | 0x80);
                if (has_been_surveyed_by_map || done_by_map) {
                    biome_byte = (byte)(biome_byte | 0x40);
                }
                this.data.put(data_offset + 3, biome_byte);
                if (++blocks_surveyed < 1024) continue;
                return blocks_surveyed;
            }
        }
        return blocks_surveyed;
    }

    public void XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXaddSurvey(js world, int center_x, int center_z, int radius) {
        if (world.t.i != 0) {
            return;
        }
        byte day_of_world_mod_128 = (byte)(world.getDayOfWorld() % 128);
        int mapping_radius = world.t.g ? radius / 2 : radius;
        int mapping_radius_times_2 = mapping_radius * 2;
        int mapping_radius_sq = mapping_radius * mapping_radius;
        int[] var24 = new int[256];
        int min_XZ = this.getMinMapXZ();
        int max_XZ = this.getMaxMapXZ();
        block0: for (int raster_x = 1; raster_x < mapping_radius_times_2; ++raster_x) {
            double var16 = 0.0;
            int dx2 = raster_x - mapping_radius;
            int x2 = center_x + dx2;
            if (x2 < min_XZ) continue;
            if (x2 > max_XZ) break;
            int smallest_raster_z_that_is_due_for_update = mapping_radius_times_2;
            for (int raster_z = 1; raster_z < mapping_radius_times_2; ++raster_z) {
                int z2 = center_z + raster_z - mapping_radius;
                if (z2 < min_XZ || z2 > max_XZ || (this.data.get(this.getDataOffsetForPixel(x2, z2) + 3) & 0x80) != 0) continue;
                smallest_raster_z_that_is_due_for_update = raster_z;
                break;
            }
            if (smallest_raster_z_that_is_due_for_update == mapping_radius_times_2) continue;
            int first_raster_z = smallest_raster_z_that_is_due_for_update - 1;
            int largest_raster_z_that_is_due_for_update = -1;
            for (int raster_z = mapping_radius_times_2 - 1; raster_z >= 0; --raster_z) {
                int z3 = center_z + raster_z - mapping_radius;
                if (z3 < min_XZ || z3 > max_XZ || (this.data.get(this.getDataOffsetForPixel(x2, z3) + 3) & 0x80) != 0) continue;
                largest_raster_z_that_is_due_for_update = raster_z;
                break;
            }
            if (largest_raster_z_that_is_due_for_update == -1) continue;
            int last_raster_z = largest_raster_z_that_is_due_for_update;
            for (int raster_z = first_raster_z; raster_z <= last_raster_z; ++raster_z) {
                int offset_for_pixel;
                byte biome_byte;
                int var31;
                int dz2 = raster_z - mapping_radius;
                int z4 = center_z + dz2;
                if (z4 < min_XZ - 1) continue;
                if (z4 > max_XZ) continue block0;
                int dx_sq = dx2 * dx2;
                int dz_sq = dz2 * dz2;
                boolean at_edge_of_survey = dx_sq + dz_sq > (mapping_radius - 2) * (mapping_radius - 2);
                int x_plus_z_and_1 = x2 + z4 & 1;
                if (dz2 > 0 && dx_sq + dz_sq >= mapping_radius_sq) continue;
                for (int i2 = 0; i2 < var24.length; ++i2) {
                    var24[i2] = 0;
                }
                adr chunk = world.d(x2, z4);
                if (chunk.g()) continue;
                int block_id = -1;
                int metadata = -1;
                int brightness = -1;
                int depth = -1;
                int height = -1;
                int x_in_chunk = x2 & 0xF;
                int z_in_chunk = z4 & 0xF;
                int var28 = 0;
                double var29 = 0.0;
                if (world.t.g) {
                    var31 = x2 + z4 * 231871;
                    if (((var31 = var31 * var31 * 31287121 + var31 * 11) >> 20 & 1) == 0) {
                        int n = aqz.A.cF;
                        var24[n] = var24[n] + 10;
                    } else {
                        int n = aqz.y.cF;
                        var24[n] = var24[n] + 10;
                    }
                    var29 = 100.0;
                } else {
                    var31 = 0;
                    int var32 = 0;
                    int var33 = chunk.b(var31 + x_in_chunk, var32 + z_in_chunk) + 1;
                    height = var33 - 1;
                    int var34 = 0;
                    if (var33 > 1) {
                        boolean var35;
                        do {
                            var35 = true;
                            var34 = chunk.a(var31 + x_in_chunk, var33 - 1, var32 + z_in_chunk);
                            if (var34 == 0) {
                                var35 = false;
                            } else if (var33 > 0 && var34 > 0 && aqz.s[var34].cU.map_color == ake.b) {
                                var35 = false;
                            }
                            if (var35) continue;
                            if (--var33 <= 0) break;
                            var34 = chunk.a(var31 + x_in_chunk, var33 - 1, var32 + z_in_chunk);
                            height = var33 - 1;
                        } while (var33 > 0 && !var35);
                        if (var33 > 0 && var34 != 0 && aqz.s[var34].cU.d()) {
                            int var43;
                            int var36 = var33 - 1;
                            boolean var37 = false;
                            do {
                                var43 = chunk.a(var31 + x_in_chunk, var36--, var32 + z_in_chunk);
                                ++var28;
                            } while (var36 > 0 && var43 != 0 && aqz.s[var43].cU.d());
                            depth = var28 - 1;
                            if (depth > 15) {
                                depth = 15;
                            }
                        } else {
                            depth = 0;
                        }
                    }
                    var29 += (double)var33;
                    int n = var34;
                    var24[n] = var24[n] + 1;
                }
                var31 = 0;
                block_id = -1;
                for (int i3 = 0; i3 < 256; ++i3) {
                    if (var24[i3] <= var31) continue;
                    block_id = i3;
                    var31 = var24[i3];
                }
                if (block_id == 0) {
                    metadata = 0;
                    brightness = 0;
                    depth = 0;
                    height = 0;
                } else if (block_id > 0) {
                    double var40;
                    brightness = aqz.s[block_id].cU.map_color == ake.n ? ((var40 = (double)var28 * 0.1 + (double)x_plus_z_and_1 * 0.2) > 0.9 ? 0 : (var40 < 0.5 ? 2 : 1)) : ((var40 = (var29 - var16) * 4.0 / 5.0 + ((double)x_plus_z_and_1 - 0.5) * 0.4) < -0.6 ? 0 : (var40 > 0.6 ? 2 : 1));
                }
                var16 = var29;
                if (raster_z <= first_raster_z || dx_sq + dz_sq >= mapping_radius_sq || at_edge_of_survey && x_plus_z_and_1 == 0) {
                    block_id = -1;
                }
                if (block_id < 0 || ((biome_byte = this.data.get((offset_for_pixel = this.getDataOffsetForPixel(x2, z4)) + 3)) >> 7 & 1) != 0) continue;
                this.data.put(offset_for_pixel, (byte)block_id);
                this.data.put(offset_for_pixel + 1, (byte)(world.h(x2, height, z4) | depth << 4));
                this.data.put(offset_for_pixel + 2, (byte)height);
                if ((biome_byte & 0x7F) == 127) {
                    biome_byte = (byte)world.a((int)x2, (int)z4).N;
                }
                this.data.put(offset_for_pixel + 3, (byte)(biome_byte | 0x80));
                ++Debug.general_counter;
            }
        }
    }

    public String getPixelInfo(int x2, int z2) {
        if (!this.isXZOnMap(x2, z2)) {
            return "Off-map";
        }
        int offset = this.getDataOffsetForPixel(x2, z2);
        byte block_id = this.data.get(offset);
        byte complex_byte = this.data.get(offset + 1);
        int metadata = complex_byte & 0xF;
        int depth = complex_byte >> 4 & 0xF;
        byte height = this.data.get(offset + 2);
        byte biome_id = this.data.get(offset + 3);
        return "block_id=" + block_id + " metadata=" + metadata + " depth=" + depth + " height=" + height + " biome_id=" + biome_id;
    }

    public static void deleteMapFile(abw world) {
        String filename = WorldMap.getFilename(world);
        File file = new File(filename);
        if (file.exists() && !file.delete()) {
            world.Y().b("Unable to delete previous world map file " + filename);
        }
    }
}

