/*
 * Decompiled with CFR 0.152.
 */
public class TournamentStanding {
    public boolean caught_a_fish;
    public boolean killed_a_skeleton;
    public boolean killed_a_zombie;
    public boolean killed_a_spider;
    public boolean killed_a_wood_spider;
    public boolean killed_a_creeper;
    public boolean killed_a_large_slime;
    public boolean killed_a_ghoul;
    public boolean killed_a_wight;
    public boolean killed_an_invisible_stalker;
    public boolean killed_a_witch;
    public boolean killed_a_shadow;
    public boolean killed_a_hellhound;
    public boolean killed_a_demon_spider;
    public int copper_nuggets_harvested;
    public int silver_nuggets_harvested;
    public int gold_nuggets_harvested;
    public int mithril_nuggets_harvested;
    public int adamantium_nuggets_harvested;
    public int copper_ore_harvested;
    public int silver_ore_harvested;
    public int gold_ore_harvested;
    public int iron_ore_harvested;
    public int mithril_ore_harvested;
    public int adamantium_ore_harvested;
    public int experience;

    public TournamentStanding readFromNBT(by par1NBTTagCompound) {
        this.caught_a_fish = par1NBTTagCompound.n("caught_a_fish");
        this.killed_a_skeleton = par1NBTTagCompound.n("killed_a_skeleton");
        this.killed_a_zombie = par1NBTTagCompound.n("killed_a_zombie");
        this.killed_a_spider = par1NBTTagCompound.n("killed_a_spider");
        this.killed_a_wood_spider = par1NBTTagCompound.n("killed_a_wood_spider");
        this.killed_a_creeper = par1NBTTagCompound.n("killed_a_creeper");
        this.killed_a_large_slime = par1NBTTagCompound.n("killed_a_large_slime");
        this.killed_a_ghoul = par1NBTTagCompound.n("killed_a_ghoul");
        this.killed_a_wight = par1NBTTagCompound.n("killed_a_wight");
        this.killed_an_invisible_stalker = par1NBTTagCompound.n("killed_an_invisible_stalker");
        this.killed_a_witch = par1NBTTagCompound.n("killed_a_witch");
        this.killed_a_shadow = par1NBTTagCompound.n("killed_a_shadow");
        this.killed_a_hellhound = par1NBTTagCompound.n("killed_a_hellhound");
        this.killed_a_demon_spider = par1NBTTagCompound.n("killed_a_demon_spider");
        this.copper_nuggets_harvested = par1NBTTagCompound.e("copper_nuggets_harvested");
        this.silver_nuggets_harvested = par1NBTTagCompound.e("silver_nuggets_harvested");
        this.gold_nuggets_harvested = par1NBTTagCompound.e("gold_nuggets_harvested");
        this.mithril_nuggets_harvested = par1NBTTagCompound.e("mithril_nuggets_harvested");
        this.adamantium_nuggets_harvested = par1NBTTagCompound.e("adamantium_nuggets_harvested");
        this.copper_ore_harvested = par1NBTTagCompound.e("copper_ore_smelted");
        this.silver_ore_harvested = par1NBTTagCompound.e("silver_ore_smelted");
        this.gold_ore_harvested = par1NBTTagCompound.e("gold_ore_smelted");
        this.iron_ore_harvested = par1NBTTagCompound.e("iron_ore_smelted");
        this.mithril_ore_harvested = par1NBTTagCompound.e("mithril_ore_harvested");
        this.adamantium_ore_harvested = par1NBTTagCompound.e("adamantium_ore_harvested");
        return this;
    }

    public void writeToNBT(by par1NBTTagCompound) {
        par1NBTTagCompound.a("caught_a_fish", this.caught_a_fish);
        par1NBTTagCompound.a("killed_a_skeleton", this.killed_a_skeleton);
        par1NBTTagCompound.a("killed_a_zombie", this.killed_a_zombie);
        par1NBTTagCompound.a("killed_a_spider", this.killed_a_spider);
        par1NBTTagCompound.a("killed_a_wood_spider", this.killed_a_wood_spider);
        par1NBTTagCompound.a("killed_a_creeper", this.killed_a_creeper);
        par1NBTTagCompound.a("killed_a_large_slime", this.killed_a_large_slime);
        par1NBTTagCompound.a("killed_a_ghoul", this.killed_a_ghoul);
        par1NBTTagCompound.a("killed_a_wight", this.killed_a_wight);
        par1NBTTagCompound.a("killed_an_invisible_stalker", this.killed_an_invisible_stalker);
        par1NBTTagCompound.a("killed_a_witch", this.killed_a_witch);
        par1NBTTagCompound.a("killed_a_shadow", this.killed_a_shadow);
        par1NBTTagCompound.a("killed_a_hellhound", this.killed_a_hellhound);
        par1NBTTagCompound.a("killed_a_demon_spider", this.killed_a_demon_spider);
        par1NBTTagCompound.a("copper_nuggets_harvested", this.copper_nuggets_harvested);
        par1NBTTagCompound.a("silver_nuggets_harvested", this.silver_nuggets_harvested);
        par1NBTTagCompound.a("gold_nuggets_harvested", this.gold_nuggets_harvested);
        par1NBTTagCompound.a("mithril_nuggets_harvested", this.mithril_nuggets_harvested);
        par1NBTTagCompound.a("adamantium_nuggets_harvested", this.adamantium_nuggets_harvested);
        par1NBTTagCompound.a("copper_ore_smelted", this.copper_ore_harvested);
        par1NBTTagCompound.a("silver_ore_smelted", this.silver_ore_harvested);
        par1NBTTagCompound.a("gold_ore_smelted", this.gold_ore_harvested);
        par1NBTTagCompound.a("iron_ore_smelted", this.iron_ore_harvested);
        par1NBTTagCompound.a("mithril_ore_harvested", this.mithril_ore_harvested);
        par1NBTTagCompound.a("adamantium_ore_harvested", this.adamantium_ore_harvested);
    }

    public int calcScore() {
        int score = 0;
        score += this.caught_a_fish ? 300 : 0;
        score += this.killed_a_skeleton ? 100 : 0;
        score += this.killed_a_zombie ? 200 : 0;
        score += this.killed_a_spider ? 200 : 0;
        score += this.killed_a_wood_spider ? 200 : 0;
        score += this.killed_a_creeper ? 200 : 0;
        score += this.killed_a_large_slime ? 300 : 0;
        score += this.killed_a_ghoul ? 300 : 0;
        score += this.killed_a_wight ? 400 : 0;
        score += this.killed_an_invisible_stalker ? 300 : 0;
        score += this.killed_a_witch ? 500 : 0;
        score += this.killed_a_shadow ? 500 : 0;
        score += this.killed_a_hellhound ? 700 : 0;
        score += this.killed_a_demon_spider ? 1000 : 0;
        score += this.copper_nuggets_harvested * 100;
        score += this.silver_nuggets_harvested * 200;
        score += this.gold_nuggets_harvested * 300;
        score += this.mithril_nuggets_harvested * 500;
        score += this.adamantium_nuggets_harvested * 900;
        score += this.copper_ore_harvested * 900;
        score += this.silver_ore_harvested * 1800;
        score += this.gold_ore_harvested * 2700;
        score += this.iron_ore_harvested * 2700;
        score += this.mithril_ore_harvested * 4500;
        score += this.adamantium_ore_harvested * 8100;
        return score += this.experience;
    }

    private String getKilledMobString(String mob_name, boolean killed) {
        if (!killed) {
            return "";
        }
        StringBuffer sb2 = new StringBuffer();
        sb2.append(StringHelper.startsWithVowel(mob_name) ? "an" : "a");
        sb2.append(" ");
        sb2.append(mob_name);
        sb2.append(", ");
        return sb2.toString();
    }

    private String getHarvestedItemString(yc item, int number_harvested) {
        if (number_harvested == 0) {
            return "";
        }
        StringBuffer sb2 = new StringBuffer();
        sb2.append(number_harvested);
        sb2.append(" ");
        sb2.append(item.getItemDisplayName().toLowerCase());
        if (number_harvested > 1) {
            sb2.append("s");
        }
        sb2.append(", ");
        return sb2.toString();
    }

    public String toString(String username) {
        StringBuffer line = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        line.append(this.calcScore() + ": " + username + " has killed ");
        sb2.append(this.getKilledMobString("skeleton", this.killed_a_skeleton));
        sb2.append(this.getKilledMobString("zombie", this.killed_a_zombie));
        sb2.append(this.getKilledMobString("spider", this.killed_a_spider));
        sb2.append(this.getKilledMobString("wood_spider", this.killed_a_wood_spider));
        sb2.append(this.getKilledMobString("creeper", this.killed_a_creeper));
        sb2.append(this.getKilledMobString("large slime", this.killed_a_large_slime));
        sb2.append(this.getKilledMobString("ghoul", this.killed_a_ghoul));
        sb2.append(this.getKilledMobString("wight", this.killed_a_wight));
        sb2.append(this.getKilledMobString("invisible stalker", this.killed_an_invisible_stalker));
        sb2.append(this.getKilledMobString("witch", this.killed_a_witch));
        sb2.append(this.getKilledMobString("shadow", this.killed_a_shadow));
        sb2.append(this.getKilledMobString("hellhound", this.killed_a_hellhound));
        sb2.append(this.getKilledMobString("demon spider", this.killed_a_demon_spider));
        if (sb2.length() == 0) {
            line.append("no mobs, ");
        } else {
            line.append(sb2.toString());
        }
        line.append("has harvested ");
        sb2.setLength(0);
        sb2.append(this.getHarvestedItemString(yc.copperNugget, this.copper_nuggets_harvested));
        sb2.append(this.getHarvestedItemString(yc.silverNugget, this.silver_nuggets_harvested));
        sb2.append(this.getHarvestedItemString(yc.bs, this.gold_nuggets_harvested));
        sb2.append(this.getHarvestedItemString(yc.mithrilNugget, this.mithril_nuggets_harvested));
        sb2.append(this.getHarvestedItemString(yc.adamantiumNugget, this.adamantium_nuggets_harvested));
        sb2.append(this.getHarvestedItemString(yc.getItem(aqz.oreCopper), this.copper_ore_harvested));
        sb2.append(this.getHarvestedItemString(yc.getItem(aqz.oreSilver), this.silver_ore_harvested));
        sb2.append(this.getHarvestedItemString(yc.getItem(aqz.L), this.gold_ore_harvested));
        sb2.append(this.getHarvestedItemString(yc.getItem(aqz.M), this.iron_ore_harvested));
        sb2.append(this.getHarvestedItemString(yc.getItem(aqz.oreMithril), this.mithril_ore_harvested));
        sb2.append(this.getHarvestedItemString(yc.getItem(aqz.oreAdamantium), this.adamantium_ore_harvested));
        if (sb2.length() == 0) {
            line.append("no scoring items, ");
        } else {
            line.append(sb2.toString());
        }
        if (this.caught_a_fish) {
            line.append("has caught a fish, ");
        }
        line.append("and has " + this.experience + " experience.");
        return line.toString();
    }
}

