/*
 * Decompiled with CFR 0.152.
 */
public class SpatialScaler {
    private static final int scaling_factor_for_pos_xz = 4095;
    private static final int scaling_factor_for_pos_y = 127;

    public static int getScalingFactorForRotation() {
        return 256;
    }

    public static int getScaledPosX(nn entity) {
        return entity.at.multiplyByNAndRound(entity.u, 4095);
    }

    public static int getScaledPosX(double pos_x) {
        return ls.c(pos_x * 4095.0);
    }

    public static double getPosX(int scaled_pos_x) {
        return (double)scaled_pos_x / 4095.0;
    }

    public static int getScaledPosY(nn entity) {
        return ls.c(entity.v * 127.0);
    }

    public static int getScaledPosY(double pos_y) {
        return ls.c(pos_y * 127.0);
    }

    public static double getPosY(int scaled_pos_y) {
        return (double)scaled_pos_y / 127.0 + 0.015625;
    }

    public static int getScaledPosZ(nn entity) {
        return entity.at.multiplyByNAndRound(entity.w, 4095);
    }

    public static int getScaledPosZ(double pos_z) {
        return ls.c(pos_z * 4095.0);
    }

    public static double getPosZ(int scaled_pos_z) {
        return (double)scaled_pos_z / 4095.0;
    }

    public static int getScaledRotation(float rotation) {
        return ls.d(rotation * (float)SpatialScaler.getScalingFactorForRotation() / 360.0f);
    }

    public static float getRotation(int scaled_rotation) {
        return (float)scaled_rotation * 360.0f / (float)SpatialScaler.getScalingFactorForRotation();
    }

    public static int getScaledMotion(double motion) {
        double var4 = motion;
        double var2 = 3.9;
        if (var4 < -var2) {
            var4 = -var2;
        } else if (var4 > var2) {
            var4 = var2;
        }
        return (int)(var4 * 8000.0);
    }

    public static double getMotion(int scaled_motion) {
        return (double)scaled_motion / 8000.0;
    }
}

