/*
 * Decompiled with CFR 0.152.
 */
public class Skill {
    public static final int ANY = -1;
    public static final int ALL = -1;
    public static final int NONE = 0;
    public static Skill[] list = new Skill[32];
    private static int num_skills;
    public static Skill FIGHTING;
    public static Skill ARCHERY;
    public static Skill MINING;
    public static Skill FOOD_PREPARATION;
    public static Skill MASONRY;
    public static Skill FARMING;
    public static Skill TINKERING;
    public static Skill CARPENTRY;
    public static Skill BLACKSMITHING;
    public static Skill BREWING;
    public static Skill FINE_ARTS;
    public static Skill ENCHANTING;
    public static Skill FISHING;
    final int id = 1 << num_skills;
    final String unlocalized_name;

    public Skill(String unlocalized_name) {
        Skill.list[Skill.num_skills++] = this;
        this.unlocalized_name = "skill." + unlocalized_name;
    }

    static Skill getById(int id2) {
        for (int i = 0; i < num_skills; ++i) {
            if ((Skill.list[i].id & id2) == 0) continue;
            return list[i];
        }
        return null;
    }

    static Skill[] getSkillsByIds(int ids) {
        int num_skills_present = Skill.getNumSkills(ids);
        if (num_skills_present == 0) {
            return null;
        }
        Skill[] skills = new Skill[num_skills_present];
        int j = 0;
        for (int i = 0; i < num_skills; ++i) {
            if (!BitHelper.isBitSet(ids, Skill.list[i].id)) continue;
            skills[j++] = list[i];
        }
        return j == 0 ? null : skills;
    }

    static Skill getByLocalizedName(String localized_name, boolean profession_name) {
        for (int i = 0; i < num_skills; ++i) {
            if (!list[i].getLocalizedName(profession_name).equalsIgnoreCase(localized_name)) continue;
            return list[i];
        }
        return null;
    }

    static String getSkillsString(int ids, boolean profession_names, String delimiter) {
        StringBuffer sb2 = new StringBuffer();
        for (int i = 0; i < num_skills; ++i) {
            Skill skill = list[i];
            if (!BitHelper.isBitSet(ids, skill.id)) continue;
            sb2.append(skill.getLocalizedName(profession_names) + delimiter);
        }
        String s = sb2.toString();
        return s.isEmpty() ? null : StringHelper.left(s, -delimiter.length());
    }

    public static String getSkillsetsString(int[] skillsets, boolean profession_names) {
        StringBuffer sb2 = new StringBuffer();
        String delimiter = " or ";
        for (int i = 0; i < skillsets.length; ++i) {
            sb2.append(Skill.getSkillsString(skillsets[i], profession_names, profession_names ? " / " : " + ") + delimiter);
        }
        String s = sb2.toString();
        return s.isEmpty() ? null : StringHelper.left(s, -delimiter.length());
    }

    public static int getNumSkills() {
        return num_skills;
    }

    public static int getNumSkills(int ids) {
        int num = 0;
        for (int i = 0; i < num_skills; ++i) {
            if (!BitHelper.isBitSet(ids, Skill.list[i].id)) continue;
            ++num;
        }
        return num;
    }

    public static boolean skillExistsIn(Skill skill, int ids) {
        return BitHelper.isBitSet(ids, skill.id);
    }

    public String toString() {
        return this.getLocalizedName(false);
    }

    public String getLocalizedName(boolean profession_name) {
        return bu.a((String)(profession_name ? this.unlocalized_name + ".profession" : this.unlocalized_name));
    }

    public String getLocalizedDescription() {
        return bu.a((String)(this.unlocalized_name + ".description"));
    }

    static {
        FIGHTING = new Skill("fighting");
        ARCHERY = new Skill("archery");
        MINING = new Skill("mining");
        FOOD_PREPARATION = new Skill("foodPreparation");
        MASONRY = new Skill("masonry");
        FARMING = new Skill("farming");
        TINKERING = new Skill("tinkering");
        CARPENTRY = new Skill("carpentry");
        BLACKSMITHING = new Skill("blacksmithing");
        BREWING = new Skill("brewing");
        FINE_ARTS = new Skill("fineArts");
        ENCHANTING = new Skill("enchanting");
        FISHING = new Skill("fishing");
    }
}

