/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ReferenceFileWriter {
    private static String newline = new String(System.getProperty("line.separator").getBytes());
    public static boolean running;

    private static String formatFloat(float f2) {
        return StringHelper.formatFloat(f2);
    }

    private static String getBlockMaterialString(aqz block, ye item_stack, boolean as_subtype) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Block[" + block.cF + "]");
        sb2.append(as_subtype ? "[" + item_stack.getItemSubtype() + "] " : " ");
        sb2.append(item_stack.getNameForReferenceFile() + ": " + block.cU.name);
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeBlockMaterialFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/block_material.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Block Material" + newline);
        sb2.append("--------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            List list = block.getItemStacks();
            ye item_stack2 = (ye)list.get(0);
            if (list.size() == 1 && item_stack2.getItemSubtype() == 0) {
                sb2.append(ReferenceFileWriter.getBlockMaterialString(block, item_stack2, false));
                continue;
            }
            for (ye item_stack2 : list) {
                sb2.append(ReferenceFileWriter.getBlockMaterialString(block, item_stack2, true));
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getBlockConstantsString(aqz block) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Block[" + block.cF + "] ");
        sb2.append(block.getNameForReferenceFile(0, true) + ": ");
        String[] tags = new String[16];
        if (block.is_always_opaque_standard_form_cube) {
            StringHelper.addToStringArray("ALWAYS_OPAQUE_STANDARD_FORM_CUBE", tags);
        } else if (block.is_always_standard_form_cube) {
            StringHelper.addToStringArray("ALWAYS_STANDARD_FORM_CUBE", tags);
        } else if (block.is_never_standard_form_cube) {
            StringHelper.addToStringArray("NEVER_STANDARD_FORM_CUBE", tags);
        } else {
            StringHelper.addToStringArray("NOT_ALWAYS_STANDARD_FORM_CUBE", tags);
        }
        if (block.is_always_solid) {
            StringHelper.addToStringArray("ALWAYS_SOLID", tags);
        } else if (block.is_never_solid) {
            StringHelper.addToStringArray("NEVER_SOLID", tags);
        } else {
            StringHelper.addToStringArray("SOMETIMES_SOLID", tags);
        }
        if (block.never_hides_adjacent_faces) {
            StringHelper.addToStringArray("NEVER_HIDES_ADJACENT_FACES", tags);
        }
        if (MITEConstant.useNewPrecipitationHeightDetermination()) {
            if (block.always_blocks_precipitation) {
                StringHelper.addToStringArray("ALWAYS_BLOCKS_PRECIPITATION", tags);
            } else if (block.never_blocks_precipitation) {
                StringHelper.addToStringArray("NEVER_BLOCKS_PRECIPITATION", tags);
            } else {
                StringHelper.addToStringArray("SOMETIMES_BLOCKS_PRECIPITATION", tags);
            }
        }
        if (block.always_blocks_fluids) {
            StringHelper.addToStringArray("ALWAYS_BLOCKS_FLUIDS", tags);
        } else if (block.never_blocks_fluids) {
            StringHelper.addToStringArray("NEVER_BLOCKS_FLUIDS", tags);
        } else {
            StringHelper.addToStringArray("SOMETIMES_BLOCKS_FLUIDS", tags);
        }
        if (block.connects_with_fence) {
            StringHelper.addToStringArray("ALWAYS_CONNECTS_WITH_FENCE", tags);
        } else {
            StringHelper.addToStringArray("NEVER_CONNECTS_WITH_FENCE", tags);
        }
        if (block.is_always_legal) {
            StringHelper.addToStringArray("ALWAYS_LEGAL", tags);
        } else {
            StringHelper.addToStringArray("NOT_ALWAYS_LEGAL", tags);
        }
        if (block.is_always_immutable) {
            StringHelper.addToStringArray("ALWAYS_IMMUTABLE", tags);
        }
        if (!block.canBeCarried()) {
            StringHelper.addToStringArray("NEVER_CARRIED", tags);
        }
        sb2.append(StringHelper.implode(tags, ", ", false, false));
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeBlockConstantsFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/block_constants.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Block Constants" + newline);
        sb2.append("---------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            sb2.append(ReferenceFileWriter.getBlockConstantsString(block));
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getBlockHardnessString(aqz block, ye item_stack, boolean as_subtype) {
        StringBuilder sb2 = new StringBuilder();
        int subtype = item_stack.getItemSubtype();
        sb2.append("Block[" + block.cF + "]");
        sb2.append(as_subtype ? "[" + subtype + "] " : " ");
        float hardness = block.getBlockHardness(block instanceof anr ? 1 : subtype);
        sb2.append(item_stack.getNameForReferenceFile() + ": " + (hardness == -1.0f ? "Infinite" : Integer.valueOf((int)(hardness * 100.0f))));
        if (block.isPortable(null, null, 0, 0, 0)) {
            sb2.append(" {Portable}");
        }
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeBlockHardnessFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/block_hardness.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Block Hardness" + newline);
        sb2.append("--------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            List list = block.getItemStacks();
            ye item_stack2 = (ye)list.get(0);
            if (list.size() == 1 && item_stack2.getItemSubtype() == 0) {
                sb2.append(ReferenceFileWriter.getBlockHardnessString(block, item_stack2, false));
                continue;
            }
            for (ye item_stack2 : list) {
                sb2.append(ReferenceFileWriter.getBlockHardnessString(block, item_stack2, true));
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getBlockMetadataString(aqz block) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Block[" + block.cF + "] ");
        sb2.append(block.getNameForReferenceFile(0, true) + ": ");
        boolean previous_was_valid = false;
        int first_valid = -1;
        int last_valid = -1;
        for (int i2 = 0; i2 < 16; ++i2) {
            if (block.isValidMetadata(i2)) {
                if (previous_was_valid) {
                    last_valid = i2;
                } else {
                    first_valid = last_valid = i2;
                    previous_was_valid = true;
                }
                if (i2 != 15) continue;
                sb2.append("[" + (last_valid == first_valid ? Integer.valueOf(first_valid) : first_valid + "-" + last_valid) + "]");
                continue;
            }
            if (!previous_was_valid) continue;
            sb2.append("[" + (last_valid == first_valid ? Integer.valueOf(first_valid) : first_valid + "-" + last_valid) + "]");
            previous_was_valid = false;
        }
        String notes = block.getMetadataNotes();
        if (notes != null) {
            sb2.append(" {" + notes + "}");
        }
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeBlockMetadataFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/block_metadata.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Block Metadata" + newline);
        sb2.append("--------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            sb2.append(ReferenceFileWriter.getBlockMetadataString(block));
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getBlockDissolveTimeString(aqz block, ye item_stack, boolean as_subtype) {
        StringBuilder sb2 = new StringBuilder();
        int subtype = item_stack.getItemSubtype();
        sb2.append("Block[" + block.cF + "]");
        sb2.append(as_subtype ? "[" + subtype + "] " : " ");
        int ticks_for_pepsin = block.getDissolvePeriod(subtype, nb.pepsin);
        int ticks_for_acid = block.getDissolvePeriod(subtype, nb.acid);
        sb2.append(item_stack.getNameForReferenceFile() + ": " + (ticks_for_pepsin < 0 ? "never" : (ticks_for_pepsin == 0 ? "instant" : Integer.valueOf(ticks_for_pepsin))));
        sb2.append(", " + (ticks_for_acid < 0 ? "never" : (ticks_for_acid == 0 ? "instant" : Integer.valueOf(ticks_for_acid))));
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeBlockDissolveTimeFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/block_dissolve_time.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Number of ticks for a small gelatinous cube to dissolve the block (pepsin, acid)." + newline + newline);
        sb2.append("Block Dissolve Time" + newline);
        sb2.append("-------------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            List list = block.getItemStacks();
            ye item_stack2 = (ye)list.get(0);
            if (list.size() == 1 && item_stack2.getItemSubtype() == 0) {
                sb2.append(ReferenceFileWriter.getBlockDissolveTimeString(block, item_stack2, false));
                continue;
            }
            for (ye item_stack2 : list) {
                sb2.append(ReferenceFileWriter.getBlockDissolveTimeString(block, item_stack2, true));
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getSilkHarvestString(aqz block, ye item_stack, boolean as_subtype) {
        StringBuilder sb2 = new StringBuilder();
        int subtype = item_stack.getItemSubtype();
        sb2.append("Block[" + block.cF + "]");
        sb2.append(as_subtype ? "[" + subtype + "] " : " ");
        sb2.append(item_stack.getNameForReferenceFile() + ": " + StringHelper.yesOrNo(block.canSilkHarvest(subtype)));
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeSilkHarvestFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/silk_harvest.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Can Silk Harvest" + newline);
        sb2.append("----------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            List list = block.getItemStacks();
            ye item_stack2 = (ye)list.get(0);
            if (list.size() == 1 && item_stack2.getItemSubtype() == 0) {
                sb2.append(ReferenceFileWriter.getSilkHarvestString(block, item_stack2, false));
                continue;
            }
            for (ye item_stack2 : list) {
                sb2.append(ReferenceFileWriter.getSilkHarvestString(block, item_stack2, true));
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getBlockHarvestLevelString(aqz block, ye item_stack, boolean as_subtype) {
        int subtype = item_stack.getItemSubtype();
        int harvest_level = block.getMinHarvestLevel(subtype);
        if (harvest_level == 0) {
            return "";
        }
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Block[" + block.cF + "]");
        sb2.append(as_subtype ? "[" + subtype + "] " : " ");
        sb2.append(item_stack.getNameForReferenceFile() + ": " + harvest_level);
        sb2.append(newline);
        return sb2.toString();
    }

    private static String getToolHarvestLevelString(xj item, ye item_stack, boolean as_subtype) {
        int subtype = item_stack.getItemSubtype();
        int harvest_level = item.getMaterialHarvestLevel();
        if (harvest_level == 0) {
            return "";
        }
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Item[" + item_stack.d + "]");
        sb2.append(as_subtype ? "[" + subtype + "] " : " ");
        sb2.append(item_stack.getNameForReferenceFile());
        sb2.append(": " + harvest_level);
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeHarvestLevelFile(File dir) throws Exception {
        int i2;
        FileWriter fw2 = new FileWriter(dir.getPath() + "/harvest_level.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Only blocks and tools with a harvest level greater than 0 are listed." + newline + newline);
        sb2.append("Block Harvest Level" + newline);
        sb2.append("-------------------" + newline);
        for (i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            List list = block.getItemStacks();
            ye item_stack2 = (ye)list.get(0);
            if (list.size() == 1 && item_stack2.getItemSubtype() == 0) {
                sb2.append(ReferenceFileWriter.getBlockHarvestLevelString(block, item_stack2, false));
                continue;
            }
            for (ye item_stack2 : list) {
                sb2.append(ReferenceFileWriter.getBlockHarvestLevelString(block, item_stack2, true));
            }
        }
        sb2.append(newline);
        sb2.append("Tool Harvest Level" + newline);
        sb2.append("------------------" + newline);
        for (i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (!(item instanceof xj)) continue;
            xj tool = item.getAsTool();
            List sub_items = item.getSubItems();
            ye item_stack3 = (ye)sub_items.get(0);
            if (sub_items.size() == 1 && item_stack3.getItemSubtype() == 0) {
                sb2.append(ReferenceFileWriter.getToolHarvestLevelString(tool, item_stack3, false));
                continue;
            }
            for (ye item_stack3 : sub_items) {
                sb2.append(ReferenceFileWriter.getToolHarvestLevelString(tool, item_stack3, true));
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getComponentString(ye item_stack) {
        yc item = item_stack.b();
        StringBuffer sb2 = new StringBuffer();
        sb2.append(item_stack.getNameForReferenceFile() + ": difficulty = ");
        sb2.append(item_stack.getCraftingDifficultyAsComponent() < 0.0f ? "Not set!" : ReferenceFileWriter.formatFloat(item_stack.getCraftingDifficultyAsComponent()));
        List products = item.getCraftingProductsThisIsComponentOf(item_stack.getItemSubtype());
        if (products.size() > 0) {
            sb2.append(", {");
            for (int i2 = 0; i2 < products.size(); ++i2) {
                ye output = (ye)products.get(i2);
                sb2.append(output.getNameForReferenceFile());
                if (i2 >= products.size() - 1) continue;
                sb2.append(", ");
            }
            sb2.append("}");
        }
        return sb2.toString();
    }

    private static void writeRecipeComponentsFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/recipe_components.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("The difficulty of a crafting recipe is equal to the sum of the difficulty of its components. Therefore each recipe has its own difficulty (see item_recipes.txt for more information)." + newline + newline);
        sb2.append("Recipe Components" + newline);
        sb2.append("-----------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (item == null) continue;
            if (item.getNumSubtypes() == 0 && item.isCraftingComponent(0)) {
                sb2.append("Item[" + i2 + "] ");
                sb2.append(ReferenceFileWriter.getComponentString(new ye(item)));
                sb2.append(newline);
                continue;
            }
            List sub_items = item.getSubItems();
            for (ye item_stack : sub_items) {
                if (!item.isCraftingComponent(item_stack.getItemSubtype())) continue;
                sb2.append("Item[" + i2 + "][" + (item instanceof yh ? "*" : Integer.valueOf(item_stack.getItemSubtype())) + "] ");
                sb2.append(ReferenceFileWriter.getComponentString(item_stack));
                sb2.append(newline);
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeItemSubtypesFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/item_subtypes.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Item Subtypes" + newline);
        sb2.append("-------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            zh item_block;
            yc item = yc.getItem(i2);
            if (item == null || !item.n()) continue;
            sb2.append("Item[" + i2 + "] ");
            sb2.append(item.getNameForReferenceFile());
            if (item instanceof zh && (item_block = (zh)item).getBlock().getNumSubBlocks() != item.getNumSubtypes()) {
                System.out.println("Number of subtypes discrepency for " + item + ", " + item_block.getBlock().getNumSubBlocks() + " vs " + item.getNumSubtypes());
            }
            if (item instanceof yh) {
                sb2.append(": * {");
            } else {
                sb2.append(": " + item.getNumSubtypes() + " {");
            }
            ArrayList list = new ArrayList();
            item.a(item.cv, null, list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ye item_stack = (ye)iterator.next();
                sb2.append(item_stack.getNameForReferenceFile());
                if (!iterator.hasNext()) continue;
                sb2.append(", ");
            }
            sb2.append("}" + newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getItemMaterialsString(ye item_stack, boolean as_subtype) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Item[" + item_stack.d + "]");
        sb2.append(as_subtype ? "[" + item_stack.getItemSubtype() + "] " : " ");
        sb2.append(item_stack.getNameForReferenceFile());
        yc item = item_stack.b();
        sb2.append(": " + (item.materials.size() == 0 ? "null" : StringHelper.getCommaSeparatedList(akc.getMaterialNames(item.materials))));
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeItemMaterialFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/item_material.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Some items have more than one material." + newline + newline);
        sb2.append("Item Material" + newline);
        sb2.append("-------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (item == null) continue;
            List sub_items = item.getSubItems();
            ye item_stack2 = (ye)sub_items.get(0);
            if (sub_items.size() == 1 && item_stack2.getItemSubtype() == 0) {
                sb2.append(ReferenceFileWriter.getItemMaterialsString(item_stack2, false));
                continue;
            }
            for (ye item_stack2 : sub_items) {
                sb2.append(ReferenceFileWriter.getItemMaterialsString(item_stack2, true));
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeItemDurabilityFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/item_durability.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Tools have their own specific decay rates vs blocks and entities. See tool decay rate files for more information." + newline + newline);
        sb2.append("Item Durability" + newline);
        sb2.append("---------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (item == null || !item.p()) continue;
            sb2.append("Item[" + i2 + "] ");
            sb2.append(item.getNameForReferenceFile());
            if (item.hasQuality()) {
                sb2.append(" (" + item.getDefaultQuality().getUnlocalizedName() + ")" + ": " + item.getMaxDamage(item.getDefaultQuality()));
            } else {
                sb2.append(": " + item.getMaxDamage(EnumQuality.average));
            }
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeItemBurnTimeFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/item_burn_time.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Only items that can be burned in a furnace are listed." + newline + newline);
        sb2.append("Item Burn Time" + newline);
        sb2.append("--------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (item == null || item.getBurnTime(null) <= 0) continue;
            int num_subtypes = item.getNumSubtypes();
            if (item instanceof yh) {
                ye item_stack = new ye(item, 1, 0);
                sb2.append("Item[" + i2 + "][*] ");
                sb2.append(item_stack.getNameForReferenceFile());
                sb2.append(": " + item.getBurnTime(item_stack) + " ticks @ heat level " + item.getHeatLevel(item_stack));
                sb2.append(newline);
                continue;
            }
            if (num_subtypes == 0) {
                sb2.append("Item[" + i2 + "] ");
                sb2.append(item.getNameForReferenceFile());
                sb2.append(": " + item.getBurnTime(null) + " ticks @ heat level " + item.getHeatLevel(null));
                sb2.append(newline);
                continue;
            }
            for (int subtype = 0; subtype < num_subtypes; ++subtype) {
                ye item_stack = new ye(item, 1, subtype);
                sb2.append("Item[" + i2 + "][" + subtype + "] ");
                sb2.append(item_stack.getNameForReferenceFile());
                sb2.append(": " + item.getBurnTime(item_stack) + " ticks @ heat level " + item.getHeatLevel(item_stack));
                sb2.append(newline);
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getItemCompostingLine(ye item_stack) {
        String line = new String();
        line = line + "Item[" + item_stack.d + "]";
        line = line + (item_stack.b() instanceof yh ? "[*] " : (item_stack.h() ? "[" + item_stack.getItemSubtype() + "] " : " "));
        line = line + StringHelper.repeat(" ", 16 - line.length());
        line = line + item_stack.getNameForReferenceFile();
        line = line + StringHelper.repeat(" ", 42 - line.length());
        line = line + StringHelper.formatFloat(item_stack.b().getCompostingValue(), 1, 1);
        yc item = item_stack.b().getCompostingRemains(item_stack);
        if (item != null) {
            line = line + " + " + item.getNameForReferenceFile();
        }
        if (item_stack.d == aqz.bk.cF) {
            line = line + " + " + yc.getItem(aqz.av).getNameForReferenceFile();
        }
        line = line + newline;
        return line;
    }

    private static void writeItemCompostingFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/item_composting.txt");
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Only items that can be composted by worms are listed." + newline + newline);
        sb2.append("Item ID         Description               Composting Value" + newline);
        sb2.append("-------         -----------               ----------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            ye item_stack;
            yc item = yc.getItem(i2);
            if (item == null) continue;
            List sub_items = item.getSubItems();
            if (item instanceof yh) {
                item_stack = new ye(item, 1, 0);
                if (!item_stack.canBeCompostedByWorms()) continue;
                sb2.append(ReferenceFileWriter.getItemCompostingLine(item_stack).toString());
                continue;
            }
            if (sub_items.size() == 0) {
                item_stack = new ye(item);
                if (!item_stack.canBeCompostedByWorms()) continue;
                sb2.append(ReferenceFileWriter.getItemCompostingLine(item_stack).toString());
                continue;
            }
            for (ye item_stack2 : sub_items) {
                if (!item_stack2.canBeCompostedByWorms()) continue;
                sb2.append(ReferenceFileWriter.getItemCompostingLine(item_stack2).toString());
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getRecipeString(yc item, int recipe_index) {
        aah recipe = item.recipes[recipe_index];
        if (recipe == null) {
            return "null";
        }
        StringBuffer sb2 = new StringBuffer();
        ye output = recipe.b();
        sb2.append(output.getNameForReferenceFile() + (output.b == 1 ? "" : " x" + output.b) + ": {");
        ye[] components = recipe.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            if (components[i2] == null) continue;
            if (components[i2].b().doesSubtypeMatterForProduct(output) || components[i2].b() instanceof wt) {
                sb2.append(components[i2].getNameForReferenceFile());
            } else {
                sb2.append(components[i2].b().getNameForReferenceFile());
            }
            sb2.append(", ");
        }
        String s2 = sb2.toString();
        sb2 = new StringBuffer(s2.substring(0, s2.length() - 2) + "}, difficulty = " + ReferenceFileWriter.formatFloat(recipe.getUnmodifiedDifficulty()));
        if (output.b > 1) {
            sb2.append(" (" + ReferenceFileWriter.formatFloat(recipe.getUnmodifiedDifficulty() / (float)output.b) + " per unit)");
        }
        if (recipe.getSkillsets() != null) {
            sb2.append(" (" + Skill.getSkillsetsString(recipe.getSkillsets(), false) + (output.b().hasQuality() ? " for average quality or better" : "") + ")");
        }
        return sb2.toString();
    }

    private static void writeItemRecipesFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/item_recipes.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Crafting difficulty is the number of ticks taken to craft an item from start to finish." + newline + newline);
        sb2.append("If crafting difficulty is higher than 100 then ticks required is fitted to the curve:" + newline + newline);
        sb2.append("   crafting_ticks = ((crafting_difficulty - 100) ^ 0.8) + 100" + newline + newline);
        sb2.append("Twenty ticks are performed each second." + newline + newline);
        sb2.append("Item Recipes" + newline);
        sb2.append("------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (item == null || !item.isCraftingProduct()) continue;
            sb2.append("Item[" + i2 + "] ");
            if (item.num_recipes == 1) {
                sb2.append(ReferenceFileWriter.getRecipeString(item, 0));
            } else {
                sb2.append("Has " + item.num_recipes + " recipes:");
                for (int recipe_index = 0; recipe_index < item.num_recipes; ++recipe_index) {
                    sb2.append(newline + "  Recipe[" + recipe_index + "] " + ReferenceFileWriter.getRecipeString(item, recipe_index));
                    aah recipe = item.recipes[recipe_index];
                    float difficulty = recipe.getUnmodifiedDifficulty() / (float)recipe.b().b;
                }
                if (item.isRepairable()) {
                    sb2.append(newline + "  Difficulty used for repairs = " + ReferenceFileWriter.formatFloat(item.getLowestCraftingDifficultyToProduce()));
                }
            }
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeFurnaceRecipesFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/furnace_recipes.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Furnace Recipes" + newline);
        sb2.append("---------------" + newline);
        boolean sandstone_done = false;
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            int[] skillsets;
            ye result = aab.a().getSmeltingResult(new ye(i2), -1);
            if (i2 == aqz.J.cF) {
                result = aab.a().getSmeltingResult(new ye(i2, sandstone_done ? 4 : 4), sandstone_done ? 2 : 1);
            }
            if (result == null) continue;
            yc item = yc.getItem(i2);
            sb2.append(item);
            if (i2 == aqz.J.cF && !sandstone_done) {
                sb2.append(" x4");
            }
            if (i2 == aqz.J.cF && sandstone_done) {
                sb2.append(" x4");
            }
            sb2.append(" @ ");
            sb2.append(asg.getHeatLevelRequired(i2) + (i2 == aqz.J.cF && sandstone_done ? 1 : 0));
            sb2.append(" = ");
            sb2.append(result.getNameForReferenceFile());
            if (result.b != 1) {
                sb2.append(" x" + result.b);
            }
            if ((skillsets = asg.getSkillsetsThatCanSmelt(item)) != null) {
                sb2.append(" (" + Skill.getSkillsetsString(skillsets, false) + ")");
            }
            sb2.append(newline);
            if (i2 != aqz.J.cF || sandstone_done) continue;
            sandstone_done = true;
            --i2;
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getXpCostForQualityString(yc item) {
        StringBuffer sb2 = new StringBuffer();
        for (int i2 = EnumQuality.fine.ordinal(); i2 <= item.getMaxQuality().ordinal(); ++i2) {
            int cost;
            EnumQuality quality = EnumQuality.get(i2);
            sb2.append(StringHelper.capitalize(quality.getUnlocalizedName()) + "=");
            if (quality.isAverageOrLower()) {
                cost = 0;
            } else {
                float quality_adjusted_crafting_difficulty = CraftingResult.getQualityAdjustedDifficulty(item.getLowestCraftingDifficultyToProduce(), quality);
                cost = Math.round(quality_adjusted_crafting_difficulty / 5.0f);
            }
            sb2.append(cost);
            sb2.append(", ");
        }
        String s2 = sb2.toString();
        return s2.isEmpty() ? s2 : StringHelper.left(s2, -2);
    }

    private static void writeItemXpReqsFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/item_xp_reqs.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Experience Requirements for Item Crafting & Repairing" + newline);
        sb2.append("-----------------------------------------------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (item == null || !item.isCraftingProduct() || !item.hasQuality() || !item.getMaxQuality().isHigherThan(EnumQuality.average)) continue;
            sb2.append("Item[" + i2 + "] ");
            sb2.append(item.getNameForReferenceFile() + ": ");
            sb2.append(ReferenceFileWriter.getXpCostForQualityString(item));
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeFoodValueFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/food_value.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Food Value (satiation, nutrition, protein, phytonutrients, IR=Insulin Response)" + newline);
        sb2.append("----------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (item == null || !item.isIngestable(0)) continue;
            sb2.append("Item[" + i2 + "] ");
            sb2.append(item.getNameForReferenceFile() + ": " + item.getSatiation(null) + ", " + item.getNutrition());
            sb2.append(", " + item.getProtein() + ", " + item.getPhytonutrients());
            int insulin_response = item.getInsulinResponse();
            if (insulin_response > 0) {
                sb2.append(" IR=" + insulin_response);
            }
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeItemReachFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/item_reach.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("The player has a base reach of " + StringHelper.formatFloat(2.75f, 1, 2) + " vs blocks and " + StringHelper.formatFloat(1.5f, 1, 2) + " vs entities." + newline + newline);
        sb2.append("Only items that have a reach bonus are listed." + newline + newline);
        sb2.append("Reach Bonus" + newline);
        sb2.append("-----------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            float reach_bonus;
            yc item = yc.getItem(i2);
            if (item == null) continue;
            String name = item.getNameForReferenceFile();
            if (item instanceof xj) {
                xj tool = (xj)item;
                if (tool.getToolMaterial() != akc.f && !(tool instanceof ItemCudgel)) continue;
                name = name.substring(tool.getToolMaterial() == akc.f ? 5 : 7);
            }
            if (!((reach_bonus = item.getReachBonus()) > 0.0f)) continue;
            sb2.append("Item[" + i2 + "] ");
            sb2.append(name + ": +" + StringHelper.formatFloat(reach_bonus, 1, 3));
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeDamageVsEntityFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/damage_vs_entity.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Damage vs Entity" + newline);
        sb2.append("----------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (!(item instanceof xj)) continue;
            xj item_tool = (xj)item;
            sb2.append("Item[" + i2 + "] ");
            sb2.append(item.getNameForReferenceFile() + ": +" + (int)item_tool.getCombinedDamageVsEntity());
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeArmorProtectionFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/armor_protection.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("A total armor score of 20 is considered complete protection. Note that non-zero damage always results in at least half a heart of damage." + newline + newline);
        sb2.append("Armor begins to lose its protection value after falling below 50% durability." + newline + newline);
        sb2.append("Protection Values" + newline);
        sb2.append("-----------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (!(item instanceof wh)) continue;
            wh armor = (wh)item;
            sb2.append("Item[" + i2 + "] ");
            sb2.append(item.getNameForReferenceFile() + ": +" + StringHelper.formatFloat(armor.getMultipliedProtection(null), 2, 2));
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeItemEnchantmentsFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/item_enchantments.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Item Enchantments" + newline);
        sb2.append("-----------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            yc item = yc.getItem(i2);
            if (item == null || item.c() <= 0) continue;
            String item_name = item.getNameForReferenceFile();
            if (item instanceof xj) {
                xj tool = (xj)item;
                if (tool instanceof ItemCudgel) {
                    item_name = StringHelper.capitalizeEachWord(tool.getToolType().replaceAll("_", " "));
                } else {
                    if (tool.getToolMaterial() != akc.f) continue;
                    item_name = tool instanceof ItemKnife || tool instanceof ItemHatchet || tool instanceof ya ? StringHelper.capitalizeEachWord((tool.getToolType() + " (metal)").replaceAll("_", " ")) : StringHelper.capitalizeEachWord(tool.getToolType().replaceAll("_", " "));
                }
            } else if (item instanceof wh) {
                wh armor = (wh)item;
                akc material = armor.getArmorMaterial();
                if (material != akc.leather && material != akc.f) continue;
                String disambiguation = material == akc.leather ? "leather" : (armor.isChainMail() ? "chain" : "metal");
                item_name = StringHelper.capitalizeEachWord((armor.getArmorType() + " (" + disambiguation + ")").replaceAll("_", " "));
            }
            if (item instanceof wp) {
                if (item != yc.bowMithril) continue;
                item_name = StringHelper.capitalizeEachWord("Bow");
            }
            if (item instanceof xv) {
                xv rod = (xv)item;
                if (rod.getHookMaterial() != akc.f) continue;
                String disambiguation = "metal";
                item_name = StringHelper.capitalizeEachWord(("Fishing Rod (" + disambiguation + ")").replaceAll("_", " "));
            }
            ArrayList<aau> possible_enchantments = new ArrayList<aau>();
            for (int enchantment_index = 0; enchantment_index < aau.b.length; ++enchantment_index) {
                aau enchantment = aau.get(enchantment_index);
                if (enchantment == null || !enchantment.canEnchantItem(item)) continue;
                possible_enchantments.add(enchantment);
            }
            if (possible_enchantments.size() <= 0) continue;
            sb2.append("Item[" + i2 + "] ");
            String[] names = new String[possible_enchantments.size()];
            for (int enchantment_index = 0; enchantment_index < possible_enchantments.size(); ++enchantment_index) {
                names[enchantment_index] = ((aau)possible_enchantments.get(enchantment_index)).getTranslatedName(item);
            }
            sb2.append(item_name + ": " + StringHelper.getCommaSeparatedList(names));
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeEnchantmentsFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/enchantments.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Enchantments" + newline);
        sb2.append("------------" + newline);
        for (int i2 = 0; i2 < aau.b.length; ++i2) {
            aau enchantment = aau.get(i2);
            if (enchantment == null) continue;
            sb2.append("Enchantment[" + i2 + "] ");
            sb2.append(enchantment + ": " + (Object)((Object)enchantment.rarity) + ", difficulty = " + enchantment.difficulty);
            if (enchantment.hasLevels()) {
                sb2.append(", " + enchantment.getNumLevels() + " levels");
            }
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getStackLimitString(ye item_stack, boolean as_subtype) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Item[" + item_stack.d + "]");
        sb2.append(as_subtype ? "[" + item_stack.getItemSubtype() + "] " : " ");
        sb2.append(item_stack.getNameForReferenceFile());
        sb2.append(": " + item_stack.e());
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeStackLimitsFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/stack_limits.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Stack Limits" + newline);
        sb2.append("------------" + newline);
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            boolean allowed_exception;
            yc item = yc.getItem(i2);
            if (item == null) continue;
            boolean bl2 = allowed_exception = item == yc.bf || item == yc.bI || item == yc.bW || item == yc.bY;
            if (item.y() == null && !allowed_exception) continue;
            List sub_items = item.getSubItems();
            ye item_stack2 = (ye)sub_items.get(0);
            if (sub_items.size() == 1 && item_stack2.getItemSubtype() == 0) {
                sb2.append(ReferenceFileWriter.getStackLimitString(item_stack2, false));
                continue;
            }
            for (ye item_stack2 : sub_items) {
                sb2.append(ReferenceFileWriter.getStackLimitString(item_stack2, true));
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeMaterialDurabilityFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/material_durability.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Material Durability" + newline);
        sb2.append("-------------------" + newline);
        for (int i2 = 0; i2 < akc.num_materials; ++i2) {
            akc material = akc.materials[i2];
            if (material == null || !(material.durability > 0.0f)) continue;
            sb2.append("Material[" + i2 + "] ");
            sb2.append(material.getCapitalizedName() + ": " + material.durability);
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeMaterialMaxQualityFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/material_max_quality.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Material Max Quality" + newline);
        sb2.append("--------------------" + newline);
        for (int i2 = 0; i2 < akc.num_materials; ++i2) {
            akc material = akc.materials[i2];
            if (material == null || !material.getMaxQuality().isLowerThan(EnumQuality.legendary) && material != akc.mithril && material != akc.adamantium) continue;
            sb2.append("Material[" + i2 + "] ");
            sb2.append(material.getCapitalizedName() + ": " + StringHelper.getFirstWord(material.getMaxQuality().getDescriptor()));
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeMaterialEnchantabilityFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/material_enchantability.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Materials not listed here are not enchantable." + newline + newline);
        sb2.append("Material Enchantability" + newline);
        sb2.append("-----------------------" + newline);
        for (int i2 = 0; i2 < akc.num_materials; ++i2) {
            akc material = akc.materials[i2];
            if (material == null || material.enchantability <= 0) continue;
            sb2.append("Material[" + i2 + "] ");
            sb2.append(material.getCapitalizedName() + ": " + material.enchantability);
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static String getToolDecayRateString(xj item_tool, ye item_stack, boolean as_subtype) {
        aqz block = item_stack.b().getAsItemBlock().getBlock();
        StringBuilder sb2 = new StringBuilder();
        int subtype = item_stack.getItemSubtype();
        sb2.append("Block[" + block.cF + "]");
        sb2.append(as_subtype ? "[" + subtype + "] " : " ");
        sb2.append(item_stack.getNameForReferenceFile());
        sb2.append(": " + item_tool.getToolDecayFromBreakingBlock(new BlockBreakInfo(block.cF, block instanceof anr ? 1 : subtype)));
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeToolDecayRateFiles(File dir) throws Exception {
        if (!(dir = new File(dir, "tool_decay_rates")).exists()) {
            dir.mkdir();
        }
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            xj item_tool;
            yc item = yc.getItem(i2);
            if (!(item instanceof xj) || (item_tool = (xj)item).getToolMaterial() != akc.adamantium) continue;
            FileWriter fw2 = new FileWriter(dir.getPath() + "/" + item_tool.getToolType() + ".txt");
            StringBuffer sb2 = new StringBuffer();
            sb2.append("Only the blocks that this tool is effective against are listed." + newline + newline);
            sb2.append("Decay Rate vs Entity" + newline);
            sb2.append("--------------------" + newline);
            sb2.append("General Factor: x" + ReferenceFileWriter.formatFloat(item_tool.getBaseDecayRateForAttackingEntity(null)) + newline);
            sb2.append("All: " + item_tool.getToolDecayFromAttackingEntity(null, null));
            sb2.append(newline + newline);
            sb2.append("Decay Rate vs Block" + newline);
            sb2.append("-------------------" + newline);
            sb2.append("General Factor: x" + ReferenceFileWriter.formatFloat(item_tool.getBaseDecayRateForBreakingBlock(null)) + newline);
            for (int block_index = 0; block_index < 256; ++block_index) {
                aqz block = aqz.s[block_index];
                if (block == null || !item_tool.isEffectiveAgainstBlock(block, 0)) continue;
                List list = block.getItemStacks();
                ye item_stack2 = (ye)list.get(0);
                if (list.size() == 1 && item_stack2.getItemSubtype() == 0) {
                    sb2.append(ReferenceFileWriter.getToolDecayRateString(item_tool, item_stack2, false));
                    continue;
                }
                for (ye item_stack2 : list) {
                    sb2.append(ReferenceFileWriter.getToolDecayRateString(item_tool, item_stack2, true));
                }
            }
            fw2.write(sb2.toString());
            fw2.close();
        }
    }

    private static String getToolHarvestEfficiencyString(xj item_tool, ye item_stack, boolean as_subtype) {
        aqz block = item_stack.b().getAsItemBlock().getBlock();
        StringBuilder sb2 = new StringBuilder();
        sb2.append("Block[" + block.cF + "]");
        sb2.append(as_subtype ? "[" + item_stack.getItemSubtype() + "] " : " ");
        sb2.append(item_stack.getNameForReferenceFile());
        sb2.append(": " + item_tool.getBaseHarvestEfficiency(block));
        sb2.append(newline);
        return sb2.toString();
    }

    private static void writeToolHarvestEfficiencyFiles(File dir) throws Exception {
        if (!(dir = new File(dir, "tool_harvest_efficiency")).exists()) {
            dir.mkdir();
        }
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            xj item_tool;
            yc item = yc.getItem(i2);
            if (!(item instanceof xj) || (item_tool = (xj)item).getToolMaterial() != akc.adamantium) continue;
            FileWriter fw2 = new FileWriter(dir.getPath() + "/" + item_tool.getToolType() + ".txt");
            StringBuffer sb2 = new StringBuffer();
            sb2.append("Only the blocks that this tool is effective against are listed." + newline + newline);
            sb2.append("Harvest Efficiency" + newline);
            sb2.append("------------------" + newline);
            for (int block_index = 0; block_index < 256; ++block_index) {
                aqz block = aqz.s[block_index];
                if (block == null || !item_tool.isEffectiveAgainstBlock(block, 0)) continue;
                List list = block.getItemStacks();
                ye item_stack2 = (ye)list.get(0);
                if (list.size() == 1 && item_stack2.getItemSubtype() == 0) {
                    sb2.append(ReferenceFileWriter.getToolHarvestEfficiencyString(item_tool, item_stack2, false));
                    continue;
                }
                for (ye item_stack2 : list) {
                    sb2.append(ReferenceFileWriter.getToolHarvestEfficiencyString(item_tool, item_stack2, true));
                }
            }
            fw2.write(sb2.toString());
            fw2.close();
        }
    }

    private static void writePlayerLevelsFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/player_levels.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("The modifier shown in the last column applies to harvesting speed, melee damage, and crafting time reduction." + newline + newline);
        sb2.append("Level          Experience          Stats          Harvesting          Crafting          Melee Dmg" + newline);
        sb2.append("-----          ----------          -----          ----------          --------          ---------" + newline);
        for (int level = -40; level <= uf.getHighestPossibleLevel(); ++level) {
            String line = new String();
            line = line + level;
            line = line + StringHelper.repeat(" ", 15 - line.length());
            line = line + uf.getExperienceRequired(level);
            line = line + StringHelper.repeat(" ", 35 - line.length());
            line = line + uf.getHealthLimit(level);
            line = line + StringHelper.repeat(" ", 50 - line.length());
            int level_modifier = Math.round(uf.getLevelModifier(level, EnumLevelBonus.HARVESTING) * 100.0f);
            if (level_modifier > 0) {
                line = line + "+";
            }
            line = line + level_modifier + "%";
            line = line + StringHelper.repeat(" ", 70 - line.length());
            level_modifier = Math.round(uf.getLevelModifier(level, EnumLevelBonus.CRAFTING) * 100.0f);
            if (level_modifier > 0) {
                line = line + "+";
            }
            line = line + level_modifier + "%";
            line = line + StringHelper.repeat(" ", 88 - line.length());
            level_modifier = Math.round(uf.getLevelModifier(level, EnumLevelBonus.MELEE_DAMAGE) * 100.0f);
            if (level_modifier > 0) {
                line = line + "+";
            }
            line = line + level_modifier + "%";
            sb2.append(line);
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeProfessionsFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/professions.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Player professions are only relevant in worlds that have professions enabled." + newline + newline);
        sb2.append("Profession     Skill                Description" + newline);
        sb2.append("----------     -----                -----------" + newline);
        for (int i2 = 0; i2 < Skill.getNumSkills(); ++i2) {
            Skill skill = Skill.list[i2];
            String line = new String();
            line = line + skill.getLocalizedName(true);
            line = line + StringHelper.repeat(" ", 15 - line.length());
            line = line + skill.getLocalizedName(false);
            line = line + StringHelper.repeat(" ", 36 - line.length());
            line = line + skill.getLocalizedDescription() + ".";
            sb2.append(line);
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeMobExperienceFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/mob_experience.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Only mobs that drop experience are listed here." + newline + newline);
        for (EntityListEntry entry : nt.entries) {
            int experience_value;
            if (!og.class.isAssignableFrom(entry._class) || Modifier.isAbstract(entry._class.getModifiers())) continue;
            og entity_living = (og)entry._class.getConstructor(abw.class).newInstance(new Object[]{null});
            if (entity_living instanceof EntityCubic) {
                ((EntityCubic)entity_living).setSize(4);
            }
            if ((experience_value = entity_living.getExperienceValue()) <= 0) continue;
            sb2.append("Entity[" + entry.id + "] " + entity_living.an() + ": " + experience_value);
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeCommandsFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/commands.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("These commands are available to all players." + newline + newline);
        for (int i2 = 0; i2 < EnumCommand.values().length; ++i2) {
            EnumCommand command = EnumCommand.values()[i2];
            sb2.append("/" + command.text + StringHelper.repeat(" ", 20 - command.text.length()) + command.description + newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    public static void write() {
        block6: {
            running = true;
            try {
                FileUtils.deleteDirectory((File)new File("reference"));
                FileUtils.deleteDirectory((File)new File("MITE/reference"));
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                File dir = new File("MITE/reference");
                if (!dir.exists()) {
                    dir.mkdir();
                }
                ReferenceFileWriter.writeBlockMaterialFile(dir);
                ReferenceFileWriter.writeBlockConstantsFile(dir);
                ReferenceFileWriter.writeBlockHardnessFile(dir);
                ReferenceFileWriter.writeBlockMetadataFile(dir);
                ReferenceFileWriter.writeBlockDissolveTimeFile(dir);
                ReferenceFileWriter.writeSilkHarvestFile(dir);
                ReferenceFileWriter.writeHarvestLevelFile(dir);
                ReferenceFileWriter.writeRecipeComponentsFile(dir);
                ReferenceFileWriter.writeItemSubtypesFile(dir);
                ReferenceFileWriter.writeItemMaterialFile(dir);
                ReferenceFileWriter.writeItemDurabilityFile(dir);
                ReferenceFileWriter.writeItemBurnTimeFile(dir);
                ReferenceFileWriter.writeItemCompostingFile(dir);
                ReferenceFileWriter.writeItemRecipesFile(dir);
                ReferenceFileWriter.writeFurnaceRecipesFile(dir);
                ReferenceFileWriter.writeItemXpReqsFile(dir);
                ReferenceFileWriter.writeFoodValueFile(dir);
                ReferenceFileWriter.writeItemReachFile(dir);
                ReferenceFileWriter.writeDamageVsEntityFile(dir);
                ReferenceFileWriter.writeArmorProtectionFile(dir);
                ReferenceFileWriter.writeEnchantmentsFile(dir);
                ReferenceFileWriter.writeItemEnchantmentsFile(dir);
                ReferenceFileWriter.writeStackLimitsFile(dir);
                ReferenceFileWriter.writeMaterialDurabilityFile(dir);
                ReferenceFileWriter.writeMaterialMaxQualityFile(dir);
                ReferenceFileWriter.writeMaterialEnchantabilityFile(dir);
                ReferenceFileWriter.writeToolDecayRateFiles(dir);
                ReferenceFileWriter.writeToolHarvestEfficiencyFiles(dir);
                ReferenceFileWriter.writePlayerLevelsFile(dir);
                ReferenceFileWriter.writeProfessionsFile(dir);
                ReferenceFileWriter.writeMobExperienceFile(dir);
                ReferenceFileWriter.writeCommandsFile(dir);
                if (atv.inDevMode()) {
                    ReferenceFileWriter.writeBlockOpacityFile(dir);
                    ReferenceFileWriter.writeIsOpaqueStandardFormCubeFile(dir);
                    ReferenceFileWriter.writeNormalCubeFile(dir);
                    ReferenceFileWriter.writeBlockMetadataToSubtypeFile(dir);
                    ReferenceFileWriter.writeAllowsGrassBeneathFile(dir);
                    ReferenceFileWriter.writeUseNeighborBrightnessFile(dir);
                    ReferenceFileWriter.writeBlockRenderTypeFile(dir);
                }
                System.out.println("Writing reference files... [ok]\n");
            }
            catch (Exception e3) {
                System.out.println("Writing reference files... [failed]\n");
                if (!atv.inDevMode()) break block6;
                e3.printStackTrace();
            }
        }
        running = false;
    }

    private static void writeBlockOpacityFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/block_opacity.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Block Opacity" + newline);
        sb2.append("-------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            sb2.append("Block[" + block.cF + "] ");
            sb2.append(block.getNameForReferenceFile(0, true) + ": " + aqz.u[block.cF]);
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeIsOpaqueStandardFormCubeFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/is_opaque_standard_form_cube.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Is Opaque Standard Form Cube" + newline);
        sb2.append("----------------------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            sb2.append("Block[" + block.cF + "] ");
            sb2.append(block.getNameForReferenceFile(0, true) + ": " + block.isAlwaysOpaqueStandardFormCube());
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeNormalCubeFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/normal_cube.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Normal Cube" + newline);
        sb2.append("-----------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            sb2.append("Block[" + block.cF + "] ");
            sb2.append(block.getNameForReferenceFile(0, true) + ": " + block.is_normal_cube);
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeBlockMetadataToSubtypeFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/block_metadata_to_subtype.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Metadata to Subtype" + newline);
        sb2.append("-------------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            for (int metadata = 0; metadata < 16; ++metadata) {
                if (!block.isValidMetadata(metadata)) continue;
                sb2.append("Block[" + block.cF + "][" + metadata + "] ");
                int block_subtype = block.getBlockSubtype(metadata);
                int item_subtype = block.getItemSubtype(metadata);
                if (block_subtype == item_subtype) {
                    sb2.append(block.getNameForReferenceFile(0, true) + ": " + block_subtype);
                } else {
                    sb2.append(block.getNameForReferenceFile(0, true) + ": " + block_subtype + " vs " + item_subtype);
                }
                sb2.append(newline);
            }
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeAllowsGrassBeneathFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/allows_grass_beneath.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Allows Grass Beneath" + newline);
        sb2.append("--------------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            sb2.append("Block[" + block.cF + "] ");
            sb2.append(block.getNameForReferenceFile(0, true) + ": " + aqz.canHaveLightValue[block.cF]);
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeUseNeighborBrightnessFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/use_neighbor_brightness.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Use Neighbor Brightness" + newline);
        sb2.append("-----------------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            sb2.append("Block[" + block.cF + "] ");
            sb2.append(block.getNameForReferenceFile(0, true) + ": " + aqz.x[block.cF]);
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }

    private static void writeBlockRenderTypeFile(File dir) throws Exception {
        FileWriter fw2 = new FileWriter(dir.getPath() + "/block_render_type.txt");
        StringBuffer sb2 = new StringBuffer();
        sb2.append("Block Render Type" + newline);
        sb2.append("-----------------" + newline);
        for (int i2 = 0; i2 < 256; ++i2) {
            aqz block = aqz.s[i2];
            if (block == null) continue;
            sb2.append("Block[" + block.cF + "] ");
            sb2.append(block.getNameForReferenceFile(0, true) + ": " + block.d());
            if (block.b()) {
                sb2.append(" as Normal Block");
            }
            sb2.append(", Pass " + block.n());
            sb2.append(newline);
        }
        fw2.write(sb2.toString());
        fw2.close();
    }
}

