/*
 * Decompiled with CFR 0.152.
 */
public class RecipeHelper {
    public static void addRecipe(aah recipe, boolean include_in_lowest_crafting_difficulty_determination) {
        float difficulty_per_unit;
        if (include_in_lowest_crafting_difficulty_determination) {
            recipe.setIncludeInLowestCraftingDifficultyDetermination();
        }
        ye[] recipe_items = recipe.getComponents();
        ye recipe_output = recipe.b();
        yc output_item = recipe_output.b();
        output_item.setAsCraftingProduct();
        output_item.recipes[output_item.num_recipes++] = recipe;
        float difficulty = 0.0f;
        for (int i2 = 0; i2 < recipe_items.length; ++i2) {
            ye item_stack = recipe_items[i2];
            if (item_stack == null) continue;
            yc item = item_stack.b();
            if (!item.n() || item_stack.getItemSubtype() == Short.MAX_VALUE) {
                item.setAsComponentOfCraftingProduct(recipe_output);
            } else {
                item_stack.setAsComponentOfCraftingProduct(recipe_output);
            }
            float component_difficulty = item_stack.getCraftingDifficultyAsComponent();
            if (component_difficulty < 0.0f) {
                yc peer;
                float lowest_crafting_difficulty_to_produce = item_stack.b().getLowestCraftingDifficultyToProduce();
                if (lowest_crafting_difficulty_to_produce != Float.MAX_VALUE) {
                    item_stack.b().setCraftingDifficultyAsComponent(lowest_crafting_difficulty_to_produce);
                    component_difficulty = lowest_crafting_difficulty_to_produce;
                } else if (item.hasMaterial(akc.rusted_iron) && (peer = yc.getMatchingItem(item.getClass(), akc.copper)) != null) {
                    if (item.getMaterialForDurability() == null) {
                        atv.setErrorMessage("addRecipe: getMaterialForDurability()==null for component " + item);
                    }
                    item.setCraftingDifficultyAsComponent(peer.getCraftingDifficultyAsComponent(null) * item.getMaterialForDurability().durability / peer.getMaterialForDurability().durability);
                    component_difficulty = item.getCraftingDifficultyAsComponent(null);
                }
            }
            if (component_difficulty < 0.0f) {
                atv.setErrorMessage("Warning: recipe for " + recipe_output.s() + ", component crafting difficulty not set: " + item_stack.b().l(item_stack) + " [" + (item_stack.d - 256) + "]");
                continue;
            }
            difficulty += component_difficulty;
        }
        if (difficulty < 0.0f) {
            atv.setErrorMessage("addRecipe: recipe output cannot have a crafting difficulty < 0.0F");
        }
        recipe.setDifficulty(difficulty);
        if (recipe_output.b < 1) {
            atv.setErrorMessage("stackSize is 0 for recipe output (" + recipe_output.s() + ")");
            difficulty_per_unit = difficulty;
        } else {
            difficulty_per_unit = difficulty / (float)recipe_output.b;
        }
        ye output_item_stack = recipe.b();
        if (output_item_stack != null) {
            akc tool_material;
            output_item = output_item_stack.b();
            if (output_item.containsMetal()) {
                if (output_item instanceof ItemIngot) {
                    return;
                }
                if (output_item.getClass() == ItemKnife.class) {
                    return;
                }
                if (output_item.getClass() == wr.class && RecipeHelper.hasAsComponent(recipe, wr.class)) {
                    return;
                }
                recipe.setMaterialToCheckToolBenchHardnessAgainst(output_item.getHardestMetalMaterial());
            } else if (output_item.cv == aqz.C.cF) {
                recipe.setMaterialToCheckToolBenchHardnessAgainst(akc.d);
            } else if (output_item.cv == aqz.aD.cF && (tool_material = arv.getToolMaterial(output_item_stack.getItemSubtype())).isMetal()) {
                akc next_strongest_material = null;
                float highest_durability_that_is_less_than_tool_material = 0.0f;
                for (int i3 = 0; i3 < arv.tool_materials.length; ++i3) {
                    akc material = arv.tool_materials[i3];
                    if (material == akc.obsidian || !(material.durability < tool_material.durability) || !(material.durability > highest_durability_that_is_less_than_tool_material)) continue;
                    next_strongest_material = material;
                    highest_durability_that_is_less_than_tool_material = material.durability;
                }
                recipe.setMaterialToCheckToolBenchHardnessAgainst(next_strongest_material);
            }
        }
    }

    public static boolean hasAsComponent(aah recipe, ye item_stack) {
        ye[] components = recipe.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            if (!ye.areItemStacksEqual(components[i2], item_stack, true, true, true, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAsComponent(aah recipe, Class item_class) {
        ye[] components = recipe.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            ye item_stack = components[i2];
            if (item_stack == null || item_stack.b().getClass() != item_class) continue;
            return true;
        }
        return false;
    }
}

