/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Random;

public class MapGenCaveNetwork
extends aer {
    protected int a = 3;
    private CaveNetworkStub stub;
    public final HashMap cached_stubs = new HashMap();
    public final HashMap cached_cave_network_generators = new HashMap();

    @Override
    public void a(ado chunk_provider, abw world, int chunk_x, int chunk_z, byte[] block_ids) {
        CaveNetworkStub stub = this.getCaveNetworkStubAt(world, chunk_x, chunk_z);
        if (stub == null) {
            return;
        }
        this.generateCaveNetwork(chunk_x, chunk_z, block_ids, stub);
    }

    private void generateCaveNetwork(int chunk_x, int chunk_z, byte[] block_ids, CaveNetworkStub stub) {
        int hash = stub.getOriginChunkCoordsHash();
        CaveNetworkGenerator cg2 = (CaveNetworkGenerator)this.cached_cave_network_generators.get(hash);
        if (cg2 == null || cg2.getOriginChunkX() != stub.getOriginChunkX() || cg2.getOriginChunkZ() != stub.getOriginChunkZ()) {
            if (cg2 != null) {
                Debug.setErrorMessage("generateCaveNetwork: hash collision");
            }
            cg2 = new CaveNetworkGenerator(stub);
            this.cached_cave_network_generators.put(hash, cg2);
        }
        cg2.apply(chunk_x, chunk_z, stub.getOriginChunkX(), stub.getOriginChunkZ(), block_ids);
    }

    private CaveNetworkStub getOrCreateCaveNetworkStub(abw world, int origin_chunk_x, int origin_chunk_z, double distance_from_world_origin) {
        int hash = adr.getChunkCoordsHash(origin_chunk_x, origin_chunk_z);
        CaveNetworkStub stub = (CaveNetworkStub)this.cached_stubs.get(hash);
        if (stub == null || stub.getOriginChunkX() != origin_chunk_x || stub.getOriginChunkZ() != origin_chunk_z) {
            if (stub != null) {
                Debug.setErrorMessage("getOrCreateCaveNetworkStub: hash collision");
            }
            boolean has_mycelium = distance_from_world_origin >= 1500.0 && this.b.nextInt(8) == 0;
            long seed = this.b.nextLong();
            if (world.H() == 1L && origin_chunk_x == -14 && origin_chunk_z == 29) {
                seed = 2617667064333438329L;
            }
            stub = new CaveNetworkStub(origin_chunk_x, origin_chunk_z, 64, 48, 64, seed, has_mycelium, this.b.nextInt(3) > 0, this.b.nextInt(3) > 0);
            this.cached_stubs.put(hash, stub);
        }
        return stub;
    }

    public boolean isOriginOfCaveNetwork(abw world, int chunk_x, int chunk_z) {
        if (!this.isGenAllowedInChunk(world, chunk_x, chunk_z)) {
            return false;
        }
        this.c = world;
        this.b.setSeed(world.H());
        long seed_a = this.b.nextLong();
        long seed_b = this.b.nextLong();
        long seed_c = (long)chunk_x * seed_a;
        long seed_d = (long)chunk_z * seed_b;
        long chunk_seed = seed_c ^ seed_d ^ world.H();
        this.b.setSeed(chunk_seed);
        this.random_number_index = (int)chunk_seed & Short.MAX_VALUE;
        double distance_from_world_origin = world.getDistanceFromWorldOrigin(chunk_x * 16, chunk_z * 16);
        if (world.H() == 1L && chunk_x == -14 && chunk_z == 29) {
            this.stub = this.getOrCreateCaveNetworkStub(world, chunk_x, chunk_z, distance_from_world_origin);
            return true;
        }
        if (distance_from_world_origin >= 1000.0 && this.b.nextInt(200) == 0) {
            Random rand = this.b;
            this.b = new Random();
            for (int origin_chunk_x = chunk_x + 1; origin_chunk_x <= chunk_x + this.a; ++origin_chunk_x) {
                for (int origin_chunk_z = chunk_z + 1; origin_chunk_z <= chunk_z + this.a; ++origin_chunk_z) {
                    if (!this.isGenAllowedInChunk(world, origin_chunk_x, origin_chunk_z)) {
                        return false;
                    }
                    if (!this.isOriginOfCaveNetwork(world, origin_chunk_x, origin_chunk_z)) continue;
                    return false;
                }
            }
            this.b = rand;
            this.stub = this.getOrCreateCaveNetworkStub(world, chunk_x, chunk_z, distance_from_world_origin);
            return true;
        }
        return false;
    }

    public CaveNetworkStub getCaveNetworkStubAt(abw world, int chunk_x, int chunk_z) {
        if (!this.isGenAllowedInChunk(world, chunk_x, chunk_z)) {
            return null;
        }
        for (int origin_chunk_x = chunk_x - this.a; origin_chunk_x <= chunk_x; ++origin_chunk_x) {
            for (int origin_chunk_z = chunk_z - this.a; origin_chunk_z <= chunk_z; ++origin_chunk_z) {
                if (!this.isOriginOfCaveNetwork(world, origin_chunk_x, origin_chunk_z)) continue;
                return this.stub;
            }
        }
        return null;
    }

    @Override
    public boolean isGenAllowedInBiome(acq biome) {
        return biome != acq.b;
    }
}

