/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

class GetPublicServers
extends Thread {
    GetPublicServers() {
    }

    @Override
    public void run() {
        String url_string;
        File dir = new File("MITE/public_servers");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if ((url_string = ClientProperties.getPublicServersUpdateURL()) == null || url_string.isEmpty()) {
            if (atv.inDevMode()) {
                System.out.println("Skipping update of public_servers.txt");
            }
            return;
        }
        String filepath = "MITE/public_servers/public_servers.txt";
        String temp_filepath = filepath + ".temp";
        if (!CopyFileFromURL.areMD5sTheSame(filepath, url_string)) {
            CopyFileFromURL.copyFileFromURL(url_string, temp_filepath, 2000, 2000);
        } else if (atv.inDevMode()) {
            System.out.println("Remote copy of public_servers.txt has same MD5 as local copy, skipping download");
        }
        File temp_file = new File(temp_filepath);
        File file = new File(filepath);
        if (temp_file.exists()) {
            boolean valid_format = true;
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(new File(temp_filepath)));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("server_address")) continue;
                    valid_format = false;
                    break;
                }
                br.close();
            }
            catch (Exception e) {
                valid_format = false;
            }
            if (valid_format) {
                CopyFileFromURL.overwriteFileIfNotSameAsTemp(file, temp_file);
            } else {
                FileUtils.deleteQuietly((File)temp_file);
                if (atv.inDevMode()) {
                    System.out.println("Downloaded copy of public_servers.txt has unexpected format, skipping update");
                }
            }
        }
        if (file.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(new File(filepath)));
                while ((line = br.readLine()) != null) {
                    String image_url;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || (image_url = new KeyedValuesString(line).getValue("image_url", true)) == null) continue;
                    String filename = FilenameUtils.getName((String)image_url);
                    CopyFileFromURL thread = new CopyFileFromURL(image_url, "MITE/public_servers/" + filename, 2000, 2000, true);
                    thread.setDaemon(true);
                    thread.setName("CopyFileFromURL: " + filename);
                    thread.start();
                }
                br.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

