/*
 * Decompiled with CFR 0.152.
 */
public enum EnumFace {
    BOTTOM,
    TOP,
    NORTH,
    SOUTH,
    WEST,
    EAST;


    public static boolean isValidOrdinal(int ordinal) {
        return ordinal >= 0 && ordinal < EnumFace.values().length;
    }

    public static EnumFace get(int ordinal) {
        return EnumFace.values()[ordinal];
    }

    public boolean isBottom() {
        return this == BOTTOM;
    }

    public boolean isTop() {
        return this == TOP;
    }

    public boolean isNorth() {
        return this == NORTH;
    }

    public boolean isSouth() {
        return this == SOUTH;
    }

    public boolean isWest() {
        return this == WEST;
    }

    public boolean isEast() {
        return this == EAST;
    }

    public boolean isTopOrBottom() {
        return this == TOP || this == BOTTOM;
    }

    public boolean isSide() {
        return this == NORTH || this == SOUTH || this == WEST || this == EAST;
    }

    public boolean isNorthOrSouth() {
        return this == NORTH || this == SOUTH;
    }

    public boolean isEastOrWest() {
        return this == EAST || this == WEST;
    }

    public int getNeighborX(int x) {
        return this == WEST ? x - 1 : (this == EAST ? x + 1 : x);
    }

    public int getNeighborY(int y2) {
        return this == BOTTOM ? y2 - 1 : (this == TOP ? y2 + 1 : y2);
    }

    public int getNeighborZ(int z2) {
        return this == NORTH ? z2 - 1 : (this == SOUTH ? z2 + 1 : z2);
    }

    public EnumFace getOpposite() {
        if (this == BOTTOM) {
            return TOP;
        }
        if (this == TOP) {
            return BOTTOM;
        }
        if (this == NORTH) {
            return SOUTH;
        }
        if (this == SOUTH) {
            return NORTH;
        }
        if (this == WEST) {
            return EAST;
        }
        return WEST;
    }

    public EnumDirection getNormal() {
        if (this == BOTTOM) {
            return EnumDirection.DOWN;
        }
        if (this == TOP) {
            return EnumDirection.UP;
        }
        if (this == NORTH) {
            return EnumDirection.NORTH;
        }
        if (this == SOUTH) {
            return EnumDirection.SOUTH;
        }
        if (this == WEST) {
            return EnumDirection.WEST;
        }
        return EnumDirection.EAST;
    }

    public EnumDirection getAntiNormal() {
        if (this == BOTTOM) {
            return EnumDirection.UP;
        }
        if (this == TOP) {
            return EnumDirection.DOWN;
        }
        if (this == NORTH) {
            return EnumDirection.SOUTH;
        }
        if (this == SOUTH) {
            return EnumDirection.NORTH;
        }
        if (this == WEST) {
            return EnumDirection.EAST;
        }
        return EnumDirection.WEST;
    }

    public String getDescriptor(boolean capitalized) {
        return capitalized ? StringHelper.capitalize(this.name().toLowerCase()) : this.name().toLowerCase();
    }
}

