/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

public abstract class EntityLivestock
extends rp {
    private float food;
    private float water;
    private float freedom;
    protected int data_object_id_is_well;
    protected int data_object_id_is_thirsty;
    protected int production_counter;
    private int manure_period;
    private int manure_countdown;
    public int last_trampled_x;
    public int last_trampled_y;
    public int last_trampled_z;
    public boolean has_been_spooked_by_other_animal;

    public EntityLivestock(abw world) {
        super(world);
        this.c.a(2, new EntityAISeekFoodIfHungry(this, 1.0f, true));
        this.c.a(2, new EntityAISeekWaterIfThirsty(this, 1.0f, false));
        this.c.a(3, new EntityAISeekOpenSpaceIfCrowded(this, 1.0f));
        this.c.a(2, new EntityAIAvoidPotentialPredators(this, 1.0f, true));
        this.c.a(4, new EntityAISeekShelterFromRain(this, 1.0f, true));
        this.c.a(4, new EntityAIGetOutOfWater(this, 1.0f));
        if (world != null && !world.I) {
            this.setFood(0.8f + this.ab.nextFloat() * 0.2f);
            this.setWater(0.8f + this.ab.nextFloat() * 0.2f);
            this.setFreedom(0.8f + this.ab.nextFloat() * 0.2f);
            this.setManurePeriod(24000);
        }
    }

    @Override
    protected void a() {
        super.a();
        this.data_object_id_is_well = this.ah.addObject(this.ah.getNextAvailableId(), new Byte(-1));
        this.data_object_id_is_thirsty = this.ah.addObject(this.ah.getNextAvailableId(), new Byte(0));
    }

    protected void setFood(float food) {
        if (this.q.I) {
            return;
        }
        this.food = ls.a(food, 0.0f, 1.0f);
        this.setIsWell(this.isWell());
    }

    protected void addFood(float food) {
        this.setFood(this.getFood() + food);
    }

    protected float getFood() {
        return this.food;
    }

    protected void setWater(float water) {
        if (this.q.I) {
            return;
        }
        this.water = ls.a(water, 0.0f, 1.0f);
        this.setIsWell(this.isWell());
        this.setIsThirsty(this.isThirsty());
    }

    protected void addWater(float water) {
        this.setWater(this.getWater() + water);
    }

    protected float getWater() {
        return this.water;
    }

    protected void setFreedom(float freedom) {
        if (this.q.I) {
            return;
        }
        this.freedom = ls.a(freedom, 0.0f, 1.0f);
        this.setIsWell(this.isWell());
    }

    protected void addFreedom(float freedom) {
        this.setFreedom(this.getFreedom() + freedom);
    }

    protected float getFreedom() {
        return this.freedom;
    }

    @Override
    public void b(by par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("food", this.getFood());
        par1NBTTagCompound.a("water", this.getWater());
        par1NBTTagCompound.a("freedom", this.getFreedom());
        par1NBTTagCompound.a("production_counter", this.production_counter);
        par1NBTTagCompound.a("manure_countdown", this.manure_countdown);
        par1NBTTagCompound.a("has_been_spooked_by_other_animal", this.has_been_spooked_by_other_animal);
    }

    @Override
    public void a(by par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.setFood(par1NBTTagCompound.g("food"));
        this.setWater(par1NBTTagCompound.g("water"));
        this.setFreedom(par1NBTTagCompound.g("freedom"));
        this.production_counter = par1NBTTagCompound.e("production_counter");
        this.manure_countdown = par1NBTTagCompound.e("manure_countdown");
        this.has_been_spooked_by_other_animal = par1NBTTagCompound.n("has_been_spooked_by_other_animal");
    }

    protected boolean setIsWell(boolean is_well) {
        this.ah.b(this.data_object_id_is_well, (byte)(is_well ? -1 : 0));
        return is_well;
    }

    public boolean isWell() {
        if (this.q.I) {
            return this.ah.a(this.data_object_id_is_well) != 0;
        }
        return Math.min(this.getFreedom(), Math.min(this.getFood(), this.getWater())) >= 0.25f;
    }

    protected boolean setIsThirsty(boolean is_thirsty) {
        this.ah.b(this.data_object_id_is_thirsty, (byte)(is_thirsty ? -1 : 0));
        return is_thirsty;
    }

    public boolean isThirsty() {
        if (this.q.I) {
            return this.ah.a(this.data_object_id_is_thirsty) != 0;
        }
        return this.getWater() < 0.5f;
    }

    public boolean isHungry() {
        return this.getFood() < 0.5f;
    }

    public boolean isVeryHungry() {
        return this.getFood() < 0.25f;
    }

    public boolean isDesperateForFood() {
        return this.getFood() < 0.05f;
    }

    public boolean isVeryThirsty() {
        return this.getWater() < 0.25f;
    }

    public boolean isDesperateForWater() {
        return this.getWater() < 0.05f;
    }

    public final boolean isNearFood() {
        return this.isNearFood(0.0f);
    }

    public final boolean isNearFood(float chance_of_destroying_food) {
        return this.isNearFood(ls.c(this.u), ls.c(this.v), ls.c(this.w), chance_of_destroying_food);
    }

    public final boolean isNearFood(int x, int y2, int z2) {
        return this.isNearFood(x, y2, z2, 0.0f);
    }

    public final boolean isNearFood(int x, int y2, int z2, float chance_of_destroying_food) {
        int height = ls.c((double)this.P);
        for (int dx2 = -1; dx2 <= 1; ++dx2) {
            for (int dy2 = -1; dy2 <= height; ++dy2) {
                for (int dz2 = -1; dz2 <= 1; ++dz2) {
                    if (!this.isFoodSource(this.q.a(x + dx2, y2 + dy2, z2 + dz2))) continue;
                    if (chance_of_destroying_food > 0.0f && this.ab.nextFloat() < chance_of_destroying_food) {
                        this.q.destroyBlock(new BlockBreakInfo(this.q, x + dx2, y2 + dy2, z2 + dz2).setEatenBy(this), false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isNearWaterSource() {
        return this.isNearWaterSource(ls.c(this.u), ls.c(this.v), ls.c(this.w));
    }

    public boolean isNearWaterSource(int x, int y2, int z2) {
        int height = ls.c((double)this.P);
        for (int dx2 = -1; dx2 <= 1; ++dx2) {
            for (int dy2 = -1; dy2 <= height; ++dy2) {
                for (int dz2 = -1; dz2 <= 1; ++dz2) {
                    if (!this.isWaterSource(x + dx2, y2 + dy2, z2 + dz2) || this.q.isBlockFaceFlatAndSolid(x + dx2, y2 + dy2 + 1, z2 + dz2, EnumFace.BOTTOM)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCrowded() {
        return !this.isOutdoors() || this.q.a(og.class, this.E.b(2.0, 0.5, 2.0)).size() > 2;
    }

    public boolean isCrowded(int x, int y2, int z2) {
        if (!this.q.isOutdoors(x, y2, z2)) {
            return true;
        }
        asx bounding_box = new asx(x - 2, (float)y2 - 0.5f, z2 - 2, x + 2, (float)y2 + 0.5f, z2 + 2);
        return this.q.a(og.class, bounding_box).size() > 2;
    }

    public boolean updateWellness() {
        float benefit = 0.1f;
        float penalty = -0.005f;
        if (this.isNearFood(this instanceof rr ? 0.01f : 0.0f)) {
            this.addFood(benefit);
        } else {
            this.addFood(penalty);
        }
        if (this.isNearWaterSource()) {
            this.addWater(benefit);
        } else if (this.isInRain()) {
            this.addWater(benefit / 10.0f);
        } else {
            this.addWater(penalty);
        }
        if (!this.isCrowded()) {
            this.addFreedom(benefit);
        } else {
            this.addFreedom(penalty);
        }
        return this.isWell();
    }

    @Override
    public void c() {
        super.c();
        if (!this.q.I) {
            if (this.ac % 100 == 0) {
                if (this.ab.nextInt(10) > 0 && this.updateWellness() && !this.g_()) {
                    ++this.production_counter;
                }
                this.produceGoods();
            }
            if (!this.g_()) {
                if (!this.isDesperateForFood() && --this.manure_countdown <= 0) {
                    this.b(yc.manure.cv, 1);
                    this.manure_countdown = this.manure_period / 2 + this.ab.nextInt(this.manure_period);
                }
                if (this.F) {
                    if (this.ac % 1000 == 0) {
                        this.last_trampled_z = 0;
                        this.last_trampled_y = 0;
                        this.last_trampled_x = 0;
                    }
                    int x = ls.c(this.u);
                    int y2 = ls.c(this.v) - 1;
                    int z2 = ls.c(this.w);
                    if (x != this.last_trampled_x || y2 != this.last_trampled_y || z2 != this.last_trampled_z) {
                        this.last_trampled_x = x;
                        this.last_trampled_y = y2;
                        this.last_trampled_z = z2;
                        aqz block = aqz.s[this.q.a(x, y2, z2)];
                        if (block != null) {
                            block.onTrampledBy(this.q, x, y2, z2, this);
                        }
                    }
                }
            }
            if (this.has_been_spooked_by_other_animal && this.q.total_time % 4000L == 0L) {
                this.has_been_spooked_by_other_animal = false;
            }
            if ((this.has_decided_to_flee || this.fleeing || this.isSpooked()) && this.getTicksExistedWithOffset() % 20 == 0) {
                List list = this.q.a(EntityLivestock.class, this.E.b(8.0, 4.0, 8.0));
                for (EntityLivestock livestock : list) {
                    if (livestock == this || livestock.has_decided_to_flee || livestock.fleeing || livestock.isSpooked() || livestock.has_been_spooked_by_other_animal || livestock.M || !livestock.canSeeEntity(this) || !livestock.canPathTo(this.getBlockPosX(), this.getFootBlockPosY(), this.getBlockPosZ(), 8)) continue;
                    livestock.spooked_until = this.q.I() + 400L + (long)this.q.s.nextInt(400);
                    livestock.has_been_spooked_by_other_animal = true;
                }
            }
        }
    }

    public abstract void produceGoods();

    protected boolean isFoodSource(int block_id) {
        aqz block = aqz.s[block_id];
        return block == aqz.z || block == aqz.ac;
    }

    public int[] getFoodBlockIDs() {
        int[] block_ids = new int[]{aqz.z.cF, aqz.ac.cF};
        return block_ids;
    }

    protected boolean isWaterSource(int x, int y2, int z2) {
        aqz block = aqz.s[this.q.a(x, y2, z2)];
        if (block == aqz.G || block == aqz.F || block == aqz.aX || block == aqz.aZ) {
            return true;
        }
        return block == aqz.bL && (double)(y2 + 1) < this.getEyePosY() && this.q.h(x, y2, z2) > 0;
    }

    public int[] getWaterBlockIDs() {
        int[] block_ids = new int[]{aqz.G.cF, aqz.F.cF, aqz.aX.cF, aqz.aZ.cF, aqz.bL.cF};
        return block_ids;
    }

    @Override
    public float a(int x, int y2, int z2) {
        int block_id = this.q.a(x, y2, z2);
        int block_id_below = this.q.a(x, y2 - 1, z2);
        if (this.isFoodSource(block_id) || this.isFoodSource(block_id_below) || this.isNearFood(x, y2, z2)) {
            return 20.0f;
        }
        if (!this.isWaterSource(x, y2, z2) && !this.isWaterSource(x, y2 - 1, z2) && this.isNearWaterSource(x, y2, z2)) {
            return 20.0f;
        }
        return super.a(x, y2, z2);
    }

    @Override
    public void onFoodEaten(ye item_stack) {
        if (!this.q.I) {
            this.addFood(0.5f);
        }
        super.onFoodEaten(item_stack);
    }

    @Override
    public void bX() {
        if (this.isWell()) {
            super.bX();
        }
    }

    @Override
    public boolean considerFleeing() {
        nn last_attacking_entity = this.getLastHarmingEntity();
        this.has_decided_to_flee = last_attacking_entity != null && this.d(last_attacking_entity) < 32.0f;
        return this.has_decided_to_flee;
    }

    @Override
    public boolean considerStopFleeing() {
        nn last_attacking_entity = this.getLastHarmingEntity();
        if (last_attacking_entity == null) {
            this.has_decided_to_flee = false;
            this.fleeing = false;
            return true;
        }
        if (this.d(last_attacking_entity) > 40.0f) {
            this.fleeing = false;
            return true;
        }
        return false;
    }

    public int getManurePeriod() {
        return this.manure_period;
    }

    public void setManurePeriod(int manure_period) {
        this.manure_period = manure_period;
        this.manure_countdown = (int)(Math.random() * (double)manure_period);
    }

    @Override
    public int getExperienceValue() {
        return 0;
    }

    @Override
    public void c(int par1) {
        if (this.g_() && par1 > this.b() && (this.isDesperateForFood() || this.isDesperateForWater())) {
            return;
        }
        super.c(par1);
    }

    public void adoptWellnessFromParents(rp parent_a, rp parent_b) {
        if (this.onClient()) {
            atv.setErrorMessage("adoptWellnessFromParents: cannot be called on client");
            return;
        }
        float food_parent_a = parent_a instanceof EntityLivestock ? ((EntityLivestock)parent_a).getFood() : 1.0f;
        float food_parent_b = parent_b instanceof EntityLivestock ? ((EntityLivestock)parent_b).getFood() : 1.0f;
        float water_parent_a = parent_a instanceof EntityLivestock ? ((EntityLivestock)parent_a).getWater() : 1.0f;
        float water_parent_b = parent_b instanceof EntityLivestock ? ((EntityLivestock)parent_b).getWater() : 1.0f;
        float freedom_parent_a = parent_a instanceof EntityLivestock ? ((EntityLivestock)parent_a).getFreedom() : 1.0f;
        float freedom_parent_b = parent_b instanceof EntityLivestock ? ((EntityLivestock)parent_b).getFreedom() : 1.0f;
        this.setFood(Math.min(food_parent_a, food_parent_b));
        this.setWater(Math.min(water_parent_a, water_parent_b));
        this.setFreedom(Math.min(freedom_parent_a, freedom_parent_b));
    }

    @Override
    public boolean willEat(ye item_stack) {
        if (this.hasFullHealth() && !this.isWell() && !this.isHungry()) {
            return false;
        }
        return super.willEat(item_stack);
    }
}

