/*
 * Decompiled with CFR 0.152.
 */
public class EntityAIAvoidFire
extends EntityAIMovementTask {
    private int max_path_length = 8;
    private final int max_fires = 16;
    private int num_fires;
    private int[] fire_x = new int[16];
    private int[] fire_y = new int[16];
    private int[] fire_z = new int[16];
    private double[] fire_distance_sq = new double[16];

    public EntityAIAvoidFire(og task_owner, float movement_speed, boolean swim_if_necessary) {
        super(task_owner, movement_speed, swim_if_necessary);
    }

    @Override
    public boolean a() {
        if (this.task_owner.ab.nextInt(10) > 0) {
            return false;
        }
        if (!this.task_owner.isHarmedByFire()) {
            return false;
        }
        return this.world.blockTypeIsNearTo(aqz.aw.cF, this.task_owner.u, this.task_owner.v, this.task_owner.w, this.max_path_length, this.max_path_length / 4);
    }

    double getDistanceSqToNearestFire(int x, int y2, int z2) {
        double distance_sq_to_nearest_fire = Double.MAX_VALUE;
        for (int i = 0; i < this.num_fires; ++i) {
            double distance_sq_to_fire = abw.getDistanceSqFromDeltas(x - this.fire_x[i], y2 - this.fire_y[i], z2 - this.fire_z[i]);
            if (!(distance_sq_to_fire < distance_sq_to_nearest_fire)) continue;
            distance_sq_to_nearest_fire = distance_sq_to_fire;
        }
        return distance_sq_to_nearest_fire;
    }

    @Override
    protected alf getMovementPath() {
        int[] block_ids = new int[]{aqz.aw.cF};
        this.num_fires = this.world.getNearestBlockCandidates(this.task_owner.u, this.task_owner.v + (double)(this.task_owner.P * 0.75f), this.task_owner.w, this.max_path_length * 2, this.max_path_length / 2, 16, block_ids, this.fire_x, this.fire_y, this.fire_z, this.fire_distance_sq);
        if (this.num_fires == 0) {
            return null;
        }
        int x = ls.c(this.task_owner.u);
        int y2 = ls.c(this.task_owner.v);
        int z2 = ls.c(this.task_owner.w);
        double longest_distance_sq_to_nearest_fire = this.getDistanceSqToNearestFire(x, y2, z2);
        alf selected_path = null;
        for (int attempt = 0; attempt < 16; ++attempt) {
            alf path;
            int i;
            int dx2 = RNG.int_max[++this.random_number_index & Short.MAX_VALUE] % (this.max_path_length * 2 + 1) - this.max_path_length;
            int dy2 = RNG.int_7_minus_3[++this.random_number_index & Short.MAX_VALUE];
            int dz2 = RNG.int_max[++this.random_number_index & Short.MAX_VALUE] % (this.max_path_length * 2 + 1) - this.max_path_length;
            int trial_x = x + dx2;
            int trial_y = y2 + dy2;
            int trial_z = z2 + dz2;
            for (i = 0; i < 8 && this.world.isAirOrPassableBlock(trial_x, trial_y - 1, trial_z, false); ++i) {
                --trial_y;
            }
            for (i = 0; i < 8 && !this.world.isAirOrPassableBlock(trial_x, trial_y, trial_z, false); ++i) {
                ++trial_y;
            }
            double distance_sq_to_nearest_fire = this.getDistanceSqToNearestFire(trial_x, trial_y, trial_z);
            if (!(distance_sq_to_nearest_fire > longest_distance_sq_to_nearest_fire) || (path = this.task_owner.k().getPathToXYZ(trial_x, trial_y, trial_z, this.max_path_length)) == null) continue;
            ale final_point = path.c();
            trial_x = final_point.a;
            trial_y = final_point.b;
            trial_z = final_point.c;
            distance_sq_to_nearest_fire = this.getDistanceSqToNearestFire(trial_x, trial_y, trial_z);
            if (!(distance_sq_to_nearest_fire > longest_distance_sq_to_nearest_fire)) continue;
            longest_distance_sq_to_nearest_fire = distance_sq_to_nearest_fire;
            selected_path = path;
        }
        return selected_path;
    }
}

