/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;

public class ClientProperties {
    private static ClientProperties instance;
    private int rendering_scheme;
    private boolean opportunity_chunk_rendering;
    private int forced_chunk_rendering_distance;
    private String public_servers_update_url;
    private static final int DEFAULT_RENDERING_SCHEME = 1;
    private static final boolean DEFAULT_OPPORTUNITY_CHUNK_RENDERING = true;
    private static final int DEFAULT_FORCED_CHUNK_RENDERING_DISTANCE = 1;
    private static final String DEFAULT_PUBLIC_SERVERS_UPDATE_URL = "http://minecraft-is-too-easy.com/public_servers/public_servers.txt";

    public ClientProperties(String filepath, lp log_agent) {
        this.readPropertiesFromFile(filepath, log_agent);
        if (instance != null) {
            atv.setErrorMessage("ClientProperties: instance already exists");
            new Exception().printStackTrace();
        }
        instance = this;
    }

    private void readPropertiesFromFile(String filepath, lp log_agent) {
        File file = new File(filepath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                log_agent.c("Unable to create " + filepath + " file!");
            }
        }
        log_agent.a("Loading " + filepath);
        hq settings = new hq(file, log_agent, "Minecraft client properties");
        this.rendering_scheme = settings.a("rendering-scheme", 1);
        RenderingScheme.setCurrent(this.rendering_scheme);
        this.opportunity_chunk_rendering = false;
        this.forced_chunk_rendering_distance = 1;
        this.public_servers_update_url = settings.a("public-servers-update-url", DEFAULT_PUBLIC_SERVERS_UPDATE_URL);
        settings.b();
    }

    public static boolean isOpportunityChunkRenderingEnabled() {
        return ClientProperties.instance.opportunity_chunk_rendering;
    }

    public static int getForcedChunkRenderingDistance() {
        return ClientProperties.instance.forced_chunk_rendering_distance;
    }

    public static String getPublicServersUpdateURL() {
        return ClientProperties.instance.public_servers_update_url;
    }
}

