/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class BlockBreakInfo {
    public abw world;
    public int x;
    public int y;
    public int z;
    public int block_id;
    public aqz block;
    public asp tile_entity;
    public EnumBlockBreakReason reason;
    private int metadata;
    public int neighbor_block_id;
    public aqz crushing_block;
    public apc flooding_block;
    public nn responsible_entity;
    public ye responsible_item_stack;
    public abr explosion;
    private boolean was_silk_harvested;
    public int damage;
    public int drop_x;
    public int drop_y;
    public int drop_z;
    private asx drop_bounds;
    private static asx drop_bounds_default = asx.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).scale(0.5);

    public BlockBreakInfo(abw world, int x, int y2, int z2) {
        if (world.I) {
            atv.setErrorMessage("BlockBreakInfo: Why creating this object on client?", true);
            new Exception().printStackTrace();
        }
        this.world = world;
        this.x = x;
        this.y = y2;
        this.z = z2;
        this.block_id = world.a(x, y2, z2);
        this.block = aqz.s[this.block_id];
        this.metadata = world.h(x, y2, z2);
        this.tile_entity = world.r(x, y2, z2);
        this.drop_x = x;
        this.drop_y = y2;
        this.drop_z = z2;
        this.drop_bounds = this.block == null ? drop_bounds_default : this.block.c_(world, x, y2, z2).translate(-x, -y2, -z2).scale(0.5);
    }

    public BlockBreakInfo(int block_id, int metadata) {
        this.block_id = block_id;
        this.block = aqz.getBlock(block_id);
        this.metadata = metadata;
    }

    public BlockBreakInfo setMetadata(int metadata) {
        this.metadata = metadata;
        return this;
    }

    public BlockBreakInfo setBlock(aqz block, int metadata) {
        this.block_id = block.cF;
        this.block = block;
        this.metadata = metadata;
        return this;
    }

    public BlockBreakInfo setBlock(aqz block, int metadata, int flags) {
        this.setBlock(block, metadata);
        this.world.f(this.x, this.y, this.z, block.cF, metadata, flags);
        return this;
    }

    public BlockBreakInfo setWasNotLegal() {
        this.reason = EnumBlockBreakReason.was_not_legal;
        return this;
    }

    public BlockBreakInfo setNeighborChanged(int neighbor_block_id) {
        this.reason = EnumBlockBreakReason.neighbor_changed;
        this.neighbor_block_id = neighbor_block_id;
        return this;
    }

    public BlockBreakInfo setReplaced() {
        this.reason = EnumBlockBreakReason.replaced;
        return this;
    }

    public BlockBreakInfo setFlooded(apc flooding_block) {
        this.reason = EnumBlockBreakReason.flooded;
        this.flooding_block = flooding_block;
        return this;
    }

    public BlockBreakInfo setHarvestedBy(of harvesting_entity) {
        this.reason = EnumBlockBreakReason.harvested;
        this.responsible_entity = harvesting_entity;
        this.responsible_item_stack = harvesting_entity.getHeldItemStack();
        if (this.block == null) {
            atv.setErrorMessage("setHarvestedBy: block is null (" + harvesting_entity.an() + ")");
            Debug.printStackTrace();
            return this;
        }
        this.was_silk_harvested = harvesting_entity instanceof of && harvesting_entity.getAsEntityLivingBase().canSilkHarvestBlock(this.block, this.metadata);
        return this;
    }

    public BlockBreakInfo setPickedBy(of picking_entity) {
        this.reason = EnumBlockBreakReason.picked;
        this.responsible_entity = picking_entity;
        if (this.block == null) {
            atv.setErrorMessage("setPickedBy: block is null (" + picking_entity.an() + ")");
            return this;
        }
        return this;
    }

    public BlockBreakInfo setTrampledBy(nn trampling_entity) {
        this.reason = EnumBlockBreakReason.trampled;
        this.responsible_entity = trampling_entity;
        return this;
    }

    public BlockBreakInfo setExploded(abr explosion) {
        this.reason = EnumBlockBreakReason.exploded;
        this.explosion = explosion;
        return this;
    }

    public BlockBreakInfo setDroppedSelf() {
        this.reason = EnumBlockBreakReason.self_dropped;
        return this;
    }

    public BlockBreakInfo setCrushed(aqz crushing_block) {
        this.reason = EnumBlockBreakReason.crushed;
        this.crushing_block = crushing_block;
        return this;
    }

    public BlockBreakInfo setEatenBy(nn entity) {
        this.reason = EnumBlockBreakReason.eaten;
        this.responsible_entity = entity;
        return this;
    }

    public BlockBreakInfo setCollidedWith(nn entity) {
        this.reason = EnumBlockBreakReason.collided_with_entity;
        this.responsible_entity = entity;
        return this;
    }

    public BlockBreakInfo setSilverfish(nn entity) {
        this.reason = EnumBlockBreakReason.silverfish;
        this.responsible_entity = entity;
        return this;
    }

    public BlockBreakInfo setDrought() {
        this.reason = EnumBlockBreakReason.drought;
        return this;
    }

    public BlockBreakInfo setSnowedUpon() {
        this.reason = EnumBlockBreakReason.snowfall;
        return this;
    }

    public BlockBreakInfo setDestroyedBy(nn entity) {
        this.reason = EnumBlockBreakReason.destroyed;
        this.responsible_entity = entity;
        return this;
    }

    public BlockBreakInfo setWindfall() {
        this.reason = EnumBlockBreakReason.windfall;
        return this;
    }

    public BlockBreakInfo setOther() {
        this.reason = EnumBlockBreakReason.other;
        return this;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public boolean wasNotLegal() {
        return this.reason == EnumBlockBreakReason.was_not_legal;
    }

    public boolean wasReplaced() {
        return this.reason == EnumBlockBreakReason.replaced;
    }

    public boolean wasFlooded() {
        return this.reason == EnumBlockBreakReason.flooded;
    }

    public boolean wasHarvested() {
        return this.reason == EnumBlockBreakReason.harvested;
    }

    public boolean wasHarvestedByPlayer() {
        return this.reason == EnumBlockBreakReason.harvested && this.responsible_entity instanceof uf;
    }

    public boolean wasPicked() {
        return this.reason == EnumBlockBreakReason.picked;
    }

    public boolean wasPickedByPlayer() {
        return this.wasPicked() && this.responsible_entity instanceof uf;
    }

    public boolean wasSilkHarvested() {
        return this.was_silk_harvested;
    }

    public boolean wasTrampled() {
        return this.reason == EnumBlockBreakReason.trampled;
    }

    public boolean wasExploded() {
        return this.reason == EnumBlockBreakReason.exploded;
    }

    public boolean wasSelfDropped() {
        return this.reason == EnumBlockBreakReason.self_dropped;
    }

    public boolean wasCrushed() {
        return this.reason == EnumBlockBreakReason.crushed;
    }

    public boolean wasEaten() {
        return this.reason == EnumBlockBreakReason.eaten;
    }

    public boolean wasCollidedWithEntity() {
        return this.reason == EnumBlockBreakReason.collided_with_entity;
    }

    public boolean wasSilverfish() {
        return this.reason == EnumBlockBreakReason.silverfish;
    }

    public boolean wasDrought() {
        return this.reason == EnumBlockBreakReason.drought;
    }

    public boolean wasSnowedUpon() {
        return this.reason == EnumBlockBreakReason.snowfall;
    }

    public boolean wasWindfall() {
        return this.reason == EnumBlockBreakReason.windfall;
    }

    public of getHarvester() {
        return this.wasHarvested() ? (of)this.responsible_entity : null;
    }

    public ye getHarvesterItemStack() {
        return this.getHarvester() == null ? null : this.getHarvester().getHeldItemStack();
    }

    public yc getHarvesterItem() {
        return this.getHarvesterItemStack() == null ? null : this.getHarvesterItemStack().b();
    }

    public int getHarvesterFortune() {
        return aaw.f(this.getHarvester());
    }

    public uf getResponsiblePlayer() {
        return this.responsible_entity instanceof uf ? (uf)this.responsible_entity : null;
    }

    public boolean isResponsiblePlayerInCreativeMode() {
        return this.getResponsiblePlayer() != null && this.getResponsiblePlayer().bG.d;
    }

    public float getBlockHardness() {
        return this.block.getBlockHardness(this.metadata);
    }

    public EnumBlockBreakReason getReason() {
        return this.reason;
    }

    public acq getBiome() {
        return this.world.a(this.x, this.z);
    }

    public BlockBreakInfo setDamage(int damage) {
        this.damage = damage;
        return this;
    }

    public void playSoundEffectAtBlock(String sound, float volume, float pitch) {
        if (this.world.I) {
            atv.setErrorMessage("playSoundEffect: why calling this function on client?");
        }
        this.world.a((float)this.x + 0.5f, (float)this.y + 0.5f, (float)this.z + 0.5f, sound, volume, pitch);
    }

    public int dropBlockAsItself(boolean set_block_to_air) {
        int num_drops = this.block.dropBlockAsItself(this);
        if (set_block_to_air) {
            if (this.world.getBlock(this.x, this.y, this.z) != this.block) {
                atv.setErrorMessage("dropBlockAsItself: Block mismatch");
            }
            this.world.i(this.x, this.y, this.z);
        }
        return num_drops;
    }

    public int dropBlockAsEntityItem(boolean set_block_to_air) {
        int num_drops = this.block.dropBlockAsEntityItem(this);
        if (set_block_to_air) {
            if (this.world.getBlock(this.x, this.y, this.z) != this.block) {
                atv.setErrorMessage("dropBlockAsItself: Block mismatch");
            }
            this.world.i(this.x, this.y, this.z);
        }
        return num_drops;
    }

    public BlockBreakInfo setDropCoords(int x, int y2, int z2) {
        this.drop_x = x;
        this.drop_y = y2;
        this.drop_z = z2;
        return this;
    }

    public ss createEntityItem(ye item_stack) {
        Random random = this.world.s;
        double pos_x = (double)this.x + (double)random.nextFloat() * (this.drop_bounds.d - this.drop_bounds.a) + this.drop_bounds.a;
        double pos_y = (double)this.y + (double)random.nextFloat() * (this.drop_bounds.e - this.drop_bounds.b) + this.drop_bounds.b;
        double pos_z = (double)this.z + (double)random.nextFloat() * (this.drop_bounds.f - this.drop_bounds.c) + this.drop_bounds.c;
        return new ss(this.world, pos_x, pos_y, pos_z, item_stack);
    }

    public adr getChunkIfItExists() {
        return this.world.getChunkFromBlockCoordsIfItExists(this.x, this.z);
    }
}

