/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.DrawContext;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.render.MessageRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.Minecraft;
import net.minecraft.WorldClient;

public class InfoUtils {
    private static final MessageRenderer IN_GAME_MESSAGES = new MessageRenderer(-1610612736, 0).setBackgroundStyle(true, false).setCentered(true, false).setExpandUp(true);

    public static void printActionbarMessage(String key, Object ... args) {
        InfoUtils.sendVanillaMessage(StringUtils.translate(key, args));
    }

    public static void showInGameMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showInGameMessage(type, 5000, translationKey, args);
    }

    public static void showInGameMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        IN_GAME_MESSAGES.addMessage(type, lifeTime, translationKey, args);
    }

    public static void printBooleanConfigToggleMessage(String prettyName, boolean newValue) {
        String pre = newValue ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
        String status = StringUtils.translate("toggle." + (newValue ? "on" : "off"));
        String message = StringUtils.translate("manyLib.configToggle.toggle", GuiBase.TXT_AQUA + prettyName + GuiBase.TXT_RST, pre + status + GuiBase.TXT_RST);
        InfoUtils.printActionbarMessage(message, new Object[0]);
    }

    public static void renderInGameMessages(DrawContext drawContext) {
        int x = GuiUtils.getScaledWindowWidth() / 2;
        int y = GuiUtils.getScaledWindowHeight() - 76;
        IN_GAME_MESSAGES.drawMessages(x, y, drawContext);
    }

    public static void sendVanillaMessage(String message) {
        WorldClient world = Minecraft.getMinecraft().theWorld;
        if (world != null) {
            RenderUtils.setGuiIngameInfo(message);
        }
    }
}

