/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import fi.dy.masa.malilib.api.ManyLibGuiIngame;
import fi.dy.masa.malilib.gui.DrawContext;
import fi.dy.masa.malilib.util.GuiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.FontRenderer;
import net.minecraft.MathHelper;
import net.minecraft.Minecraft;
import net.minecraft.ResourceLocation;
import net.minecraft.Tessellator;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static void setGuiIngameInfo(String string) {
        RenderUtils.setGuiIngameInfo(string, 60);
    }

    public static void setGuiIngameInfo(String string, int duration) {
        ((ManyLibGuiIngame)Minecraft.getMinecraft().ingameGUI).manyLib$setInfo(string, duration);
    }

    public static void drawCreativeTabHoveringText(String string, int x, int y, DrawContext drawContext) {
        List<String> list = Arrays.stream((string = string.replace('\uff08', '(').replace('\uff09', ')')).split("\\\\n")).map(String::trim).toList();
        if (list.size() == 1 && RenderUtils.fontRenderer().getStringWidth(list.get(0)) > 300) {
            list = Arrays.stream(string.split("[,.\uff0c\u3002]")).map(String::trim).toList();
        }
        RenderUtils.drawTextList(list, x, y, drawContext);
    }

    public static void drawTextList(List<String> stringList, int x, int y, DrawContext drawContext) {
        RenderUtils.drawTextList(stringList, x, y, true, drawContext);
    }

    public static void drawTextList(List<String> stringList, int x, int y, boolean has_title, DrawContext drawContext) {
        int height;
        if (stringList.isEmpty()) {
            return;
        }
        FontRenderer fontRenderer = RenderUtils.fontRenderer();
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        int boxWidth = 0;
        for (String textPart : stringList) {
            int stringWidth = fontRenderer.getStringWidth(textPart);
            if (stringWidth <= boxWidth) continue;
            boxWidth = stringWidth;
        }
        int stringXPos = x + 12;
        int stringYPos = y - 12;
        int boxHeight = 8;
        if (stringList.size() > 1) {
            boxHeight += 2 + (stringList.size() - 1) * 10;
        }
        if (!has_title) {
            boxHeight -= 2;
        }
        if (stringXPos + boxWidth > GuiUtils.getScaledWindowWidth()) {
            stringXPos -= 28 + boxWidth;
        }
        if (stringYPos + boxHeight + 6 > (height = GuiUtils.getScaledWindowHeight())) {
            stringYPos = height - boxHeight - 6;
        }
        int color_1 = -267386864;
        color_1 = color_1 & 0xFFFFFF | 0xEA000000;
        drawContext.drawGradientRect(stringXPos - 3, stringYPos - 4, stringXPos + boxWidth + 3, stringYPos - 3, color_1, color_1);
        drawContext.drawGradientRect(stringXPos - 3, stringYPos + boxHeight + 3, stringXPos + boxWidth + 3, stringYPos + boxHeight + 4, color_1, color_1);
        drawContext.drawGradientRect(stringXPos - 3, stringYPos - 3, stringXPos + boxWidth + 3, stringYPos + boxHeight + 3, color_1, color_1);
        drawContext.drawGradientRect(stringXPos - 4, stringYPos - 3, stringXPos - 3, stringYPos + boxHeight + 3, color_1, color_1);
        drawContext.drawGradientRect(stringXPos + boxWidth + 3, stringYPos - 3, stringXPos + boxWidth + 4, stringYPos + boxHeight + 3, color_1, color_1);
        int color_2 = 0x505000FF;
        int color_3 = (color_2 & 0xFEFEFE) >> 1 | color_2 & 0xFF000000;
        drawContext.drawGradientRect(stringXPos - 3, stringYPos - 3 + 1, stringXPos - 3 + 1, stringYPos + boxHeight + 3 - 1, color_2, color_3);
        drawContext.drawGradientRect(stringXPos + boxWidth + 2, stringYPos - 3 + 1, stringXPos + boxWidth + 3, stringYPos + boxHeight + 3 - 1, color_2, color_3);
        drawContext.drawGradientRect(stringXPos - 3, stringYPos - 3, stringXPos + boxWidth + 3, stringYPos - 3 + 1, color_2, color_2);
        drawContext.drawGradientRect(stringXPos - 3, stringYPos + boxHeight + 2, stringXPos + boxWidth + 3, stringYPos + boxHeight + 3, color_3, color_3);
        for (int stringIndex = 0; stringIndex < stringList.size(); ++stringIndex) {
            String string = stringList.get(stringIndex);
            fontRenderer.drawStringWithShadow(string, stringXPos, stringYPos, -1);
            if (stringIndex == 0 && has_title) {
                stringYPos += 2;
            }
            stringYPos += 10;
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderUtils.mc().getTextureManager().bindTexture(texture);
    }

    public static void color(float r, float g, float b, float a) {
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawOutlinedBox(x, y, width, height, colorBg, colorBorder, 0.0f);
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, colorBg, zLevel);
        RenderUtils.drawOutline(x - 1, y - 1, width + 2, height + 2, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - 1, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y, width - 2, 1, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y + height - 1, width - 2, 1, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, borderWidth, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - borderWidth, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.startDrawingQuads();
        tessellator.addVertex((double)x, (double)y, (double)zLevel);
        tessellator.addVertex((double)x, (double)(y + height), (double)zLevel);
        tessellator.addVertex((double)(x + width), (double)(y + height), (double)zLevel);
        tessellator.addVertex((double)(x + width), (double)y, (double)zLevel);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawCircle(int x, int y, int radius, int color) {
        RenderUtils.drawCircle(x, y, radius, color, 0.0f);
    }

    public static void drawCircle(int x, int y, int radius, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(2);
        int drawNum = 360;
        for (int i = 0; i < drawNum; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)drawNum);
            tessellator.addVertex((double)((float)x + (float)radius * MathHelper.cos((float)angle)), (double)((float)y - (float)radius * MathHelper.sin((float)angle)), (double)zLevel);
        }
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawDisk(int x, int y, float radius, int color) {
        RenderUtils.drawDisk(x, y, radius, color, 0.0f);
    }

    public static void drawDisk(int x, int y, float radius, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(6);
        tessellator.addVertex((double)x, (double)y, (double)zLevel);
        int drawNum = 361;
        for (int i = 0; i <= drawNum; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)drawNum);
            tessellator.addVertex((double)((float)x + radius * MathHelper.cos((float)angle)), (double)((float)y - radius * MathHelper.sin((float)angle)), (double)zLevel);
        }
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float pixelWidth = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)x, (double)(y + height), (double)zLevel, (double)((float)u * pixelWidth), (double)((float)(v + height) * pixelWidth));
        tessellator.addVertexWithUV((double)(x + width), (double)(y + height), (double)zLevel, (double)((float)(u + width) * pixelWidth), (double)((float)(v + height) * pixelWidth));
        tessellator.addVertexWithUV((double)(x + width), (double)y, (double)zLevel, (double)((float)(u + width) * pixelWidth), (double)((float)v * pixelWidth));
        tessellator.addVertexWithUV((double)x, (double)y, (double)zLevel, (double)((float)u * pixelWidth), (double)((float)v * pixelWidth));
        tessellator.draw();
    }

    public static void preDrawRect() {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void postDrawRect() {
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawHoverText(int x, int y, List<String> textLines, DrawContext drawContext) {
        Minecraft mc = RenderUtils.mc();
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2929);
            FontRenderer font = mc.fontRenderer;
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().width;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\n")) {
                    int length = font.getStringWidth(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            int lineHeight = font.FONT_HEIGHT + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            double zLevel = 300.0;
            int borderColor = -267386864;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, zLevel, fillColor1, fillColor1);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, fillColor2, fillColor2);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                drawContext.drawText(font, str, textStartX, textStartY, -1, false);
                textStartY += lineHeight;
            }
            GL11.glEnable((int)32826);
            GL11.glEnable((int)2929);
        }
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, double zLevel, int startColor, int endColor) {
        RenderUtils.preRenderGradient();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        RenderUtils.bufferGradientVertical(left, top, right, bottom, zLevel, startColor, endColor, tessellator);
        tessellator.draw();
        RenderUtils.postRenderGradient();
    }

    public static void preRenderGradient() {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
    }

    public static void postRenderGradient() {
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void bufferGradientHorizontal(int left, int top, int right, int bottom, double zLevel, int startColor, int endColor, Tessellator tessellator) {
        float startA = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startR = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startG = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startB = (float)(startColor & 0xFF) / 255.0f;
        float endA = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endR = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endG = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endB = (float)(endColor & 0xFF) / 255.0f;
        tessellator.setColorRGBA_F(startR, startG, startB, startA);
        tessellator.addVertex((double)left, (double)top, zLevel);
        tessellator.addVertex((double)left, (double)bottom, zLevel);
        tessellator.setColorRGBA_F(endR, endG, endB, endA);
        tessellator.addVertex((double)right, (double)bottom, zLevel);
        tessellator.addVertex((double)right, (double)top, zLevel);
    }

    public static void bufferGradientVertical(int left, int top, int right, int bottom, double zLevel, int startColor, int endColor, Tessellator tessellator) {
        float startA = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startR = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startG = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startB = (float)(startColor & 0xFF) / 255.0f;
        float endA = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endR = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endG = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endB = (float)(endColor & 0xFF) / 255.0f;
        tessellator.setColorRGBA_F(startR, startG, startB, startA);
        tessellator.addVertex((double)right, (double)top, zLevel);
        tessellator.addVertex((double)left, (double)top, zLevel);
        tessellator.setColorRGBA_F(endR, endG, endB, endA);
        tessellator.addVertex((double)left, (double)bottom, zLevel);
        tessellator.addVertex((double)right, (double)bottom, zLevel);
    }

    public static void drawCenteredString(int x, int y, int color, String text, DrawContext drawContext) {
        FontRenderer textRenderer = RenderUtils.mc().fontRenderer;
        drawContext.drawCenteredTextWithShadow(textRenderer, text, x, y, color);
    }

    public static void drawHorizontalLine(int x, int y, int width, int color) {
        RenderUtils.drawRect(x, y, width, 1, color);
    }

    public static void drawVerticalLine(int x, int y, int height, int color) {
        RenderUtils.drawRect(x, y, 1, height, color);
    }

    public static void startScissor(int x, int y, int width, int height) {
        GL11.glEnable((int)3089);
        int scaledWindowHeight = GuiUtils.getScaledWindowHeight();
        y = scaledWindowHeight - y - height;
        int scaleFactor = GuiUtils.getScaleFactor();
        GL11.glScissor((int)(x * scaleFactor), (int)(y * scaleFactor), (int)(width * scaleFactor), (int)(height * scaleFactor));
    }

    public static void endScissor() {
        GL11.glDisable((int)3089);
    }

    private static Minecraft mc() {
        return Minecraft.getMinecraft();
    }

    public static FontRenderer fontRenderer() {
        return RenderUtils.mc().fontRenderer;
    }
}

