/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.hotkeys;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.interfaces.IConfigResettable;
import fi.dy.masa.malilib.config.interfaces.IStringRepresentable;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.JsonUtils;
import java.util.List;
import javax.annotation.Nullable;

public interface IKeybind
extends IConfigResettable,
IStringRepresentable {
    public boolean isValid();

    public boolean isPressed();

    public boolean isKeybindHeld();

    public boolean updateIsPressed();

    public KeybindSettings getSettings();

    public KeybindSettings getDefaultSettings();

    public void setSettings(KeybindSettings var1);

    public void clearKeys();

    public void addKey(int var1);

    public void removeKey(int var1);

    public boolean matches(int var1);

    public boolean overlaps(IKeybind var1);

    public void tick();

    public String getKeysDisplayString();

    public List<Integer> getKeys();

    public void setCallback(@Nullable IHotkeyCallback var1);

    public boolean areSettingsModified();

    public void resetSettingsToDefaults();

    default public JsonElement getAsJsonElement() {
        JsonObject obj = new JsonObject();
        obj.add("keys", (JsonElement)new JsonPrimitive(this.getStringValue()));
        if (this.areSettingsModified()) {
            obj.add("settings", (JsonElement)this.getSettings().toJson());
        }
        return obj;
    }

    default public void setValueFromJsonElement(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            if (JsonUtils.hasString(obj, "keys")) {
                this.setValueFromString(obj.get("keys").getAsString());
            }
            if (JsonUtils.hasObject(obj, "settings")) {
                this.setSettings(KeybindSettings.fromJson(obj.getAsJsonObject("settings")));
            }
        }
    }
}

