/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.screen.util;

import fi.dy.masa.malilib.config.interfaces.ConfigType;
import fi.dy.masa.malilib.config.interfaces.IConfigDisplay;
import fi.dy.masa.malilib.config.interfaces.IConfigHandler;
import fi.dy.masa.malilib.config.interfaces.IConfigResettable;
import fi.dy.masa.malilib.config.interfaces.IStringRepresentable;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.config.options.ConfigEnum;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.feat.SortCategory;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.PeriodicButton;
import fi.dy.masa.malilib.gui.button.PullDownButton;
import fi.dy.masa.malilib.gui.button.ResetButton;
import fi.dy.masa.malilib.gui.button.ScrollBar;
import fi.dy.masa.malilib.gui.button.SearchField;
import fi.dy.masa.malilib.gui.button.SliderButton;
import fi.dy.masa.malilib.gui.button.interfaces.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.screen.interfaces.Searchable;
import fi.dy.masa.malilib.gui.screen.interfaces.StatusScreen;
import fi.dy.masa.malilib.gui.screen.util.ColorBoard;
import fi.dy.masa.malilib.gui.screen.util.DropDownEntry;
import fi.dy.masa.malilib.gui.screen.util.SlideableToggleButton;
import fi.dy.masa.malilib.gui.screen.util.WidthAdder;
import fi.dy.masa.malilib.gui.widgets.WidgetText;
import fi.dy.masa.malilib.gui.widgets.WidgetTextField;
import fi.dy.masa.malilib.gui.widgets.WidgetTextFieldColor;
import fi.dy.masa.malilib.gui.widgets.WidgetTextFieldDouble;
import fi.dy.masa.malilib.gui.widgets.WidgetTextFieldInteger;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.FontRenderer;
import net.minecraft.GuiScreen;

public class ScreenConstants {
    private static final int commonButtonXFromRight = -200;
    private static final int commonButtonWidth = 115;
    private static final int hotKeyFirstButtonXFromRight = -300;
    private static final int shortHotkeyButtonWidth = 110;
    private static final int commonHotkeyButtonWidth = 155;
    private static final int keySettingButtonXFromRight = -140;
    private static final int keySettingButtonXWidth = 55;
    private static final int resetButtonXFromRight = -80;
    private static final int scrollBarXFromRight = -40;
    private static final int configToggleButtonXWidth = 40;
    private static final int nameX = 20;
    private static final int pullDownButtonXFromRight = -120;
    public static final int oneScroll = 3;
    public static final int confirmFlag = 0;
    public static final int commonButtonHeight = 20;
    public static final int commentedTextShift = 6;

    public static int getYPos(int index, GuiScreen screen) {
        int capacity;
        if (screen instanceof StatusScreen) {
            StatusScreen statusScreen = (StatusScreen)screen;
            capacity = statusScreen.getMaxCapacity();
        } else {
            capacity = 7;
        }
        return screen.height / 6 + 22 * index + 32 - capacity * 22 + 154;
    }

    static <T extends ConfigBase<?>> WidgetText getCommentedText(int index, T config, GuiScreen screen) {
        WidgetText widgetText = new WidgetText(20, ScreenConstants.getYPos(index, screen) + 6, config.getConfigGuiDisplayName(), config.getConfigGuiDisplayComment(), ((IConfigDisplay)((Object)config)).getDisplayColor());
        ConfigType type = config.getType();
        int right = type == ConfigType.HOTKEY || type == ConfigType.TOGGLE ? screen.width + -300 : screen.width + -200;
        widgetText.setCommentIntervalX(-20, right - 20);
        return widgetText;
    }

    static <T extends IConfigResettable> ButtonGeneric getResetButton(int index, GuiScreen screen, T config, IButtonActionListener onPress) {
        ResetButton buttonGeneric = new ResetButton(screen.width + -80, ScreenConstants.getYPos(index, screen), config::isModified, onPress);
        buttonGeneric.setHoverStrings(StringUtils.translate("manyLib.gui.button.reset"));
        return buttonGeneric;
    }

    static <T extends ConfigBase<?>> TextFieldWrapper<WidgetTextField> getTextFieldWrapper(int index, T config, GuiScreen screen) {
        return new TextFieldWrapper<WidgetTextField>(new WidgetTextField(screen.width + -200 + 2, ScreenConstants.getYPos(index, screen) + 1, 113, 18), textField -> ((IStringRepresentable)((Object)config)).setValueFromString(textField.getText()));
    }

    static <T extends ConfigBase<T>> TextFieldWrapper<WidgetTextField> getWrapperForSlideable(int index, final T config, final Supplier<String> setStringOnFinish, GuiScreen screen) {
        ConfigType type = config.getType();
        WidgetTextField widgetTextField = type == ConfigType.DOUBLE ? new WidgetTextFieldDouble(screen.width + -200 + 2, ScreenConstants.getYPos(index, screen) + 1, 93, 18) : new WidgetTextFieldInteger(screen.width + -200 + 2, ScreenConstants.getYPos(index, screen) + 1, 93, 18);
        return new TextFieldWrapper<WidgetTextField>(widgetTextField, new ITextFieldListener<WidgetTextField>(){

            @Override
            public void onTextChange(WidgetTextField textField) {
                ((IStringRepresentable)((Object)config)).setValueFromString(textField.getText());
            }

            @Override
            public void onFinish(WidgetTextField textField) {
                textField.setText((String)setStringOnFinish.get());
            }
        });
    }

    static TextFieldWrapper<WidgetTextFieldColor> getWrapperForColor(int index, ConfigColor config, GuiScreen screen) {
        return new TextFieldWrapper<WidgetTextFieldColor>(new WidgetTextFieldColor(screen.width + -200 + 2, ScreenConstants.getYPos(index, screen) + 1, 93, 18), textField -> config.setValueFromString(textField.getText()));
    }

    static ColorBoard getColorBoard(int index, ConfigColor configColor, GuiScreen screen) {
        return new ColorBoard(configColor, screen.width + -200 + 115 - 15, ScreenConstants.getYPos(index, screen) + 2, 16, 16);
    }

    static <T extends ConfigBase<T> & IConfigDisplay> PeriodicButton<T> getPeriodicButton(int index, T config, GuiScreen screen) {
        return new PeriodicButton<T>(screen.width + -200, ScreenConstants.getYPos(index, screen), 115, 20, config);
    }

    static ButtonBase getCommonButton(int index, String content, GuiScreen screen, IButtonActionListener onPress) {
        return ButtonGeneric.builder(content, onPress).dimensions(screen.width + -200, ScreenConstants.getYPos(index, screen), 115, 20).build();
    }

    static ButtonBase getHotkeyButton(int index, ConfigHotkey config, GuiScreen screen, IButtonActionListener onPress) {
        boolean isShort = config.getType() == ConfigType.TOGGLE;
        int xPos = screen.width + -300;
        int width = isShort ? 110 : 155;
        return ButtonGeneric.builder("", onPress).dimensions(xPos, ScreenConstants.getYPos(index, screen), width, 20).build();
    }

    static ButtonBase getJumpButton(int index, GuiScreen screen, IButtonActionListener onPress) {
        return ButtonGeneric.builder(StringUtils.translate("manyLib.gui.button.keySettings"), onPress).dimensions(screen.width + -140, ScreenConstants.getYPos(index, screen), 55, 20).build();
    }

    static <T extends ConfigBase<T> & IConfigDisplay> SliderButton<T> getSliderButton(int index, T config, GuiScreen screen) {
        return new SliderButton<T>(screen.width + -200, ScreenConstants.getYPos(index, screen), 95, 20, config);
    }

    static SlideableToggleButton getSlideableToggleButton(int index, boolean useSlider, GuiScreen screen, IButtonActionListener onPress) {
        return new SlideableToggleButton(screen.width + -200 + 115 - 15, ScreenConstants.getYPos(index, screen) + 2, useSlider, onPress);
    }

    static ButtonBase getConfigToggleButton(int index, GuiScreen screen, IButtonActionListener onPress) {
        return ButtonGeneric.builder("", onPress).dimensions(screen.width + -300 + 110 + 5, ScreenConstants.getYPos(index, screen), 40, 20).build();
    }

    public static PullDownButton<DropDownEntry> getPullDownButton(GuiScreen screen, IConfigHandler configInstance) {
        return new PullDownButton<DropDownEntry>(screen.width + -120, 10, 100, 16, configInstance.getName(), StringUtils.translate("manyLib.gui.button.other_mods"), (index, startX, startY, present, content, listener) -> new DropDownEntry(startX, startY + index * 16, present, content, listener));
    }

    public static <T extends GuiScreen> ScrollBar<?> getScrollBar(T screen, int pageCapacity, int maxStatus) {
        return new ScrollBar<T>(screen.width + -40, ScreenConstants.getYPos(0, screen), 8, 22 * ((StatusScreen)screen).getMaxCapacity() - 2, pageCapacity, maxStatus, screen);
    }

    public static ButtonGeneric getResetAllButton(WidthAdder widthAdder, BooleanSupplier predicate, IButtonActionListener onPress) {
        ResetButton resetButton = new ResetButton(widthAdder.getWidth(), 30, predicate, onPress);
        resetButton.setHoverStrings(StringUtils.translate("manyLib.gui.button.reset_all"));
        widthAdder.addWidth(25);
        return resetButton;
    }

    public static PeriodicButton<?> getSortButton(GuiScreen screen, WidthAdder widthAdder, int y, ConfigEnum<SortCategory> sortCategory, IButtonActionListener onPress) {
        int stringWidth = ScreenConstants.getMaxStringWidth(screen.fontRenderer, sortCategory);
        int width = widthAdder.getWidth();
        widthAdder.addWidth(stringWidth + 15);
        return new PeriodicButton<ConfigEnum<SortCategory>>(width, y, stringWidth + 10, 20, sortCategory, onPress);
    }

    private static int getMaxStringWidth(FontRenderer fontRenderer, ConfigEnum<SortCategory> sortCategory) {
        int maxWidth = 0;
        for (SortCategory value : SortCategory.values()) {
            ConfigEnum<SortCategory> temp = new ConfigEnum<SortCategory>(sortCategory.getName(), value);
            int stringWidth = fontRenderer.getStringWidth(temp.getDisplayText());
            if (stringWidth <= maxWidth) continue;
            maxWidth = stringWidth;
        }
        return maxWidth;
    }

    public static <T extends GuiScreen & StatusScreen> SearchField getSearchButton(T screen) {
        return new SearchField(23, ScreenConstants.getSearchFieldY(screen), screen.width - 95, 13, (Searchable)screen);
    }

    static <T extends GuiScreen & StatusScreen> int getSearchFieldY(T screen) {
        return 35 - 22 * ((StatusScreen)screen).getMaxCapacity() + 176;
    }
}

